/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class DSASigner
implements DSA {
    DSAKeyParameters key;
    SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (DSAPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (DSAPrivateKeyParameters)param;
            }
        } else {
            this.key = (DSAPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k2;
        DSAParameters params = this.key.getParameters();
        BigInteger m2 = this.calculateE(params.getQ(), message);
        int qBitLength = params.getQ().bitLength();
        while ((k2 = new BigInteger(qBitLength, this.random)).compareTo(params.getQ()) >= 0) {
        }
        BigInteger r2 = params.getG().modPow(k2, params.getP()).mod(params.getQ());
        k2 = k2.modInverse(params.getQ()).multiply(m2.add(((DSAPrivateKeyParameters)this.key).getX().multiply(r2)));
        BigInteger s2 = k2.mod(params.getQ());
        BigInteger[] res = new BigInteger[]{r2, s2};
        return res;
    }

    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        DSAParameters params = this.key.getParameters();
        BigInteger m2 = this.calculateE(params.getQ(), message);
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r2) >= 0 || params.getQ().compareTo(r2) <= 0) {
            return false;
        }
        if (zero.compareTo(s2) >= 0 || params.getQ().compareTo(s2) <= 0) {
            return false;
        }
        BigInteger w2 = s2.modInverse(params.getQ());
        BigInteger u1 = m2.multiply(w2).mod(params.getQ());
        BigInteger u2 = r2.multiply(w2).mod(params.getQ());
        u1 = params.getG().modPow(u1, params.getP());
        u2 = ((DSAPublicKeyParameters)this.key).getY().modPow(u2, params.getP());
        BigInteger v2 = u1.multiply(u2).mod(params.getP()).mod(params.getQ());
        return v2.equals(r2);
    }

    private BigInteger calculateE(BigInteger n2, byte[] message) {
        if (n2.bitLength() >= message.length * 8) {
            return new BigInteger(1, message);
        }
        byte[] trunc = new byte[n2.bitLength() / 8];
        System.arraycopy(message, 0, trunc, 0, trunc.length);
        return new BigInteger(1, trunc);
    }
}

