/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cms.ContentInfo;

public class TimeStampResp
extends ASN1Object {
    PKIStatusInfo pkiStatusInfo;
    ContentInfo timeStampToken;

    public static TimeStampResp getInstance(Object o2) {
        if (o2 instanceof TimeStampResp) {
            return (TimeStampResp)o2;
        }
        if (o2 != null) {
            return new TimeStampResp(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private TimeStampResp(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        this.pkiStatusInfo = PKIStatusInfo.getInstance(e2.nextElement());
        if (e2.hasMoreElements()) {
            this.timeStampToken = ContentInfo.getInstance(e2.nextElement());
        }
    }

    public TimeStampResp(PKIStatusInfo pkiStatusInfo, ContentInfo timeStampToken) {
        this.pkiStatusInfo = pkiStatusInfo;
        this.timeStampToken = timeStampToken;
    }

    public PKIStatusInfo getStatus() {
        return this.pkiStatusInfo;
    }

    public ContentInfo getTimeStampToken() {
        return this.timeStampToken;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.pkiStatusInfo);
        if (this.timeStampToken != null) {
            v2.add(this.timeStampToken);
        }
        return new DERSequence(v2);
    }
}

