/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentChildNode;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

public abstract class AbstractEntityReference
extends AbstractParentChildNode
implements EntityReference {
    protected String nodeName;

    protected AbstractEntityReference() {
    }

    protected AbstractEntityReference(String name, AbstractDocument owner) throws DOMException {
        this.ownerDocument = owner;
        if (owner.getStrictErrorChecking() && !DOMUtilities.isValidName(name)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{name});
        }
        this.nodeName = name;
    }

    public short getNodeType() {
        return 5;
    }

    public void setNodeName(String v2) {
        this.nodeName = v2;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    protected Node export(Node n2, AbstractDocument d2) {
        super.export(n2, d2);
        AbstractEntityReference ae = (AbstractEntityReference)n2;
        ae.nodeName = this.nodeName;
        return n2;
    }

    protected Node deepExport(Node n2, AbstractDocument d2) {
        super.deepExport(n2, d2);
        AbstractEntityReference ae = (AbstractEntityReference)n2;
        ae.nodeName = this.nodeName;
        return n2;
    }

    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        AbstractEntityReference ae = (AbstractEntityReference)n2;
        ae.nodeName = this.nodeName;
        return n2;
    }

    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        AbstractEntityReference ae = (AbstractEntityReference)n2;
        ae.nodeName = this.nodeName;
        return n2;
    }

    protected void checkChildType(Node n2, boolean replace) {
        switch (n2.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(n2.getNodeType()), n2.getNodeName()});
            }
        }
    }
}

