/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.regex.Pattern;
import net.sf.samtools.util.LineReader;

public class StringLineReader
implements LineReader {
    private static final Pattern CRLF = Pattern.compile("\r\n");
    private final String theString;
    private int curPos = 0;
    private int lineNumber = 0;

    public StringLineReader(String s2) {
        this.theString = CRLF.matcher(s2).replaceAll("\n").replace('\r', '\n');
    }

    @Override
    public String readLine() {
        return this.readLine(false);
    }

    private String readLine(boolean includeTerminators) {
        if (this.curPos == this.theString.length()) {
            return null;
        }
        int nextLfIndex = this.theString.indexOf(10, this.curPos);
        if (nextLfIndex == -1) {
            int startPos = this.curPos;
            this.curPos = this.theString.length();
            ++this.lineNumber;
            return this.theString.substring(startPos);
        }
        int startPos = this.curPos;
        int endPos = nextLfIndex + (includeTerminators ? 1 : 0);
        this.curPos = nextLfIndex + 1;
        ++this.lineNumber;
        return this.theString.substring(startPos, endPos);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int peek() {
        if (this.curPos == this.theString.length()) {
            return -1;
        }
        return this.theString.charAt(this.curPos);
    }

    @Override
    public void close() {
        this.curPos = this.theString.length();
    }
}

