/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static final Comparator<Object> OBJECT_TOSTRING_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public static <T> List<T> makeList(T ... list) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, list);
        return result;
    }

    public static <T> Set<T> makeSet(T ... list) {
        HashSet result = new HashSet();
        Collections.addAll(result, list);
        return result;
    }

    public static <T> Collection<T> makeCollection(Iterator<T> i2) {
        LinkedList<T> list = new LinkedList<T>();
        while (i2.hasNext()) {
            list.add(i2.next());
        }
        return list;
    }

    public static String join(Collection<?> items, String inBetween) {
        StringBuilder builder = new StringBuilder();
        for (Object item : items) {
            if (builder.length() > 0) {
                builder.append(inBetween);
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static <T> T getSoleElement(Collection<T> items) {
        if (items.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected a single element in %s, but found %s.", items, items.size()));
        }
        return items.iterator().next();
    }

    public static <K, V> Map<K, Collection<V>> partition(Collection<V> collection, Partitioner<V, K> p2) {
        MultiMap<K, V> partitionToValues = new MultiMap<K, V>();
        for (V entry : collection) {
            partitionToValues.append(p2.getPartition(entry), entry);
        }
        return partitionToValues;
    }

    public static class DefaultingMap<K, V>
    extends HashMap<K, V> {
        final Factory<V, K> defaultGenerator;
        final boolean injectValueOnDefault;

        public DefaultingMap(final V defaultValue) {
            this(new Factory<V, K>(){

                @Override
                public V make(K k2) {
                    return defaultValue;
                }
            }, false);
        }

        public DefaultingMap(Factory<V, K> defaultGenerator, boolean injectValueOnDefaulting) {
            this.defaultGenerator = defaultGenerator;
            this.injectValueOnDefault = injectValueOnDefaulting;
        }

        @Override
        public V get(Object key) {
            if (!this.containsKey(key)) {
                V val = this.defaultGenerator.make(key);
                if (this.injectValueOnDefault) {
                    this.put(key, val);
                }
                return val;
            }
            return super.get(key);
        }

        public static interface Factory<V, K> {
            public V make(K var1);
        }
    }

    public static abstract class Partitioner<V, K> {
        public abstract K getPartition(V var1);
    }

    public static class MultiMap<K, V>
    extends HashMap<K, Collection<V>> {
        public void append(K k2, V v2) {
            this.initializeKeyIfUninitialized(k2);
            ((Collection)this.get(k2)).add(v2);
        }

        public void appendAll(K k2, Collection<? extends V> v2) {
            this.initializeKeyIfUninitialized(k2);
            ((Collection)this.get(k2)).addAll(v2);
        }

        private void initializeKeyIfUninitialized(K k2) {
            if (!this.containsKey(k2)) {
                this.put(k2, new LinkedList());
            }
        }
    }
}

