/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.sf.samtools.seekablestream.SeekableStream;

public class SeekableFileStream
extends SeekableStream {
    static Collection<SeekableFileStream> allInstances = Collections.synchronizedCollection(new HashSet());
    File file;
    RandomAccessFile fis;

    public SeekableFileStream(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new RandomAccessFile(file, "r");
        allInstances.add(this);
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean eof() throws IOException {
        return this.fis.length() == this.fis.getFilePointer();
    }

    @Override
    public void seek(long position) throws IOException {
        this.fis.seek(position);
    }

    @Override
    public long position() throws IOException {
        return this.fis.getChannel().position();
    }

    @Override
    public long skip(long n2) throws IOException {
        long initPos = this.position();
        this.fis.getChannel().position(initPos + n2);
        return this.position() - initPos;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n2;
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n2 = 0; n2 < length; n2 += count) {
            count = this.fis.read(buffer, offset + n2, length - n2);
            if (count >= 0) continue;
            if (n2 > 0) {
                return n2;
            }
            return count;
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.fis.read(b2);
    }

    @Override
    public String getSource() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void close() throws IOException {
        allInstances.remove(this);
        this.fis.close();
    }

    public static synchronized void closeAllInstances() {
        HashSet<SeekableFileStream> clonedInstances = new HashSet<SeekableFileStream>();
        clonedInstances.addAll(allInstances);
        for (SeekableFileStream sfs : clonedInstances) {
            try {
                sfs.close();
            }
            catch (IOException iOException) {}
        }
        allInstances.clear();
    }
}

