/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.samtools.seekablestream.UserPasswordInput;
import net.sf.samtools.util.ftp.FTPClient;
import net.sf.samtools.util.ftp.FTPReply;
import net.sf.samtools.util.ftp.FTPUtils;

public class SeekableFTPStreamHelper {
    private long position = 0L;
    private long contentLength = -1L;
    private String host;
    private String path;
    private String userInfo;
    FTPClient ftp = null;
    private UserPasswordInput userPasswordInput;

    SeekableFTPStreamHelper(URL url, UserPasswordInput userPasswordInput) throws IOException {
        this.userInfo = url.getUserInfo();
        this.host = url.getHost();
        this.path = url.getPath();
        this.userPasswordInput = userPasswordInput;
        this.ftp = FTPUtils.connect(this.host, this.userInfo, userPasswordInput);
        this.ftp.binary();
        FTPReply reply = this.ftp.size(this.path);
        if (reply.isSuccess()) {
            this.contentLength = Long.parseLong(reply.getReplyString());
        }
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public boolean eof() throws IOException {
        return false;
    }

    public long length() {
        return this.contentLength;
    }

    public long skip(long n2) throws IOException {
        long bytesToSkip = n2;
        this.position += bytesToSkip;
        if (this.ftp != null) {
            this.ftp.setRestPosition(this.position);
        }
        return bytesToSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.ftp == null) {
            this.ftp = FTPUtils.connect(this.host, this.userInfo, this.userPasswordInput);
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            FTPReply reply = this.ftp.pasv();
            if (this.contentLength >= 0L && this.position >= this.contentLength) {
                int n3 = -1;
                return n3;
            }
            if (this.position > 0L) {
                this.ftp.setRestPosition(this.position);
            }
            reply = this.ftp.retr(this.path);
            InputStream is = this.ftp.getDataStream();
            while (n2 < len) {
                int count = is.read(buffer, offset + n2, len - n2);
                if (count < 0) {
                    if (n2 != 0) break;
                    int n4 = -1;
                    return n4;
                }
                n2 += count;
            }
            this.position += (long)n2;
            int n5 = n2;
            return n5;
        }
        catch (EOFException e2) {
            if (n2 < 0) {
                int n6 = -1;
                return n6;
            }
            this.position += (long)n2;
            int n7 = n2;
            return n7;
        }
        finally {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    private void reconnect() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
        }
        this.ftp = FTPUtils.connect(this.host, this.userInfo, this.userPasswordInput);
    }

    public void close() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }
}

