/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

public class SolexaQualityConverter {
    public static final int SOLEXA_ADDEND = 64;
    public static final int PHRED_ADDEND = 33;
    private static SolexaQualityConverter singleton = null;
    private final byte[] phredScore = new byte[256];

    public static synchronized SolexaQualityConverter getSingleton() {
        if (singleton == null) {
            singleton = new SolexaQualityConverter();
        }
        return singleton;
    }

    private SolexaQualityConverter() {
        int i2;
        for (i2 = 0; i2 < 64; ++i2) {
            this.phredScore[i2] = 0;
        }
        for (i2 = 64; i2 < this.phredScore.length; ++i2) {
            this.phredScore[i2] = this.convertSolexaQualityCharToPhredBinary(i2);
        }
    }

    private byte convertSolexaQualityCharToPhredBinary(int solexaQuality) {
        return (byte)Math.round(10.0 * Math.log10(1.0 + Math.pow(10.0, (double)(solexaQuality - 64) / 10.0)));
    }

    public byte solexaCharToPhredBinary(byte solexaQuality) {
        return this.phredScore[solexaQuality];
    }

    public byte[] getSolexaToPhredConversionTable() {
        return this.phredScore;
    }

    public void convertSolexaQualityCharsToPhredBinary(byte[] solexaQuals) {
        for (int i2 = 0; i2 < solexaQuals.length; ++i2) {
            solexaQuals[i2] = this.phredScore[solexaQuals[i2]];
        }
    }

    public void convertSolexaQualityCharsToPhredChars(byte[] solexaQuals) {
        for (int i2 = 0; i2 < solexaQuals.length; ++i2) {
            solexaQuals[i2] = (byte)(this.phredScore[solexaQuals[i2]] + 33 & 0xFF);
        }
    }

    public void convertSolexa_1_3_QualityCharsToPhredBinary(byte[] solexaQuals) {
        int i2 = 0;
        while (i2 < solexaQuals.length) {
            int n2 = i2++;
            solexaQuals[n2] = (byte)(solexaQuals[n2] - 64);
        }
    }

    public void convertSolexa_1_3_QualityCharsToPhredBinary(int offset, int length, byte[] solexaQuals) {
        int limit = offset + length;
        int i2 = offset;
        while (i2 < limit) {
            int n2 = i2++;
            solexaQuals[n2] = (byte)(solexaQuals[n2] - 64);
        }
    }
}

