/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.sf.picard.PicardException;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class ProcessExecutor {
    private static final Log log = Log.getInstance(ProcessExecutor.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r2) {
            return new Thread(r2, "ProcessExecutor Thread");
        }
    });

    public static int execute(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable t2) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", command) + "]", t2);
        }
    }

    public static int execute(String[] commandParts) {
        return ProcessExecutor.execute(commandParts, null);
    }

    public static int execute(String[] commandParts, String outputStreamString) {
        try {
            Process process = Runtime.getRuntime().exec(commandParts);
            if (outputStreamString != null) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                writer.write(outputStreamString);
                writer.newLine();
                writer.close();
            }
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable t2) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", commandParts) + "]", t2);
        }
    }

    public static String executeAndReturnResult(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            StringBuilderProcessOutputReader err = new StringBuilderProcessOutputReader(process.getErrorStream());
            Future<?> stderrReader = executorService.submit(err);
            StringBuilderProcessOutputReader stdout = new StringBuilderProcessOutputReader(process.getInputStream());
            stdout.run();
            stderrReader.get();
            int result = process.waitFor();
            return result == 0 ? stdout.getOutput() : err.getOutput();
        }
        catch (Throwable t2) {
            throw new PicardException("Unexpected exception executing [" + command + "]", t2);
        }
    }

    public static ExitStatusAndOutput executeAndReturnInterleavedOutput(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            return ProcessExecutor.interleaveProcessOutput(process);
        }
        catch (Throwable t2) {
            throw new PicardException("Unexpected exception executing [" + command + "]", t2);
        }
    }

    public static ExitStatusAndOutput executeAndReturnInterleavedOutput(String[] commandArray) {
        try {
            Process process = Runtime.getRuntime().exec(commandArray);
            return ProcessExecutor.interleaveProcessOutput(process);
        }
        catch (Throwable t2) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", commandArray) + "]", t2);
        }
    }

    private static ExitStatusAndOutput interleaveProcessOutput(Process process) throws InterruptedException, IOException {
        BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder sb = new StringBuilder();
        String stdoutLine = null;
        String stderrLine = null;
        while ((stderrLine = stderrReader.readLine()) != null || (stdoutLine = stdoutReader.readLine()) != null) {
            if (stderrLine != null) {
                sb.append(stderrLine).append('\n');
            }
            if (stdoutLine != null) {
                sb.append(stdoutLine).append('\n');
            }
            stderrLine = null;
            stdoutLine = null;
        }
        return new ExitStatusAndOutput(process.waitFor(), sb.toString(), null);
    }

    private static int readStreamsAndWaitFor(Process process) throws InterruptedException, ExecutionException {
        Future<?> stderrReader = executorService.submit(new LogErrorProcessOutputReader(process.getErrorStream()));
        new LogInfoProcessOutputReader(process.getInputStream()).run();
        stderrReader.get();
        return process.waitFor();
    }

    private static class StringBuilderProcessOutputReader
    extends ProcessOutputReader {
        private final StringBuilder sb = new StringBuilder();

        public StringBuilderProcessOutputReader(InputStream stream) {
            super(stream);
        }

        @Override
        protected void write(String message) {
            this.sb.append(message).append("\n");
        }

        public String getOutput() {
            return this.sb.toString();
        }
    }

    private static class LogInfoProcessOutputReader
    extends ProcessOutputReader {
        public LogInfoProcessOutputReader(InputStream stream) {
            super(stream);
        }

        @Override
        protected void write(String message) {
            log.info(message);
        }
    }

    private static class LogErrorProcessOutputReader
    extends ProcessOutputReader {
        public LogErrorProcessOutputReader(InputStream stream) {
            super(stream);
        }

        @Override
        protected void write(String message) {
            log.error(message);
        }
    }

    private static abstract class ProcessOutputReader
    implements Runnable {
        private final BufferedReader reader;

        public ProcessOutputReader(InputStream stream) {
            this.reader = new BufferedReader(new InputStreamReader(stream));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.write(line);
                }
            }
            catch (IOException e2) {
                throw new PicardException("Unexpected exception reading from process stream", e2);
            }
        }

        protected abstract void write(String var1);
    }

    public static class ExitStatusAndOutput {
        public final int exitStatus;
        public final String stdout;
        public final String stderr;

        public ExitStatusAndOutput(int exitStatus, String stdout, String stderr) {
            this.exitStatus = exitStatus;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

