/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import net.sf.picard.metrics.MetricBase;
import net.sf.picard.util.Histogram;

public class DuplicationMetrics
extends MetricBase {
    public String LIBRARY;
    public long UNPAIRED_READS_EXAMINED;
    public long READ_PAIRS_EXAMINED;
    public long UNMAPPED_READS;
    public long UNPAIRED_READ_DUPLICATES;
    public long READ_PAIR_DUPLICATES;
    public long READ_PAIR_OPTICAL_DUPLICATES;
    public Double PERCENT_DUPLICATION;
    public Long ESTIMATED_LIBRARY_SIZE;

    public void calculateDerivedMetrics() {
        this.ESTIMATED_LIBRARY_SIZE = DuplicationMetrics.estimateLibrarySize(this.READ_PAIRS_EXAMINED - this.READ_PAIR_OPTICAL_DUPLICATES, this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES);
        this.PERCENT_DUPLICATION = (double)(this.UNPAIRED_READ_DUPLICATES + this.READ_PAIR_DUPLICATES * 2L) / (double)(this.UNPAIRED_READS_EXAMINED + this.READ_PAIRS_EXAMINED * 2L);
    }

    public static Long estimateLibrarySize(long readPairs, long uniqueReadPairs) {
        long readPairDuplicates = readPairs - uniqueReadPairs;
        if (readPairs > 0L && readPairDuplicates > 0L) {
            double r2;
            double u2;
            long n2 = readPairs;
            long c2 = uniqueReadPairs;
            double m2 = 1.0;
            double M = 100.0;
            if (c2 >= n2 || DuplicationMetrics.f(m2 * (double)c2, c2, n2) < 0.0) {
                throw new IllegalStateException("Invalid values for pairs and unique pairs: " + n2 + ", " + c2);
            }
            while (DuplicationMetrics.f(M * (double)c2, c2, n2) >= 0.0) {
                M *= 10.0;
            }
            for (int i2 = 0; i2 < 40 && (u2 = DuplicationMetrics.f((r2 = (m2 + M) / 2.0) * (double)c2, c2, n2)) != 0.0; ++i2) {
                if (u2 > 0.0) {
                    m2 = r2;
                    continue;
                }
                if (!(u2 < 0.0)) continue;
                M = r2;
            }
            return (long)((double)c2 * (m2 + M) / 2.0);
        }
        return null;
    }

    private static double f(double x2, double c2, double n2) {
        return c2 / x2 - 1.0 + Math.exp(-n2 / x2);
    }

    public static double estimateRoi(long estimatedLibrarySize, double x2, long pairs, long uniquePairs) {
        return (double)estimatedLibrarySize * (1.0 - Math.exp(-(x2 * (double)pairs) / (double)estimatedLibrarySize)) / (double)uniquePairs;
    }

    public Histogram<Double> calculateRoiHistogram() {
        if (this.ESTIMATED_LIBRARY_SIZE == null) {
            try {
                this.calculateDerivedMetrics();
                if (this.ESTIMATED_LIBRARY_SIZE == null) {
                    return null;
                }
            }
            catch (IllegalStateException ise) {
                return null;
            }
        }
        long uniquePairs = this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES;
        Histogram<Double> histo = new Histogram<Double>();
        for (double x2 = 1.0; x2 <= 100.0; x2 += 1.0) {
            histo.increment(x2, DuplicationMetrics.estimateRoi(this.ESTIMATED_LIBRARY_SIZE, x2, this.READ_PAIRS_EXAMINED, uniquePairs));
        }
        return histo;
    }

    public static void main(String[] args) {
        DuplicationMetrics m2 = new DuplicationMetrics();
        m2.READ_PAIRS_EXAMINED = Integer.parseInt(args[0]);
        m2.READ_PAIR_DUPLICATES = Integer.parseInt(args[1]);
        m2.calculateDerivedMetrics();
        System.out.println("Percent Duplication: " + m2.PERCENT_DUPLICATION);
        System.out.println("Est. Library Size  : " + m2.ESTIMATED_LIBRARY_SIZE);
        System.out.println();
        System.out.println("X Seq\tX Unique");
        for (Histogram.Bin bin : m2.calculateRoiHistogram().values()) {
            System.out.println(bin.getId() + "\t" + bin.getValue());
        }
    }
}

