/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaTextIterator;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.QseqReadData;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.util.BasicInputParser;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.SolexaQualityConverter;

class QseqReadParser {
    public static final int MACHINE_COLUMN = 0;
    public static final int RUN__COLUMN = 1;
    public static final int LANE_COLUMN = 2;
    public static final int TILE_COLUMN = 3;
    public static final int X_COLUMN = 4;
    public static final int Y_COLUMN = 5;
    public static final int PF_COLUMN = 10;
    public static final int BASES_COLUMN = 8;
    public static final int QUALS_COLUMN = 9;
    private final IlluminaTextIterator textParser;
    private final FormatUtil formatter;
    private final Range[] srcRanges;
    private final OutputMapping.TwoDIndex[] dstStarts;
    private final int[] copyLengths;
    protected final int readLength;
    private static final SolexaQualityConverter qualConverter = SolexaQualityConverter.getSingleton();

    public QseqReadParser(int lane, IlluminaFileMap tilesToReadFiles, Range[] srcRanges, OutputMapping.TwoDIndex[] dstStarts, OutputMapping outputMapping) {
        this.textParser = new IlluminaTextIterator(lane, tilesToReadFiles);
        this.formatter = new FormatUtil();
        this.readLength = QseqReadParser.getReadLength((File)tilesToReadFiles.firstEntry().getValue());
        this.srcRanges = srcRanges;
        this.dstStarts = dstStarts;
        this.copyLengths = new int[srcRanges.length];
        for (int i2 = 0; i2 < this.copyLengths.length; ++i2) {
            this.copyLengths[i2] = srcRanges[i2].length;
        }
    }

    public void seekToTile(int oneBasedTileNumber) {
        this.textParser.seekToTile(oneBasedTileNumber);
    }

    public boolean hasNext() {
        return this.textParser.hasNext();
    }

    public void next(QseqReadData readData) {
        String[] fields = this.textParser.next();
        int lane = this.formatter.parseInt(fields[2]);
        this.textParser.validateLane(lane);
        int tile = this.formatter.parseInt(fields[3]);
        int x2 = this.formatter.parseInt(fields[4]);
        int y = this.formatter.parseInt(fields[5]);
        boolean pf = this.formatter.parseInt(fields[10]) == 1;
        String baseString = fields[8];
        String qualString = fields[9];
        if (baseString.length() != qualString.length()) {
            throw new PicardException("Length of bases and quals don't match in " + this.textParser.getCurrentFilename());
        }
        readData.setOrCheckLane(lane);
        readData.setOrCheckTile(tile);
        readData.setOrCheckXCoordinate(x2);
        readData.setOrCheckYCoordinate(y);
        readData.setOrCheckPf(pf);
        QseqReadParser.stringToBytes(baseString, this.srcRanges, this.dstStarts, readData.getBases());
        QseqReadParser.stringToQuals(qualString, this.srcRanges, this.dstStarts, this.copyLengths, readData.getQualities());
    }

    private static void stringToBytes(String s2, Range[] sourceRanges, OutputMapping.TwoDIndex[] destRanges, byte[][] outputBuffers) {
        for (int i2 = 0; i2 < sourceRanges.length; ++i2) {
            s2.getBytes(sourceRanges[i2].start, sourceRanges[i2].end + 1, outputBuffers[destRanges[i2].majorIndex], destRanges[i2].minorIndex);
        }
    }

    private static void stringToQuals(String s2, Range[] sourceRanges, OutputMapping.TwoDIndex[] destRanges, int[] copyLengths, byte[][] outputBuffers) {
        QseqReadParser.stringToBytes(s2, sourceRanges, destRanges, outputBuffers);
        for (int i2 = 0; i2 < destRanges.length; ++i2) {
            qualConverter.convertSolexa_1_3_QualityCharsToPhredBinary(destRanges[i2].minorIndex, copyLengths[i2], outputBuffers[destRanges[i2].majorIndex]);
        }
    }

    public static int getReadLength(File qseqFile) {
        BasicInputParser parser = new BasicInputParser(true, qseqFile);
        if (!parser.hasNext()) {
            throw new PicardException("Unexpected empty qseq file: " + qseqFile);
        }
        String[] fields = (String[])parser.next();
        return fields[8].length();
    }
}

