/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.picard.PicardException;

class IlluminaFileMap
extends TreeMap<Integer, File> {
    public IlluminaFileMap() {
    }

    public IlluminaFileMap(List<Integer> tiles, List<File> files) {
        if (tiles.size() != files.size()) {
            throw new PicardException("Tiles and Files were not of the same length: Tiles(" + tiles.size() + ") Files(" + files.size() + ") ");
        }
        for (int i2 = 0; i2 < tiles.size(); ++i2) {
            this.put(tiles.get(i2), files.get(i2));
        }
    }

    public IlluminaFileMap keep(List<Integer> toInclude) {
        IlluminaFileMap fm = new IlluminaFileMap();
        for (Integer tile : toInclude) {
            File file = (File)this.get(tile);
            if (file == null) continue;
            fm.put(tile, file);
        }
        return fm;
    }

    public List<File> getFilesStartingAt(int startingTile) {
        return new ArrayList<File>(this.tailMap(startingTile).values());
    }
}

