/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.illumina.ClusterDataToSamConverter;
import net.sf.picard.illumina.IlluminaBasecallsConverter;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.TabbedTextFileWithHeaderParser;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.Iso8601Date;
import net.sf.samtools.util.SortingCollection;
import net.sf.samtools.util.StringUtil;

public class IlluminaBasecallsToSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generate a SAM or BAM file from data in an Illumina basecalls output directory.\n";
    @Option(doc="The basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The output SAM or BAM file. Format is determined by extension.", shortName="O", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public File OUTPUT;
    @Option(doc="The barcode of the run.  Prefixed to read names.")
    public String RUN_BARCODE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced sample", shortName="ALIAS", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String SAMPLE_ALIAS;
    @Option(doc="ID used to link RG header record with RG tag in SAM record.  If these are unique in SAM files that get merged, merge performance is better.  If not specified, READ_GROUP_ID will be set to <first 5 chars of RUN_BARCODE>.<LANE> .", shortName="RG", optional=true)
    public String READ_GROUP_ID;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced library", shortName="LIB", optional=true, mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String LIBRARY_NAME;
    @Option(doc="The name of the sequencing center that produced the reads.  Used to set the RG.CN tag.", optional=true)
    public String SEQUENCING_CENTER = "BI";
    @Option(doc="The start date of the run.", optional=true)
    public Date RUN_START_DATE;
    @Option(doc="The name of the sequencing technology that produced the read.", optional=true)
    public String PLATFORM = "illumina";
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Deprecated (use LIBRARY_PARAMS).  Tab-separated file for creating all output BAMs for barcoded run with single IlluminaBasecallsToSam invocation.  Columns are BARCODE, OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME.  Row with BARCODE=N is used to specify a file for no barcode match", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "LIBRARY_PARAMS"})
    public File BARCODE_PARAMS;
    @Option(doc="Tab-separated file for creating all output BAMs for a lane with single IlluminaBasecallsToSam invocation.  The columns are OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME, BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify a file for no barcode match.  You may also provide any 2 letter RG header attributes (excluding PU, CN, PL, and DT)  as columns in this file and the values for those columns will be inserted into the RG tag for the BAM file created for a given row.", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "BARCODE_PARAMS"})
    public File LIBRARY_PARAMS;
    @Option(doc="Which adapters to look for in the read.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = new ArrayList<IlluminaUtil.IlluminaAdapterPair>(Arrays.asList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.NEXTERA_V2, IlluminaUtil.IlluminaAdapterPair.FLUIDIGM));
    @Option(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Option(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Option(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Option(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Option(doc="Apply EAMSS filtering to identify inappropriately quality scored bases towards the ends of reads and convert their quality scores to Q2.")
    public boolean APPLY_EAMSS_FILTER = true;
    @Option(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    @Option(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    private final Map<String, SAMFileWriterWrapper> barcodeSamWriterMap = new HashMap<String, SAMFileWriterWrapper>();
    private ReadStructure readStructure;
    IlluminaBasecallsConverter<SAMRecordsForCluster> basecallsConverter;
    private static final Log log = Log.getInstance(IlluminaBasecallsToSam.class);
    private BclQualityEvaluationStrategy bclQualityEvaluationStrategy;

    @Override
    protected int doWork() {
        this.initialize();
        this.basecallsConverter.doTileProcessing();
        return 0;
    }

    private void initialize() {
        this.bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
        }
        if (this.LIBRARY_PARAMS != null) {
            IoUtil.assertFileIsReadable(this.LIBRARY_PARAMS);
        }
        if (this.OUTPUT != null) {
            this.barcodeSamWriterMap.put(null, this.buildSamFileWriter(this.OUTPUT, this.SAMPLE_ALIAS, this.LIBRARY_NAME, this.buildSamHeaderParameters(null)));
        } else {
            this.populateWritersFromLibraryParams();
        }
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        int numOutputRecords = this.readStructure.templates.length();
        this.basecallsConverter = new IlluminaBasecallsConverter<SAMRecordsForCluster>(this.BASECALLS_DIR, this.LANE, this.readStructure, this.barcodeSamWriterMap, true, this.MAX_READS_IN_RAM_PER_TILE / numOutputRecords, this.TMP_DIR, this.NUM_PROCESSORS, this.FORCE_GC, this.FIRST_TILE, this.TILE_LIMIT, new QueryNameComparator(), new Codec(numOutputRecords), SAMRecordsForCluster.class, this.bclQualityEvaluationStrategy, this.APPLY_EAMSS_FILTER);
        log.info("DONE_READING STRUCTURE IS " + this.readStructure.toString());
        ClusterDataToSamConverter converter = new ClusterDataToSamConverter(this.RUN_BARCODE, this.READ_GROUP_ID, this.basecallsConverter.getFactory().getOutputReadStructure(), this.ADAPTERS_TO_CHECK);
        this.basecallsConverter.setConverter(converter);
    }

    private Set<String> findAndFilterExpectedColumns(Set<String> actualCols, Set<String> expectedCols) {
        HashSet<String> missingColumns = new HashSet<String>(expectedCols);
        missingColumns.removeAll(actualCols);
        if (missingColumns.size() > 0) {
            throw new PicardException(String.format("LIBRARY_PARAMS file %s is missing the following columns: %s.", this.LIBRARY_PARAMS.getAbsolutePath(), StringUtil.join(", ", missingColumns)));
        }
        HashSet<String> remainingColumns = new HashSet<String>(actualCols);
        remainingColumns.removeAll(expectedCols);
        return remainingColumns;
    }

    private void checkRgTagColumns(Set<String> rgTagColumns) {
        Set<String> forbiddenHeaders = this.buildSamHeaderParameters(null).keySet();
        forbiddenHeaders.retainAll(rgTagColumns);
        if (forbiddenHeaders.size() > 0) {
            throw new PicardException("Illegal ReadGroup tags in library params(barcode params) file(" + this.LIBRARY_PARAMS.getAbsolutePath() + ") Offending headers = " + StringUtil.join(", ", forbiddenHeaders));
        }
        for (String column : rgTagColumns) {
            if (column.length() <= 2) continue;
            throw new PicardException("Column label (" + column + ") unrecognized.  Library params(barcode params) can only contain the columns " + "(OUTPUT, LIBRARY_NAME, SAMPLE_ALIAS, BARCODE, BARCODE_<X> where X is a positive integer) OR two letter RG tags!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateWritersFromLibraryParams() {
        TabbedTextFileWithHeaderParser libraryParamsParser = new TabbedTextFileWithHeaderParser(this.LIBRARY_PARAMS);
        Set<String> expectedColumnLabels = CollectionUtil.makeSet("OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME");
        ArrayList<String> barcodeColumnLabels = new ArrayList<String>();
        if (this.readStructure.barcodes.length() == 1) {
            if (libraryParamsParser.hasColumn("BARCODE")) {
                barcodeColumnLabels.add("BARCODE");
            } else {
                if (!libraryParamsParser.hasColumn("BARCODE_1")) throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does not have column BARCODE or BARCODE_1.");
                barcodeColumnLabels.add("BARCODE_1");
            }
        } else {
            for (int i2 = 1; i2 <= this.readStructure.barcodes.length(); ++i2) {
                barcodeColumnLabels.add("BARCODE_" + i2);
            }
        }
        expectedColumnLabels.addAll(barcodeColumnLabels);
        Set<String> rgTagColumns = this.findAndFilterExpectedColumns(libraryParamsParser.columnLabels(), expectedColumnLabels);
        this.checkRgTagColumns(rgTagColumns);
        for (TabbedTextFileWithHeaderParser.Row row : libraryParamsParser) {
            String key;
            ArrayList<String> barcodeValues = null;
            if (barcodeColumnLabels.size() > 0) {
                barcodeValues = new ArrayList<String>();
                for (String barcodeLabel : barcodeColumnLabels) {
                    barcodeValues.add(row.getField(barcodeLabel));
                }
            }
            String string = key = barcodeValues == null || barcodeValues.contains("N") ? null : StringUtil.join("", barcodeValues);
            if (this.barcodeSamWriterMap.containsKey(key)) {
                throw new PicardException("Row for barcode " + key + " appears more than once in LIBRARY_PARAMS or BARCODE_PARAMS file " + this.LIBRARY_PARAMS);
            }
            Map<String, String> samHeaderParams = this.buildSamHeaderParameters(barcodeValues);
            for (String tagName : rgTagColumns) {
                samHeaderParams.put(tagName, row.getField(tagName));
            }
            SAMFileWriterWrapper writer = this.buildSamFileWriter(new File(row.getField("OUTPUT")), row.getField("SAMPLE_ALIAS"), row.getField("LIBRARY_NAME"), samHeaderParams);
            this.barcodeSamWriterMap.put(key, writer);
        }
        if (!this.barcodeSamWriterMap.isEmpty()) return;
        throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does have any data rows.");
    }

    private Map<String, String> buildSamHeaderParameters(List<String> barcodes) {
        HashMap<String, String> params = new HashMap<String, String>();
        String platformUnit = this.RUN_BARCODE + "." + this.LANE;
        if (barcodes != null) {
            platformUnit = platformUnit + "." + IlluminaUtil.barcodeSeqsToString(barcodes);
        }
        params.put("PU", platformUnit);
        params.put("CN", this.SEQUENCING_CENTER);
        params.put("PL", this.PLATFORM);
        if (this.RUN_START_DATE != null) {
            Iso8601Date date = new Iso8601Date(this.RUN_START_DATE);
            params.put("DT", date.toString());
        } else {
            params.put("DT", null);
        }
        return params;
    }

    private SAMFileWriterWrapper buildSamFileWriter(File output, String sampleAlias, String libraryName, Map<String, String> headerParameters) {
        IoUtil.assertFileIsWritable(output);
        SAMReadGroupRecord rg = new SAMReadGroupRecord(this.READ_GROUP_ID);
        rg.setSample(sampleAlias);
        if (libraryName != null) {
            rg.setLibrary(libraryName);
        }
        for (Map.Entry<String, String> tagNameToValue : headerParameters.entrySet()) {
            if (tagNameToValue.getValue() == null) continue;
            rg.setAttribute(tagNameToValue.getKey(), tagNameToValue.getValue());
        }
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.queryname);
        header.addReadGroup(rg);
        return new SAMFileWriterWrapper(new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, output));
    }

    public static void main(String[] args) {
        System.exit(new IlluminaBasecallsToSam().instanceMain(args));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.BARCODE_PARAMS != null) {
            this.LIBRARY_PARAMS = this.BARCODE_PARAMS;
        }
        ArrayList<String> messages = new ArrayList<String>();
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (!this.readStructure.barcodes.isEmpty() && this.LIBRARY_PARAMS == null) {
            messages.add("BARCODE_PARAMS or LIBRARY_PARAMS is missing.  If READ_STRUCTURE contains a B (barcode) then either LIBRARY_PARAMS or BARCODE_PARAMS(deprecated) must be provided!");
        }
        if (this.READ_GROUP_ID == null) {
            this.READ_GROUP_ID = this.RUN_BARCODE.substring(0, 5) + "." + this.LANE;
        }
        if (messages.size() == 0) {
            return null;
        }
        return messages.toArray(new String[messages.size()]);
    }

    static class Codec
    implements SortingCollection.Codec<SAMRecordsForCluster> {
        private final BAMRecordCodec bamCodec;
        private final int numRecords;

        Codec(int numRecords, BAMRecordCodec bamCodec) {
            this.numRecords = numRecords;
            this.bamCodec = bamCodec;
        }

        Codec(int numRecords) {
            this(numRecords, new BAMRecordCodec(null));
        }

        @Override
        public void setOutputStream(OutputStream os) {
            this.bamCodec.setOutputStream(os);
        }

        @Override
        public void setInputStream(InputStream is) {
            this.bamCodec.setInputStream(is);
        }

        @Override
        public void encode(SAMRecordsForCluster val) {
            if (val.records.length != this.numRecords) {
                throw new IllegalStateException(String.format("Expected number of clusters %d != actual %d", this.numRecords, val.records.length));
            }
            for (SAMRecord rec : val.records) {
                this.bamCodec.encode(rec);
            }
        }

        @Override
        public SAMRecordsForCluster decode() {
            SAMRecord zerothRecord = this.bamCodec.decode();
            if (zerothRecord == null) {
                return null;
            }
            SAMRecordsForCluster ret = new SAMRecordsForCluster(this.numRecords);
            ret.records[0] = zerothRecord;
            for (int i2 = 1; i2 < this.numRecords; ++i2) {
                ret.records[i2] = this.bamCodec.decode();
                if (ret.records[i2] != null) continue;
                throw new IllegalStateException(String.format("Expected to read % records but read only %d", this.numRecords, i2));
            }
            return ret;
        }

        @Override
        public SortingCollection.Codec<SAMRecordsForCluster> clone() {
            return new Codec(this.numRecords, this.bamCodec.clone());
        }
    }

    static class QueryNameComparator
    implements Comparator<SAMRecordsForCluster> {
        private final SAMRecordQueryNameComparator comparator = new SAMRecordQueryNameComparator();

        QueryNameComparator() {
        }

        @Override
        public int compare(SAMRecordsForCluster s1, SAMRecordsForCluster s2) {
            return this.comparator.compare(s1.records[0], s2.records[0]);
        }
    }

    static class SAMRecordsForCluster {
        final SAMRecord[] records;

        SAMRecordsForCluster(int numRecords) {
            this.records = new SAMRecord[numRecords];
        }
    }

    private static class SAMFileWriterWrapper
    implements IlluminaBasecallsConverter.ConvertedClusterDataWriter<SAMRecordsForCluster> {
        public final SAMFileWriter writer;

        private SAMFileWriterWrapper(SAMFileWriter writer) {
            this.writer = writer;
        }

        @Override
        public void write(SAMRecordsForCluster records) {
            for (SAMRecord rec : records.records) {
                this.writer.addAlignment(rec);
            }
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }
}

