/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.tools;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ConnectionPoolStat {
    private final MBeanServerConnection mBeanConnection;

    public ConnectionPoolStat(MBeanServerConnection mBeanConnection) {
        this.mBeanConnection = mBeanConnection;
    }

    public ConnectionPoolStat() {
        this.mBeanConnection = ManagementFactory.getPlatformMBeanServer();
    }

    public String getStats() throws JMException, IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        this.print(printWriter);
        return charArrayWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String hostAndPort;
        int pos;
        String host = "localhost";
        int port = -1;
        long rowCount = 0L;
        int sleepTime = 1000;
        for (pos = 0; pos < args.length; ++pos) {
            if (args[pos].equals("--help")) {
                ConnectionPoolStat.printUsage();
                System.exit(0);
                continue;
            }
            if (args[pos].equals("--host") || args[pos].equals("-h")) {
                host = args[++pos];
                continue;
            }
            if (args[pos].equals("--port")) {
                port = ConnectionPoolStat.getIntegerArg(args[++pos], "--port");
                continue;
            }
            if (args[pos].equals("--rowcount") || args[pos].equals("-n")) {
                rowCount = ConnectionPoolStat.getIntegerArg(args[++pos], "--rowCount");
                continue;
            }
            if (args[pos].startsWith("-")) {
                ConnectionPoolStat.printErrorAndUsageAndExit("unknown option " + args[pos]);
                continue;
            }
            sleepTime = ConnectionPoolStat.getIntegerArg(args[pos++], "sleep time") * 1000;
            break;
        }
        if (pos != args.length) {
            ConnectionPoolStat.printErrorAndUsageAndExit("too many positional options");
        }
        if (port == -1 && !host.contains(":")) {
            ConnectionPoolStat.printErrorAndUsageAndExit("port is required");
        }
        String string = hostAndPort = port != -1 ? host + ":" + port : host;
        if (rowCount == 0L) {
            rowCount = Long.MAX_VALUE;
        }
        JMXServiceURL u2 = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + hostAndPort + "/jmxrmi");
        JMXConnector connector = JMXConnectorFactory.connect(u2);
        MBeanServerConnection mBeanConnection = connector.getMBeanServerConnection();
        try {
            ConnectionPoolStat printer = new ConnectionPoolStat(mBeanConnection);
            int i2 = 0;
            while ((long)i2 < rowCount) {
                System.out.println(printer.getStats());
                if ((long)i2 != rowCount - 1L) {
                    Thread.sleep(sleepTime);
                }
                ++i2;
            }
        }
        finally {
            connector.close();
        }
    }

    private static int getIntegerArg(String arg, String argName) {
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException e2) {
            ConnectionPoolStat.printErrorAndUsageAndExit(argName + " arg must be an integer");
            throw new IllegalStateException();
        }
    }

    private static void printErrorAndUsageAndExit(String error) {
        System.err.println("ERROR: " + error);
        System.out.println();
        ConnectionPoolStat.printUsage();
        System.exit(1);
    }

    private static void printUsage() {
        System.out.println("View live MongoDB connection pool statistics from a remote JMX server.");
        System.out.println();
        System.out.println("usage: java com.mongodb.tools.ConnectionPoolStat [options] [sleep time");
        System.out.println("sleep time: time to wait (in seconds) between calls. Defaults to 1");
        System.out.println("options:");
        System.out.println("  --help                 produce help message");
        System.out.println("  --port arg             JMX remote port. Required. Can also use --host hostname:port");
        System.out.println("  -h [ --host ] arg      JMX remote host. Defaults to localhost");
        System.out.println("  -n [ --rowcount ] arg  number of times to print stats (0 for indefinite)");
        System.out.println();
        System.out.println("Fields");
        System.out.println("  objectName                     - name of the JMX bean for this connection pool");
        System.out.println("  host                           - host of the mongod/mongos server");
        System.out.println("  port                           - port of the mongod/mongos server");
        System.out.println("  maxSize                        - max # of connections allowed");
        System.out.println("  total                          - # of connections allocated");
        System.out.println("  inUse                          - # of connections in use");
        System.out.println("  inUseConnections               - list of all in use connections");
        System.out.println("  inUseConnections.namespace     - namespace on which connection is operating");
        System.out.println("  inUseConnections.opCode        - operation connection is executing");
        System.out.println("  inUseConnections.query         - query the connection is executing (for query/update/remove)");
        System.out.println("  inUseConnections.numDocuments  - # of documents in the message (mostly relevant for batch inserts)");
        System.out.println("  inUseConnections.threadName    - name of thread on which connection is executing");
        System.out.println("  inUseConnections.durationMS    - duration that the operation has been executing so far");
        System.out.println("  inUseConnections.localPort     - local port of the connection");
    }

    private void print(PrintWriter pw) throws JMException, IOException {
        Set<ObjectName> beanSet = this.mBeanConnection.queryNames(new ObjectName("com.mongodb:type=ConnectionPool,*"), null);
        pw.println("{ pools : [");
        int i2 = 0;
        for (ObjectName objectName : beanSet) {
            pw.print("   { ");
            this.printAttribute("ObjectName", objectName.toString(), pw);
            pw.println();
            pw.print("     ");
            this.printAttribute("Host", objectName, pw);
            this.printAttribute("Port", objectName, pw);
            this.printAttribute("MaxSize", objectName, pw);
            this.printStatistics(pw, objectName);
            pw.println("   }" + (i2 == beanSet.size() - 1 ? "" : ","));
            ++i2;
        }
        pw.println("  ]");
        pw.println("}");
    }

    private void printStatistics(PrintWriter pw, ObjectName objectName) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        String key = "Statistics";
        CompositeData statistics = (CompositeData)this.mBeanConnection.getAttribute(objectName, key);
        this.printSimpleStatistics(pw, statistics);
        this.printInUseConnections(statistics, pw);
    }

    private void printSimpleStatistics(PrintWriter pw, CompositeData statistics) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        this.printCompositeDataAttribute("total", statistics, pw);
        this.printCompositeDataAttribute("inUse", statistics, pw);
        pw.println();
    }

    private void printInUseConnections(CompositeData statistics, PrintWriter pw) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        String key = "inUseConnections";
        CompositeData[] compositeDataArray = (CompositeData[])statistics.get(key);
        pw.println("     " + this.getKeyString(key) + ": [");
        for (int i2 = 0; i2 < compositeDataArray.length; ++i2) {
            CompositeData compositeData = compositeDataArray[i2];
            pw.print("      { ");
            this.printCompositeDataAttribute("namespace", compositeData, pw);
            this.printCompositeDataAttribute("opCode", compositeData, pw);
            this.printCompositeDataAttribute("query", compositeData, pw, StringType.JSON);
            this.printCompositeDataAttribute("numDocuments", compositeData, pw);
            this.printCompositeDataAttribute("threadName", compositeData, pw);
            this.printCompositeDataAttribute("durationMS", compositeData, pw);
            this.printCompositeDataAttribute("localPort", compositeData, pw, Position.LAST);
            pw.println(" }" + (i2 == compositeDataArray.length - 1 ? "" : ", "));
        }
        pw.println("     ]");
    }

    private void printCompositeDataAttribute(String key, CompositeData compositeData, PrintWriter pw) {
        this.printCompositeDataAttribute(key, compositeData, pw, Position.REGULAR);
    }

    private void printCompositeDataAttribute(String key, CompositeData compositeData, PrintWriter pw, Position position) {
        this.printCompositeDataAttribute(key, compositeData, pw, position, StringType.REGULAR);
    }

    private void printCompositeDataAttribute(String key, CompositeData compositeData, PrintWriter pw, StringType stringType) {
        this.printCompositeDataAttribute(key, compositeData, pw, Position.REGULAR, stringType);
    }

    private void printCompositeDataAttribute(String key, CompositeData compositeData, PrintWriter pw, Position position, StringType stringType) {
        this.printAttribute(key, compositeData.get(key), pw, position, stringType);
    }

    private void printAttribute(String key, ObjectName objectName, PrintWriter pw) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        this.printAttribute(key, this.mBeanConnection.getAttribute(objectName, key), pw);
    }

    private void printAttribute(String key, Object value, PrintWriter pw) {
        this.printAttribute(key, value, pw, Position.REGULAR, StringType.REGULAR);
    }

    private void printAttribute(String key, Object value, PrintWriter pw, Position position, StringType stringType) {
        if (value != null) {
            pw.print(this.getKeyString(key) + ": " + this.getValueString(value, stringType) + (position == Position.LAST ? "" : ", "));
        }
    }

    private String getKeyString(String key) {
        return Character.toLowerCase(key.charAt(0)) + key.substring(1);
    }

    private String getValueString(Object value, StringType stringType) {
        if (value instanceof String && stringType == StringType.REGULAR) {
            return "'" + value + "'";
        }
        return value.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Position {
        REGULAR,
        LAST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StringType {
        REGULAR,
        JSON;

    }
}

