/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.CommandResult;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;
import com.mongodb.WriteConcernException;
import java.io.IOException;
import org.bson.BSONObject;

public class MongoException
extends RuntimeException {
    private static final long serialVersionUID = -4415279469780082174L;
    final int _code;

    public MongoException(String msg) {
        super(msg);
        this._code = -3;
    }

    public MongoException(int code, String msg) {
        super(msg);
        this._code = code;
    }

    public MongoException(String msg, Throwable t2) {
        super(msg, MongoException._massage(t2));
        this._code = -4;
    }

    public MongoException(int code, String msg, Throwable t2) {
        super(msg, MongoException._massage(t2));
        this._code = code;
    }

    public MongoException(BSONObject o2) {
        this(ServerError.getCode(o2), ServerError.getMsg(o2, "UNKNOWN"));
    }

    static MongoException parse(BSONObject o2) {
        String s2 = ServerError.getMsg(o2, null);
        if (s2 == null) {
            return null;
        }
        return new MongoException(ServerError.getCode(o2), s2);
    }

    static Throwable _massage(Throwable t2) {
        if (t2 instanceof Network) {
            return ((Network)t2)._ioe;
        }
        return t2;
    }

    public int getCode() {
        return this._code;
    }

    public static class CursorNotFound
    extends MongoException {
        private static final long serialVersionUID = -4415279469780082174L;
        private final long cursorId;
        private final ServerAddress serverAddress;

        public CursorNotFound(long cursorId, ServerAddress serverAddress) {
            super(-5, "cursor " + cursorId + " not found on server " + serverAddress);
            this.cursorId = cursorId;
            this.serverAddress = serverAddress;
        }

        public long getCursorId() {
            return this.cursorId;
        }

        public ServerAddress getServerAddress() {
            return this.serverAddress;
        }
    }

    public static class DuplicateKey
    extends WriteConcernException {
        private static final long serialVersionUID = -4415279469780082174L;

        public DuplicateKey(CommandResult commandResult) {
            super(commandResult);
        }
    }

    public static class Network
    extends MongoException {
        private static final long serialVersionUID = -4415279469780082174L;
        final IOException _ioe;

        public Network(String msg, IOException ioe) {
            super(-2, msg, ioe);
            this._ioe = ioe;
        }

        public Network(IOException ioe) {
            super(ioe.toString(), ioe);
            this._ioe = ioe;
        }
    }
}

