/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.PushbackTokenizer;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;

public class JavaUtils {
    public static final String CONTRACTS_EXTENSION = ".contracts";
    public static final String CONTRACTED_EXTENSION = ".class.contracted";
    public static final String SOURCE_DEPENDENCY_EXTENSION = ".java.d";
    public static final String BEGIN_GENERATED_CODE = "/*[*/";
    public static final String END_GENERATED_CODE = "/*]*/";
    public static final String BEGIN_LOCATION_COMMENT = "/*[";
    public static final String END_LOCATION_COMMENT = "]*/";
    public static final String RESULT_VARIABLE = "result";
    public static final String SIGNAL_VARIABLE = "signal";
    public static final String HELPER_CLASS_SUFFIX = "$com$google$java$contract$H";
    public static final String SYNTHETIC_MEMBER_PREFIX = "com$google$java$contract$S";
    public static final String OLD_VARIABLE_PREFIX = "com$google$java$contract$local$old";
    public static final String SUCCESS_VARIABLE_PREFIX = "com$google$java$contract$local$success";
    public static final String ERROR_VARIABLE = "com$google$java$contract$local$error";
    public static final String THAT_VARIABLE = "com$google$java$contract$local$that";

    @Requires(value={"obj != null", "className != null"})
    public static boolean objectIsCastableTo(Object object, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.isAssignableFrom(object.getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Requires(value={"className != null"})
    public static boolean classExists(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Requires(value={"str != null"})
    @Ensures(value={"result != null"})
    public static String quoteComment(String string) {
        return string.replace("/*", "/\\*").replace("*/", "*\\/");
    }

    @Requires(value={"code != null"})
    @Ensures(value={"result != null"})
    public static String deleteComments(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        JavaTokenizer javaTokenizer = new JavaTokenizer(new StringReader(string));
        while (javaTokenizer.hasNext()) {
            JavaTokenizer.Token token = javaTokenizer.next();
            if (token.kind == JavaTokenizer.TokenKind.COMMENT) continue;
            stringBuilder.append(token.text);
        }
        return stringBuilder.toString();
    }

    @Requires(value={"code != null"})
    @Ensures(value={"result != null", "code.length() == result.length() + generatedCodeLength(code)"})
    public static String deleteGeneratedCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        JavaTokenizer javaTokenizer = new JavaTokenizer(new StringReader(string));
        boolean bl = false;
        while (javaTokenizer.hasNext()) {
            JavaTokenizer.Token token = javaTokenizer.next();
            if (!bl) {
                if (token.kind == JavaTokenizer.TokenKind.COMMENT && token.text.equals(BEGIN_GENERATED_CODE)) {
                    bl = true;
                    continue;
                }
                stringBuilder.append(token.text);
                continue;
            }
            if (token.kind != JavaTokenizer.TokenKind.COMMENT || !token.text.equals(END_GENERATED_CODE)) continue;
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Requires(value={"code != null"})
    @Ensures(value={"result == code.length() - deleteGeneratedCode(code).length()"})
    public static int generatedCodeLength(String string) {
        int n2 = 0;
        JavaTokenizer javaTokenizer = new JavaTokenizer(new StringReader(string));
        boolean bl = false;
        while (javaTokenizer.hasNext()) {
            JavaTokenizer.Token token = javaTokenizer.next();
            if (!bl) {
                if (token.kind != JavaTokenizer.TokenKind.COMMENT || !token.text.equals(BEGIN_GENERATED_CODE)) continue;
                bl = true;
                n2 += token.text.length();
                continue;
            }
            if (token.kind == JavaTokenizer.TokenKind.COMMENT && token.text.equals(END_GENERATED_CODE)) {
                bl = false;
            }
            n2 += token.text.length();
        }
        return n2;
    }

    @Requires(value={"code != null", "map != null"})
    @Ensures(value={"result != null"})
    public static String renameLocalVariables(String string, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        JavaTokenizer javaTokenizer = new JavaTokenizer(new StringReader(string));
        boolean bl = false;
        while (javaTokenizer.hasNext()) {
            JavaTokenizer.Token token = javaTokenizer.next();
            if (!bl && token.kind == JavaTokenizer.TokenKind.WORD) {
                String string2 = map.get(token.text);
                if (string2 != null) {
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append(token.text);
                }
            } else {
                stringBuilder.append(token.text);
            }
            bl = token.text.equals(".");
        }
        return stringBuilder.toString();
    }

    @Requires(value={"tokenizer != null", "text != null"})
    public static boolean lookingAt(PushbackTokenizer pushbackTokenizer, String string) {
        JavaTokenizer.Token token = pushbackTokenizer.peek(0);
        JavaTokenizer.Token token2 = pushbackTokenizer.peek(1);
        if (token == null) {
            return false;
        }
        if (!token.text.equals(string)) {
            if (token.kind != JavaTokenizer.TokenKind.SPACE) {
                return false;
            }
            if (token2 == null) {
                return false;
            }
            if (!token2.text.equals(string)) {
                return false;
            }
        }
        return true;
    }

    @Requires(value={"tokenizer != null", "text != null"})
    public static void skipPast(JavaTokenizer javaTokenizer, String string) {
        while (javaTokenizer.hasNext() && !javaTokenizer.next().text.equals(string)) {
        }
    }

    @Requires(value={"tokenizer != null"})
    @Ensures(value={"!acceptStar ? ClassName.isQualifiedName(result): ClassName.isQualifiedName(result)|| ClassName.isQualifiedName(result.substring(0, result.length() - 2))"})
    public static String parseQualifiedName(JavaTokenizer javaTokenizer, boolean bl) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        block9: while (javaTokenizer.hasNext()) {
            JavaTokenizer.Token token = javaTokenizer.getNextToken();
            block0 : switch (token.kind) {
                case WORD: {
                    if (!bl2) break block9;
                    stringBuilder.append(token.text);
                    bl2 = false;
                    break;
                }
                case SYMBOL: {
                    switch (token.text.charAt(0)) {
                        case '.': {
                            if (bl2) break block9;
                            stringBuilder.append(".");
                            bl2 = true;
                            break block0;
                        }
                        case '*': {
                            if (!bl || !bl2) break block9;
                            stringBuilder.append("*");
                            javaTokenizer.next();
                            break;
                        }
                    }
                    break block9;
                }
                case SPACE: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            javaTokenizer.next();
        }
        if (stringBuilder.length() == 0) {
            throw new ParseException("next token is not part of an identifier");
        }
        return stringBuilder.toString();
    }

    public static String parseQualifiedName(JavaTokenizer javaTokenizer) throws ParseException {
        return JavaUtils.parseQualifiedName(javaTokenizer, false);
    }

    @Requires(value={"path != null"})
    public static URLClassLoader getLoaderForPath(String string) {
        String[] stringArray = string.split(Pattern.quote(File.pathSeparator));
        URL[] uRLArray = new URL[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                uRLArray[i2] = new File(stringArray[i2]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new URLClassLoader(uRLArray);
    }

    @Requires(value={"ClassName.isBinaryName(className)"})
    public static InputStream getContractClassInputStream(ClassLoader classLoader, String string, boolean bl) {
        String string2 = string + CONTRACTS_EXTENSION;
        String string3 = string + HELPER_CLASS_SUFFIX + JavaFileObject.Kind.CLASS.extension;
        if (classLoader != null) {
            URL uRL = classLoader.getResource(string3);
            if (uRL != null && bl) {
                DebugUtils.info("loader", "found " + uRL);
                return classLoader.getResourceAsStream(string3);
            }
            uRL = classLoader.getResource(string2);
            if (uRL != null) {
                DebugUtils.info("loader", "found " + uRL);
                return classLoader.getResourceAsStream(string2);
            }
            return null;
        }
        URL uRL = ClassLoader.getSystemResource(string3);
        if (uRL != null && bl) {
            DebugUtils.info("loader", "found " + uRL);
            return ClassLoader.getSystemResourceAsStream(string3);
        }
        uRL = ClassLoader.getSystemResource(string2);
        if (uRL != null) {
            DebugUtils.info("loader", "found " + uRL);
            return ClassLoader.getSystemResourceAsStream(string2);
        }
        return null;
    }

    public static InputStream getContractClassInputStream(ClassLoader classLoader, String string) {
        return JavaUtils.getContractClassInputStream(classLoader, string, false);
    }

    @Requires(value={"className != null"})
    public static boolean resourceExists(ClassLoader classLoader, String string) {
        if (classLoader != null) {
            return classLoader.getResource(string) != null;
        }
        return ClassLoader.getSystemResource(string) != null;
    }

    public static class ParseException
    extends Exception {
        public ParseException(String string) {
            super(string);
        }

        public ParseException(Throwable throwable) {
            super(throwable);
        }

        public ParseException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

