/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.google.common.hash.Hasher;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class MessageDigestHashFunction
extends AbstractStreamingHashFunction {
    private final String algorithmName;
    private final int bits;

    MessageDigestHashFunction(String algorithmName) {
        this.algorithmName = algorithmName;
        this.bits = MessageDigestHashFunction.getMessageDigest(algorithmName).getDigestLength() * 8;
    }

    @Override
    public int bits() {
        return this.bits;
    }

    private static MessageDigest getMessageDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    @Override
    public Hasher newHasher() {
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.algorithmName));
    }

    private static class MessageDigestHasher
    implements Hasher {
        private final MessageDigest digest;
        private final ByteBuffer scratch;
        private boolean done;

        private MessageDigestHasher(MessageDigest digest) {
            this.digest = digest;
            this.scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public Hasher putByte(byte b2) {
            this.checkNotDone();
            this.digest.update(b2);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes) {
            this.checkNotDone();
            this.digest.update(bytes);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes, int off, int len) {
            this.checkNotDone();
            Preconditions.checkPositionIndexes(off, off + len, bytes.length);
            this.digest.update(bytes, off, len);
            return this;
        }

        @Override
        public Hasher putShort(short s2) {
            this.checkNotDone();
            this.scratch.putShort(s2);
            this.digest.update(this.scratch.array(), 0, 2);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putInt(int i2) {
            this.checkNotDone();
            this.scratch.putInt(i2);
            this.digest.update(this.scratch.array(), 0, 4);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putLong(long l2) {
            this.checkNotDone();
            this.scratch.putLong(l2);
            this.digest.update(this.scratch.array(), 0, 8);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putFloat(float f2) {
            this.checkNotDone();
            this.scratch.putFloat(f2);
            this.digest.update(this.scratch.array(), 0, 4);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putDouble(double d2) {
            this.checkNotDone();
            this.scratch.putDouble(d2);
            this.digest.update(this.scratch.array(), 0, 8);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putBoolean(boolean b2) {
            return this.putByte(b2 ? (byte)1 : 0);
        }

        @Override
        public Hasher putChar(char c2) {
            this.checkNotDone();
            this.scratch.putChar(c2);
            this.digest.update(this.scratch.array(), 0, 2);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence) {
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                this.putChar(charSequence.charAt(i2));
            }
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence, Charset charset) {
            return this.putBytes(((Object)charSequence).toString().getBytes(charset));
        }

        @Override
        public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
            this.checkNotDone();
            funnel.funnel(instance, this);
            return this;
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot use Hasher after calling #hash() on it");
        }

        @Override
        public HashCode hash() {
            this.done = true;
            return HashCodes.fromBytesNoCopy(this.digest.digest());
        }
    }
}

