/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class EventHandler {
    private final Object target;
    private final Method method;

    EventHandler(Object target, Method method) {
        Preconditions.checkNotNull(target, "EventHandler target cannot be null.");
        Preconditions.checkNotNull(method, "EventHandler method cannot be null.");
        this.target = target;
        this.method = method;
        method.setAccessible(true);
    }

    public void handleEvent(Object event) throws InvocationTargetException {
        try {
            this.method.invoke(this.target, event);
        }
        catch (IllegalArgumentException e2) {
            throw new Error("Method rejected target/argument: " + event, e2);
        }
        catch (IllegalAccessException e3) {
            throw new Error("Method became inaccessible: " + event, e3);
        }
        catch (InvocationTargetException e4) {
            if (e4.getCause() instanceof Error) {
                throw (Error)e4.getCause();
            }
            throw e4;
        }
    }

    public String toString() {
        return "[wrapper " + this.method + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        return (31 + this.method.hashCode()) * 31 + this.target.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventHandler other = (EventHandler)obj;
        return this.method.equals(other.method) && this.target == other.target;
    }
}

