/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.fragments;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.fragments.FragmentCollection;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public final class FragmentUtils {
    protected static final byte MIN_QUAL_BAD_OVERLAP = 16;
    private static final ReadGetter<GATKSAMRecord> SamRecordGetter = new ReadGetter<GATKSAMRecord>(){

        @Override
        public GATKSAMRecord get(GATKSAMRecord object) {
            return object;
        }
    };
    private static final ReadGetter<PileupElement> PileupElementGetter = new ReadGetter<PileupElement>(){

        @Override
        public GATKSAMRecord get(PileupElement object) {
            return object.getRead();
        }
    };

    private FragmentUtils() {
    }

    @Requires(value={"readContainingObjects != null", "nElements >= 0", "getter != null"})
    @Ensures(value={"result != null"})
    private static <T> FragmentCollection<T> create(Iterable<T> readContainingObjects, int nElements, ReadGetter<T> getter) {
        Collection singletons = null;
        ArrayList<List<Object>> overlapping = null;
        HashMap<String, T> nameMap = null;
        int lastStart = -1;
        for (T p : readContainingObjects) {
            Object pe1;
            GATKSAMRecord read = getter.get(p);
            if (read.getAlignmentStart() < lastStart) {
                throw new IllegalArgumentException(String.format("FragmentUtils.create assumes that the incoming objects are ordered by SAMRecord alignment start, but saw a read %s with alignment start %d before the previous start %d", read.getSAMString(), read.getAlignmentStart(), lastStart));
            }
            lastStart = read.getAlignmentStart();
            int mateStart = read.getMateAlignmentStart();
            if (mateStart == 0 || mateStart > read.getAlignmentEnd()) {
                if (singletons == null) {
                    singletons = new ArrayList(nElements);
                }
                singletons.add(p);
                continue;
            }
            String readName = ((SAMRecord)read).getReadName();
            Object v0 = pe1 = nameMap == null ? null : nameMap.get(readName);
            if (pe1 != null) {
                if (overlapping == null) {
                    overlapping = new ArrayList<List<Object>>();
                }
                overlapping.add(Arrays.asList(pe1, p));
                nameMap.remove(readName);
                continue;
            }
            if (nameMap == null) {
                nameMap = new HashMap<String, T>(nElements);
            }
            nameMap.put(readName, p);
        }
        if (nameMap != null && !nameMap.isEmpty()) {
            if (singletons == null) {
                singletons = nameMap.values();
            } else {
                singletons.addAll(nameMap.values());
            }
        }
        return new FragmentCollection(singletons, overlapping);
    }

    @Ensures(value={"result != null"})
    public static FragmentCollection<PileupElement> create(ReadBackedPileup rbp) {
        if (rbp == null) {
            throw new IllegalArgumentException("Pileup cannot be null");
        }
        return FragmentUtils.create(rbp, rbp.getNumberOfElements(), PileupElementGetter);
    }

    @Ensures(value={"result != null"})
    public static FragmentCollection<GATKSAMRecord> create(List<GATKSAMRecord> reads) {
        if (reads == null) {
            throw new IllegalArgumentException("Pileup cannot be null");
        }
        return FragmentUtils.create(reads, reads.size(), SamRecordGetter);
    }

    public static List<GATKSAMRecord> mergeOverlappingPairedFragments(List<GATKSAMRecord> overlappingPair) {
        if (overlappingPair.size() != 2) {
            throw new ReviewedStingException("Found overlapping pair with " + overlappingPair.size() + " reads, but expecting exactly 2.");
        }
        GATKSAMRecord firstRead = overlappingPair.get(0);
        GATKSAMRecord secondRead = overlappingPair.get(1);
        GATKSAMRecord merged = secondRead.getSoftStart() > firstRead.getSoftEnd() || secondRead.getSoftStart() < firstRead.getSoftStart() || secondRead.getSoftEnd() < firstRead.getSoftEnd() ? FragmentUtils.mergeOverlappingPairedFragments(secondRead, firstRead) : FragmentUtils.mergeOverlappingPairedFragments(firstRead, secondRead);
        return merged == null ? overlappingPair : Collections.singletonList(merged);
    }

    public static GATKSAMRecord mergeOverlappingPairedFragments(GATKSAMRecord unclippedFirstRead, GATKSAMRecord unclippedSecondRead) {
        int iii;
        if (unclippedFirstRead == null) {
            throw new IllegalArgumentException("unclippedFirstRead cannot be null");
        }
        if (unclippedSecondRead == null) {
            throw new IllegalArgumentException("unclippedSecondRead cannot be null");
        }
        if (!unclippedFirstRead.getReadName().equals(unclippedSecondRead.getReadName())) {
            throw new IllegalArgumentException("attempting to merge two reads with different names " + unclippedFirstRead + " and " + unclippedSecondRead);
        }
        if (unclippedFirstRead.getCigarString().contains("I") || unclippedFirstRead.getCigarString().contains("D") || unclippedSecondRead.getCigarString().contains("I") || unclippedSecondRead.getCigarString().contains("D")) {
            return null;
        }
        GATKSAMRecord firstRead = ReadClipper.hardClipAdaptorSequence(ReadClipper.revertSoftClippedBases(unclippedFirstRead));
        GATKSAMRecord secondRead = ReadClipper.hardClipAdaptorSequence(ReadClipper.revertSoftClippedBases(unclippedSecondRead));
        if (secondRead.getSoftStart() > firstRead.getSoftEnd() || secondRead.getSoftStart() < firstRead.getSoftStart() || secondRead.getSoftEnd() < firstRead.getSoftEnd()) {
            return null;
        }
        Pair<Integer, Boolean> pair = ReadUtils.getReadCoordinateForReferenceCoordinate(firstRead, secondRead.getAlignmentStart());
        int firstReadStop = pair.getSecond() != false ? pair.getFirst() + 1 : pair.getFirst();
        int numBases = firstReadStop + secondRead.getReadLength();
        byte[] bases = new byte[numBases];
        byte[] quals = new byte[numBases];
        byte[] insertionQuals = new byte[numBases];
        byte[] deletionQuals = new byte[numBases];
        byte[] firstReadBases = firstRead.getReadBases();
        byte[] firstReadQuals = firstRead.getBaseQualities();
        byte[] secondReadBases = secondRead.getReadBases();
        byte[] secondReadQuals = secondRead.getBaseQualities();
        for (iii = 0; iii < firstReadStop; ++iii) {
            bases[iii] = firstReadBases[iii];
            quals[iii] = firstReadQuals[iii];
        }
        for (iii = firstReadStop; iii < firstRead.getReadLength(); ++iii) {
            if (firstReadQuals[iii] > 16 && secondReadQuals[iii - firstReadStop] > 16 && firstReadBases[iii] != secondReadBases[iii - firstReadStop]) {
                return null;
            }
            if (firstReadQuals[iii] < 16 && secondReadQuals[iii - firstReadStop] < 16) {
                return null;
            }
            bases[iii] = firstReadQuals[iii] > secondReadQuals[iii - firstReadStop] ? firstReadBases[iii] : secondReadBases[iii - firstReadStop];
            quals[iii] = firstReadQuals[iii] > secondReadQuals[iii - firstReadStop] ? firstReadQuals[iii] : secondReadQuals[iii - firstReadStop];
        }
        for (iii = firstRead.getReadLength(); iii < numBases; ++iii) {
            bases[iii] = secondReadBases[iii - firstReadStop];
            quals[iii] = secondReadQuals[iii - firstReadStop];
        }
        GATKSAMRecord returnRead = new GATKSAMRecord(firstRead.getHeader());
        returnRead.setIsStrandless(true);
        returnRead.setAlignmentStart(firstRead.getAlignmentStart());
        returnRead.setReadBases(bases);
        returnRead.setBaseQualities(quals);
        returnRead.setReadGroup(firstRead.getReadGroup());
        returnRead.setReferenceName(firstRead.getReferenceName());
        returnRead.setReadName(firstRead.getReadName());
        CigarElement c = new CigarElement(bases.length, CigarOperator.M);
        ArrayList<CigarElement> cList = new ArrayList<CigarElement>();
        cList.add(c);
        returnRead.setCigar(new Cigar(cList));
        returnRead.setMappingQuality(firstRead.getMappingQuality());
        if (firstRead.hasBaseIndelQualities() || secondRead.hasBaseIndelQualities()) {
            int iii2;
            byte[] firstReadInsertionQuals = firstRead.getBaseInsertionQualities();
            byte[] firstReadDeletionQuals = firstRead.getBaseDeletionQualities();
            byte[] secondReadInsertionQuals = secondRead.getBaseInsertionQualities();
            byte[] secondReadDeletionQuals = secondRead.getBaseDeletionQualities();
            for (iii2 = 0; iii2 < firstReadStop; ++iii2) {
                insertionQuals[iii2] = firstReadInsertionQuals[iii2];
                deletionQuals[iii2] = firstReadDeletionQuals[iii2];
            }
            for (iii2 = firstReadStop; iii2 < firstRead.getReadLength(); ++iii2) {
                insertionQuals[iii2] = firstReadQuals[iii2] > secondReadQuals[iii2 - firstReadStop] ? firstReadInsertionQuals[iii2] : secondReadInsertionQuals[iii2 - firstReadStop];
                deletionQuals[iii2] = firstReadQuals[iii2] > secondReadQuals[iii2 - firstReadStop] ? firstReadDeletionQuals[iii2] : secondReadDeletionQuals[iii2 - firstReadStop];
            }
            for (iii2 = firstRead.getReadLength(); iii2 < numBases; ++iii2) {
                insertionQuals[iii2] = secondReadInsertionQuals[iii2 - firstReadStop];
                deletionQuals[iii2] = secondReadDeletionQuals[iii2 - firstReadStop];
            }
            returnRead.setBaseQualities(insertionQuals, EventType.BASE_INSERTION);
            returnRead.setBaseQualities(deletionQuals, EventType.BASE_DELETION);
        }
        return returnRead;
    }

    public static interface ReadGetter<T> {
        public GATKSAMRecord get(T var1);
    }
}

