/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.ParsingUtils;

public class TribbleListFeatureSource
implements FeatureSource {
    private static Logger log = Logger.getLogger(TribbleListFeatureSource.class);
    Map<String, String> pathMap;
    Map<String, TribbleFeatureSource> featureSourceMap;
    int windowSize = 1000;
    Object header;
    Genome genome;

    public TribbleListFeatureSource(String path, Genome genome) throws IOException {
        this.genome = genome;
        this.init(path, genome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String path, Genome genome) throws IOException {
        this.featureSourceMap = Collections.synchronizedMap(new HashMap());
        this.pathMap = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(path);
            while ((nextLine = reader.readLine()) != null) {
                String f = nextLine.trim();
                if (f.startsWith("#")) continue;
                String[] tokens = Globals.whitespacePattern.split(nextLine);
                this.pathMap.put(tokens[0], tokens[1]);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private TribbleFeatureSource getSource(String chr) {
        String path;
        TribbleFeatureSource src = this.featureSourceMap.get(chr);
        if (src == null && (path = this.pathMap.get(chr)) != null) {
            try {
                src = new TribbleFeatureSource(path, this.genome);
            }
            catch (IOException e) {
                log.error("Error loading tribble source: " + path);
            }
            this.featureSourceMap.put(chr, src);
        }
        return src;
    }

    public Iterator getFeatures(String chr, int start, int end) throws IOException {
        TribbleFeatureSource src = this.getSource(chr);
        if (src != null) {
            return src.getFeatures(chr, start, end);
        }
        return null;
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        TribbleFeatureSource src = this.getSource(chr);
        if (src != null) {
            return src.getCoverageScores(chr, start, end, zoom);
        }
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.windowSize = size;
    }

    public Object getHeader() {
        if (this.header == null && this.pathMap != null && this.pathMap.size() > 0) {
            String chr = this.pathMap.keySet().iterator().next();
            TribbleFeatureSource src = this.getSource(chr);
            this.header = src.getHeader();
        }
        return this.header;
    }
}

