/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.peaks.Peak;
import org.broad.igv.peaks.PeakCommandBar;
import org.broad.igv.peaks.PeakControlDialog;
import org.broad.igv.peaks.PeakParser;
import org.broad.igv.peaks.PeakRenderer;
import org.broad.igv.peaks.PeakTrackMenu;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class PeakTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(PeakTrack.class);
    static List<SoftReference<PeakTrack>> instances = new ArrayList<SoftReference<PeakTrack>>();
    private static PeakControlDialog controlDialog;
    private static float scoreThreshold;
    private static float foldChangeThreshold;
    private static ColorOption colorOption;
    private static boolean showPeaks;
    private static boolean showSignals;
    int nTimePoints;
    Map<String, List<Peak>> peakMap = new HashMap<String, List<Peak>>();
    Map<String, List<Peak>> filteredPeakMap = new HashMap<String, List<Peak>>();
    Renderer renderer = new PeakRenderer();
    String signalPath;
    private WrappedDataSource signalSource;
    String[] timeSignalPaths;
    WrappedDataSource[] timeSignalSources;
    DataRange scoreDataRange = new DataRange(0.0f, 0.0f, 100.0f);
    DataRange signalDataRange = new DataRange(0.0f, 0.0f, 1000.0f);
    static boolean commandBarAdded;
    int bandHeight;
    int signalHeight;
    int peakHeight;
    int gapHeight;
    Genome genome;
    private String peaksPath;
    PeakParser parser;
    boolean signalSourceLoading = false;

    static synchronized boolean isCommandBarAdded() {
        boolean retValue = commandBarAdded;
        commandBarAdded = true;
        return retValue;
    }

    public PeakTrack(ResourceLocator locator, Genome genome) throws IOException {
        super(locator);
        this.genome = genome;
        this.setHeight(30);
        try {
            long t0 = System.currentTimeMillis();
            this.parser = new PeakParser(locator.getPath());
            this.getAllPeaks("chr2");
            long dt = System.currentTimeMillis() - t0;
            TrackProperties props = new TrackProperties();
            ParsingUtils.parseTrackLine(this.parser.trackLine, props);
            this.setProperties(props);
            this.nTimePoints = this.parser.nTimePoints;
            this.signalPath = this.parser.signalsPath;
            this.timeSignalPaths = this.parser.timeSignalsPath;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        instances.add(new SoftReference<PeakTrack>(this));
        if (!PeakTrack.isCommandBarAdded()) {
            IGV.getInstance().getContentPane().addCommandBar(new PeakCommandBar());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String path) throws IOException {
        BufferedReader br = null;
        try {
            String[] tokens;
            br = ParsingUtils.openBufferedReader(path);
            String nextLine = br.readLine();
            if (nextLine.startsWith("track")) {
                TrackProperties props = new TrackProperties();
                ParsingUtils.parseTrackLine(nextLine, props);
                this.setProperties(props);
            }
            if ((tokens = (nextLine = br.readLine()).split("=")).length < 2 || !tokens[0].equals("timePoints")) {
                throw new RuntimeException("Unexpected timePoints line: " + nextLine);
            }
            tokens = tokens[1].split(",");
            this.nTimePoints = tokens.length;
            nextLine = br.readLine();
            tokens = nextLine.split("=");
            if (tokens.length < 2 || !tokens[0].equals("peaks")) {
                throw new RuntimeException("Unexpected timePoints line: " + nextLine);
            }
            this.peaksPath = tokens[1];
            nextLine = br.readLine();
            tokens = nextLine.split("=");
            if (tokens.length < 2 || !tokens[0].equals("signals")) {
                throw new RuntimeException("Unexpected timePoints line: " + nextLine);
            }
            this.signalPath = tokens[1];
            nextLine = br.readLine();
            tokens = nextLine.split("=");
            if (tokens.length < 2 || !tokens[0].equals("timeSignals")) {
                throw new RuntimeException("Unexpected timePoints line: " + nextLine);
            }
            this.timeSignalPaths = tokens[1].split(",");
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new PeakTrackMenu(this, te);
    }

    @Override
    public DataRange getDataRange() {
        return showSignals ? this.signalDataRange : this.scoreDataRange;
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        if (showSignals) {
            this.signalDataRange = axisDefinition;
        } else {
            this.scoreDataRange = axisDefinition;
        }
    }

    @Override
    public void preload(RenderContext context) {
        try {
            this.getFilteredPeaks(context.getChr());
        }
        catch (IOException e) {
            log.error("Error loading peaks", e);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        try {
            List<Peak> peakList = this.getFilteredPeaks(context.getChr());
            if (peakList == null) {
                return;
            }
            this.renderer.render(peakList, context, rect, this);
        }
        catch (IOException e) {
            log.error("Error loading peaks", e);
        }
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public int getMinimumHeight() {
        int h = 0;
        if (showPeaks) {
            h += 5;
        }
        if (showSignals) {
            h += 10;
        }
        if (showPeaks && showSignals) {
            h += 2;
        }
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return h;
        }
        return this.nTimePoints * h + this.gapHeight;
    }

    @Override
    public void setHeight(int h) {
        super.setHeight(h);
        int nBands = this.getDisplayMode() == Track.DisplayMode.COLLAPSED ? 1 : this.nTimePoints;
        this.bandHeight = h / nBands;
        this.peakHeight = Math.max(5, Math.min(this.bandHeight / 3, 10));
        this.signalHeight = this.bandHeight - this.peakHeight - this.gapHeight;
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        super.setDisplayMode(mode);
        if (mode == Track.DisplayMode.COLLAPSED) {
            this.setHeight(this.bandHeight);
        } else {
            this.setHeight(this.nTimePoints * this.bandHeight + this.gapHeight);
        }
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        try {
            List<LocusScore> scores;
            LocusScore score;
            List<Peak> scores2;
            LocusScore score2;
            boolean foundValue = false;
            StringBuffer buf = new StringBuffer();
            buf.append(this.getName());
            buf.append("<br>");
            if (showPeaks && (score2 = this.getLocusScoreAt(scores2 = this.getFilteredPeaks(chr), position, frame)) != null) {
                foundValue = true;
                buf.append(score2.getValueString(position, this.getWindowFunction()));
                if (showSignals) {
                    buf.append("<br>");
                }
            }
            WrappedDataSource signalSource = this.getSignalSource();
            if (showSignals && signalSource != null && (score = this.getLocusScoreAt(scores = signalSource.getSummaryScoresForRange(chr, (int)frame.getOrigin(), (int)frame.getEnd(), frame.getZoom()), position, frame)) != null) {
                foundValue = true;
                buf.append("Score = " + score.getScore());
            }
            return foundValue ? buf.toString() : null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error loading peaks: " + e.toString();
        }
    }

    private LocusScore getLocusScoreAt(List<? extends LocusScore> scores, double position, ReferenceFrame frame) {
        if (scores == null) {
            return null;
        }
        double bpPerPixel = frame.getScale();
        int buffer = (int)(2.0 * bpPerPixel);
        return FeatureUtils.getFeatureAt(position, buffer, scores);
    }

    public synchronized List<Peak> getFilteredPeaks(String chr) throws IOException {
        List<Peak> filteredPeaks = this.filteredPeakMap.get(chr);
        if (filteredPeaks == null) {
            filteredPeaks = new ArrayList<Peak>();
            List<Peak> allPeaks = this.getAllPeaks(chr);
            if (allPeaks != null) {
                for (Peak peak : allPeaks) {
                    if (!(peak.getCombinedScore() >= scoreThreshold) || !(peak.getFoldChange() >= foldChangeThreshold)) continue;
                    filteredPeaks.add(peak);
                }
            }
        }
        this.filteredPeakMap.put(chr, filteredPeaks);
        return filteredPeaks;
    }

    private List<Peak> getAllPeaks(String chr) throws IOException {
        List<Peak> peaks = this.peakMap.get(chr);
        if (peaks == null) {
            peaks = this.parser.loadPeaks(chr);
            this.peakMap.put(chr, peaks);
        }
        return peaks;
    }

    private static void clearFilteredLists() {
        for (SoftReference<PeakTrack> instance : instances) {
            PeakTrack track = instance.get();
            if (track == null) continue;
            track.filteredPeakMap.clear();
        }
    }

    public static boolean controlDialogIsOpen() {
        return controlDialog != null && controlDialog.isVisible();
    }

    static synchronized void openControlDialog() {
        if (controlDialog == null) {
            controlDialog = new PeakControlDialog(IGV.getMainFrame());
        }
        controlDialog.setVisible(true);
    }

    public static float getScoreThreshold() {
        return scoreThreshold;
    }

    public static void setScoreThreshold(float t) {
        scoreThreshold = t;
        PeakTrack.clearFilteredLists();
    }

    public static ColorOption getColorOption() {
        return colorOption;
    }

    public static void setShadeOption(ColorOption colorOption) {
        PeakTrack.colorOption = colorOption;
    }

    public static float getFoldChangeThreshold() {
        return foldChangeThreshold;
    }

    public static void setFoldChangeThreshold(float foldChangeThreshold) {
        PeakTrack.foldChangeThreshold = foldChangeThreshold;
        PeakTrack.clearFilteredLists();
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        int interval = end - start;
        if (interval <= 0) {
            return Float.MIN_VALUE;
        }
        try {
            List<Peak> scores = this.getFilteredPeaks(chr);
            int startIdx = Math.max(0, FeatureUtils.getIndexBefore(start, scores));
            float regionScore = Float.MIN_VALUE;
            for (int i = startIdx; i < scores.size(); ++i) {
                Peak score = scores.get(i);
                if (score.getEnd() < start) continue;
                if (score.getStart() > end) break;
                float v = score.getScore();
                if (!(v > regionScore)) continue;
                regionScore = v;
            }
            return regionScore;
        }
        catch (IOException e) {
            return Float.MIN_VALUE;
        }
    }

    public Peak getFilteredPeakNearest(String chr, double position) {
        try {
            List<Peak> scores = this.getFilteredPeaks(chr);
            int startIdx = FeatureUtils.getIndexBefore(position, scores);
            Peak closestPeak = null;
            double closestDistance = 2.147483647E9;
            if (startIdx >= 0) {
                if (startIdx > 0) {
                    --startIdx;
                }
                for (int i = startIdx; i < scores.size(); ++i) {
                    Peak peak = scores.get(i);
                    if (position > (double)peak.getStart() && position < (double)peak.getEnd()) {
                        return peak;
                    }
                    double distance = Math.min(Math.abs(position - (double)peak.getStart()), Math.abs(position - (double)peak.getEnd()));
                    if (distance > closestDistance) {
                        return closestDistance < 2000.0 ? closestPeak : null;
                    }
                    closestDistance = distance;
                    closestPeak = peak;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isShowPeaks() {
        return showPeaks;
    }

    public static void setShowPeaks(boolean b) {
        showPeaks = b;
    }

    public static boolean isShowSignals() {
        return showSignals;
    }

    public static void setShowSignals(boolean b) {
        showSignals = b;
    }

    public DataSource[] getTimeSignalSources() {
        if (this.timeSignalSources == null && this.timeSignalPaths != null && this.timeSignalPaths.length > 0) {
            this.timeSignalSources = new WrappedDataSource[this.timeSignalPaths.length];
            for (int i = 0; i < this.timeSignalPaths.length; ++i) {
                try {
                    this.timeSignalSources[i] = new WrappedDataSource(new TDFDataSource(TDFReader.getReader(this.timeSignalPaths[i]), 0, "", this.genome));
                    this.timeSignalSources[i].setNormalizeCounts(true, 1.0E9f);
                    continue;
                }
                catch (Exception e) {
                    this.timeSignalSources[i] = null;
                    e.printStackTrace();
                }
            }
        }
        return this.timeSignalSources;
    }

    public WrappedDataSource getSignalSource() {
        return this.signalSource;
    }

    WrappedDataSource getSignalSource(final String chr, final int contextStart, final int contextEnd, final int zoom) {
        if (this.signalSource == null && this.signalPath != null && !this.signalSourceLoading) {
            this.signalSourceLoading = true;
            NamedRunnable runnable = new NamedRunnable(){

                @Override
                public void run() {
                    PeakTrack.this.signalSource = new WrappedDataSource(new TDFDataSource(TDFReader.getReader(PeakTrack.this.signalPath), 0, "", PeakTrack.this.genome));
                    PeakTrack.this.signalSource.setNormalizeCounts(true, 1.0E9f);
                    PeakTrack.this.signalSource.getSummaryScoresForRange(chr, contextStart, contextEnd, zoom);
                }

                @Override
                public String getName() {
                    return "Load " + PeakTrack.this.signalPath;
                }
            };
            LongRunningTask.submit(runnable);
        }
        return this.signalSource;
    }

    public String getSignalPath() {
        return this.signalPath;
    }

    private InViewInterval computeScale(double origin, double end, List<LocusScore> scores) {
        InViewInterval interval = new InViewInterval();
        if (scores.size() == 1) {
            interval.dataMax = Math.max(0.0f, scores.get(0).getScore());
            interval.dataMin = Math.min(0.0f, scores.get(0).getScore());
        } else {
            int i;
            interval.startIdx = 0;
            interval.endIdx = scores.size();
            for (i = 1; i < scores.size(); ++i) {
                if (!((double)scores.get(i).getEnd() >= origin)) continue;
                interval.startIdx = i - 1;
                break;
            }
            for (i = interval.startIdx + 1; i < scores.size(); ++i) {
                LocusScore locusScore = scores.get(i);
                float value = locusScore.getScore();
                if (Float.isNaN(value)) {
                    value = 0.0f;
                }
                interval.dataMax = Math.max(interval.dataMax, value);
                interval.dataMin = Math.min(interval.dataMin, value);
                if (!((double)locusScore.getStart() > end)) continue;
                interval.endIdx = i;
                break;
            }
        }
        return interval;
    }

    static {
        scoreThreshold = 30.0f;
        foldChangeThreshold = 0.0f;
        colorOption = ColorOption.SCORE;
        showPeaks = true;
        showSignals = false;
        commandBarAdded = false;
    }

    class InViewInterval {
        int startIdx;
        int endIdx;
        float dataMax = 0.0f;
        float dataMin = 0.0f;

        InViewInterval() {
        }
    }

    class WrappedDataSource
    implements DataSource {
        TDFDataSource source;

        WrappedDataSource(TDFDataSource source) {
            this.source = source;
        }

        @Override
        public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
            ArrayList<LocusScore> scores;
            block7: {
                scores = new ArrayList<LocusScore>(1000);
                if (scoreThreshold <= 0.0f && foldChangeThreshold <= 0.0f) {
                    return this.source.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
                }
                try {
                    List<Peak> peaks = PeakTrack.this.getFilteredPeaks(chr);
                    if (peaks == null) {
                        return scores;
                    }
                    int startIdx = FeatureUtils.getIndexBefore(startLocation, peaks);
                    if (startIdx < 0) break block7;
                    block2: for (int i = startIdx; i < peaks.size(); ++i) {
                        Peak peak = peaks.get(i);
                        int peakEnd = peak.getEnd();
                        if (peakEnd < startLocation) continue;
                        int peakStart = peak.getStart();
                        if (peakStart <= endLocation) {
                            List<LocusScore> peakScores = this.source.getSummaryScoresForRange(chr, peakStart, peakEnd, zoom);
                            for (LocusScore ps : peakScores) {
                                if (ps.getEnd() < peakStart) continue;
                                if (ps.getStart() > peakEnd) continue block2;
                                scores.add(ps);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return scores;
        }

        @Override
        public double getDataMax() {
            return this.source.getDataMax();
        }

        @Override
        public double getDataMin() {
            return this.source.getDataMin();
        }

        @Override
        public TrackType getTrackType() {
            return this.source.getTrackType();
        }

        @Override
        public void setWindowFunction(WindowFunction statType) {
            this.source.setWindowFunction(statType);
        }

        @Override
        public boolean isLogNormalized() {
            return this.source.isLogNormalized();
        }

        @Override
        public WindowFunction getWindowFunction() {
            return this.source.getWindowFunction();
        }

        @Override
        public Collection<WindowFunction> getAvailableWindowFunctions() {
            return this.source.getAvailableWindowFunctions();
        }

        @Override
        public void dispose() {
            this.source.dispose();
        }

        public void setNormalizeCounts(boolean b, float v) {
            this.source.setNormalizeCounts(b, v);
        }

        public void updateGenome(Genome genome) {
            this.source.updateGenome(genome);
        }
    }

    static enum ColorOption {
        SCORE,
        FOLD_CHANGE;

    }
}

