/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.gwas.GWASData;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class GWASParser {
    private static final Logger log = Logger.getLogger(GWASParser.class);
    private ResourceLocator locator;
    private int locationCol = -1;
    private int chrCol = -1;
    private int pCol = -1;
    private int SNPCol = -1;
    Genome genome;

    public static boolean isGWASFile(String typeString) {
        return typeString.endsWith(".logistic") || typeString.endsWith(".linear") || typeString.endsWith(".assoc") || typeString.endsWith(".qassoc") || typeString.endsWith(".gwas");
    }

    public GWASParser(ResourceLocator locator, Genome genome) {
        this.locator = locator;
        this.genome = genome;
    }

    public boolean parseHeader(String headerString) {
        boolean parsingSuccessful = true;
        String[] headers = Globals.singleTabMultiSpacePattern.split(headerString = headerString.trim());
        int headersSize = headers.length;
        if (headersSize < 4) {
            parsingSuccessful = false;
        }
        int colCounter = 0;
        for (int i = 0; i < headersSize; ++i) {
            String header = headers[i];
            if ((header = header.toLowerCase()).equals("chr") || header.equals("chromosome")) {
                this.chrCol = colCounter;
            }
            if (header.equals("bp") || header.equals("pos") || header.equals("position")) {
                this.locationCol = colCounter;
            }
            if (header.equals("p") || header.equals("pval") || header.equals("p-value") || header.equals("pvalue") || header.equals("p.value")) {
                this.pCol = colCounter;
            }
            if (header.equals("snp") || header.equals("rs") || header.equals("rsid") || header.equals("rsnum") || header.equals("id") || header.equals("marker") || header.equals("markername")) {
                this.SNPCol = colCounter;
            }
            ++colCounter;
        }
        if (this.locationCol < 0 || this.chrCol < 0 || this.pCol < 0 || this.SNPCol < 0) {
            parsingSuccessful = false;
        }
        return parsingSuccessful;
    }

    public GWASData parseDescriptions(GWASData gData, String hitChr, long hitLocation, int searchStartRow) throws IOException {
        AsciiLineReader reader = null;
        String nextLine = null;
        boolean hitFound = false;
        int cacheSize = gData.getDescriptionCache().getMaxSize();
        int rowCounter = 0;
        try {
            reader = ParsingUtils.openAsciiReader(this.locator);
            String headerLine = reader.readLine();
            if (!this.parseHeader(headerLine)) {
                throw new ParserException("Error while parsing header line.", 0L, nextLine);
            }
            gData.getDescriptionCache().setHeaderTokens(headerLine);
            int cacheAfter = cacheSize / 2;
            int cacheCounter = 0;
            while (cacheCounter < cacheAfter && (nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                GWASEntry entry;
                nextLine = nextLine.trim();
                if (++rowCounter < searchStartRow || (entry = this.parseLine(nextLine, rowCounter)) == null) continue;
                if (entry.chr.equals(hitChr) && (long)entry.start == hitLocation) {
                    hitFound = true;
                }
                if (hitFound) {
                    ++cacheCounter;
                }
                gData.getDescriptionCache().add(entry.chr, entry.start, entry.p, nextLine);
            }
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Exception e) {
            if (nextLine != null && rowCounter != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, rowCounter, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return gData;
    }

    public GWASData parse() throws IOException {
        AsciiLineReader reader = null;
        String nextLine = null;
        int rowCounter = 0;
        try {
            reader = ParsingUtils.openAsciiReader(this.locator);
            String headerLine = reader.readLine();
            if (!this.parseHeader(headerLine)) {
                throw new ParserException("Error while parsing header line.", 0L, nextLine);
            }
            GWASData gData = new GWASData();
            int indexCounter = 0;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                GWASEntry entry = this.parseLine(nextLine = nextLine.trim(), ++rowCounter);
                if (entry == null) continue;
                gData.addLocation(entry.chr, entry.start);
                gData.addValue(entry.chr, entry.p);
                int indexSize = 10000;
                if (++indexCounter != indexSize) continue;
                gData.getFileIndex().add((int)reader.getPosition());
                indexCounter = 0;
            }
            GWASData gWASData = gData;
            return gWASData;
        }
        catch (Exception e) {
            if (nextLine != null && rowCounter != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, rowCounter, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private GWASEntry parseLine(String nextLine, long lineNumber) {
        String[] tokens = Globals.singleTabMultiSpacePattern.split(nextLine);
        if (tokens.length > 1) {
            int start;
            String chr = this.genome.getChromosomeAlias(tokens[this.chrCol].trim());
            try {
                start = Integer.parseInt(tokens[this.locationCol].trim());
            }
            catch (NumberFormatException e) {
                throw new ParserException("Column " + this.locationCol + " must be a numeric value.", lineNumber, nextLine);
            }
            if (!tokens[this.pCol].trim().equalsIgnoreCase("NA")) {
                double p;
                try {
                    p = Double.parseDouble(tokens[this.pCol]);
                    if (p <= 0.0) {
                        throw new NumberFormatException();
                    }
                    p = -Math.log10(p);
                }
                catch (NumberFormatException e) {
                    throw new ParserException("Column " + this.pCol + " must be a positive numeric value. Found " + tokens[this.pCol], lineNumber, nextLine);
                }
                return new GWASEntry(chr, start, p, nextLine);
            }
        }
        return null;
    }

    private static class GWASEntry {
        private final String chr;
        private final int start;
        private final double p;
        private final String description;

        private GWASEntry(String chr, int start, double p, String description) {
            this.chr = chr;
            this.start = start;
            this.p = p;
            this.description = description;
        }
    }
}

