/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.io.File;
import java.util.List;
import java.util.Set;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.directed.CalculateHsMetrics;
import net.sf.picard.analysis.directed.TargetMetricsCollector;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.SequenceUtil;

public abstract class CollectTargetedMetrics
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CalculateHsMetrics.class);
    @Option(shortName="TI", doc="An interval list file that contains the locations of the targets.")
    public File TARGET_INTERVALS;
    @Option(shortName="I", doc="An aligned SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="The output file to write the metrics to.")
    public File OUTPUT;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Option(shortName="R", optional=true, doc="The reference sequence aligned to.")
    public File REFERENCE_SEQUENCE;
    @Option(optional=true, doc="An optional file to output per target coverage information to.")
    public File PER_TARGET_COVERAGE;

    protected abstract File getProbeIntervals();

    protected abstract String getProbeSetName();

    protected abstract TargetMetricsCollector makeCollector(Set<MetricAccumulationLevel> var1, List<SAMReadGroupRecord> var2, ReferenceSequenceFile var3, File var4, File var5, File var6, String var7);

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.getProbeIntervals());
        IoUtil.assertFileIsReadable(this.TARGET_INTERVALS);
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (this.PER_TARGET_COVERAGE != null) {
            IoUtil.assertFileIsWritable(this.PER_TARGET_COVERAGE);
        }
        SAMFileReader samReader = new SAMFileReader(this.INPUT);
        File probeIntervals = this.getProbeIntervals();
        SequenceUtil.assertSequenceDictionariesEqual(samReader.getFileHeader().getSequenceDictionary(), IntervalList.fromFile(this.TARGET_INTERVALS).getHeader().getSequenceDictionary(), this.INPUT, this.TARGET_INTERVALS);
        SequenceUtil.assertSequenceDictionariesEqual(samReader.getFileHeader().getSequenceDictionary(), IntervalList.fromFile(probeIntervals).getHeader().getSequenceDictionary(), this.INPUT, probeIntervals);
        ReferenceSequenceFile ref = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IoUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
            ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
            SequenceUtil.assertSequenceDictionariesEqual(samReader.getFileHeader().getSequenceDictionary(), ref.getSequenceDictionary(), this.INPUT, this.REFERENCE_SEQUENCE);
        }
        TargetMetricsCollector collector = this.makeCollector(this.METRIC_ACCUMULATION_LEVEL, samReader.getFileHeader().getReadGroups(), ref, this.PER_TARGET_COVERAGE, this.TARGET_INTERVALS, probeIntervals, this.getProbeSetName());
        SAMRecordIterator records = samReader.iterator();
        ProgressLogger progress = new ProgressLogger(log);
        while (records.hasNext()) {
            SAMRecord sam = (SAMRecord)records.next();
            collector.acceptRecord(sam, null);
            progress.record(sam);
        }
        MetricsFile metrics = this.getMetricsFile();
        collector.finish();
        collector.addAllLevelsToFile(metrics);
        metrics.write(this.OUTPUT);
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PER_TARGET_COVERAGE != null && (this.METRIC_ACCUMULATION_LEVEL.size() != 1 || this.METRIC_ACCUMULATION_LEVEL.iterator().next() != MetricAccumulationLevel.ALL_READS)) {
            return new String[]{"PER_TARGET_COVERAGE can be specified only when METRIC_ACCUMULATION_LEVEL is set to ALL_READS."};
        }
        if (this.PER_TARGET_COVERAGE != null && this.REFERENCE_SEQUENCE == null) {
            return new String[]{"Must supply REFERENCE_SEQUENCE when supplying PER_TARGET_COVERAGE"};
        }
        return super.customCommandLineValidation();
    }
}

