/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.NameAwareCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.vcf.VCFConstants;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFFilterHeaderLine;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;
import org.broadinstitute.variant.vcf.VCFSimpleHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

public abstract class AbstractVCFCodec
extends AsciiFeatureCodec<VariantContext>
implements NameAwareCodec {
    public static final int MAX_ALLELE_SIZE_BEFORE_WARNING = (int)Math.pow(2.0, 20.0);
    protected static final int NUM_STANDARD_FIELDS = 8;
    protected VCFHeader header = null;
    protected VCFHeaderVersion version = null;
    protected Map<String, List<Allele>> alleleMap = new HashMap<String, List<Allele>>(3);
    protected String[] GTValueArray = new String[100];
    protected String[] genotypeKeyArray = new String[100];
    protected String[] infoFieldArray = new String[1000];
    protected String[] infoValueArray = new String[1000];
    public static boolean validate = true;
    protected String[] parts = null;
    protected String[] genotypeParts = null;
    protected final String[] locParts = new String[6];
    protected HashMap<String, List<String>> filterHash = new HashMap();
    protected String name = "Unknown";
    protected int lineNo = 0;
    protected Map<String, String> stringCache = new HashMap<String, String>();
    protected boolean warnedAboutNoEqualsForNonFlag = false;
    protected boolean doOnTheFlyModifications = true;
    private static final String[] INT_DECODE_ARRAY = new String[10000];

    protected AbstractVCFCodec() {
        super(VariantContext.class);
    }

    protected abstract List<String> parseFilters(String var1);

    protected VCFHeader parseHeaderFromLines(List<String> headerStrings, VCFHeaderVersion version) {
        this.version = version;
        LinkedHashSet<VCFHeaderLine> metaData = new LinkedHashSet<VCFHeaderLine>();
        LinkedHashSet<String> sampleNames = new LinkedHashSet<String>();
        int contigCounter = 0;
        for (String str : headerStrings) {
            if (!str.startsWith("##")) {
                String[] strings = str.substring(1).split("\t");
                if (strings.length < VCFHeader.HEADER_FIELDS.values().length) {
                    throw new TribbleException.InvalidHeader("there are not enough columns present in the header line: " + str);
                }
                int arrayIndex = 0;
                for (VCFHeader.HEADER_FIELDS field : VCFHeader.HEADER_FIELDS.values()) {
                    try {
                        if (field != VCFHeader.HEADER_FIELDS.valueOf(strings[arrayIndex])) {
                            throw new TribbleException.InvalidHeader("we were expecting column name '" + (Object)((Object)field) + "' but we saw '" + strings[arrayIndex] + "'");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new TribbleException.InvalidHeader("unknown column name '" + strings[arrayIndex] + "'; it does not match a legal column header name.");
                    }
                    ++arrayIndex;
                }
                boolean sawFormatTag = false;
                if (arrayIndex < strings.length) {
                    if (!strings[arrayIndex].equals("FORMAT")) {
                        throw new TribbleException.InvalidHeader("we were expecting column name 'FORMAT' but we saw '" + strings[arrayIndex] + "'");
                    }
                    sawFormatTag = true;
                    ++arrayIndex;
                }
                while (arrayIndex < strings.length) {
                    sampleNames.add(strings[arrayIndex++]);
                }
                if (!sawFormatTag || sampleNames.size() != 0) continue;
                throw new TribbleException.InvalidHeader("The FORMAT field was provided but there is no genotype/sample data");
            }
            if (str.startsWith("##INFO")) {
                VCFInfoHeaderLine info = new VCFInfoHeaderLine(str.substring(7), version);
                metaData.add(info);
                continue;
            }
            if (str.startsWith("##FILTER")) {
                VCFFilterHeaderLine filter = new VCFFilterHeaderLine(str.substring(9), version);
                metaData.add(filter);
                continue;
            }
            if (str.startsWith("##FORMAT")) {
                VCFFormatHeaderLine format = new VCFFormatHeaderLine(str.substring(9), version);
                metaData.add(format);
                continue;
            }
            if (str.startsWith("##contig")) {
                VCFContigHeaderLine contig = new VCFContigHeaderLine(str.substring(9), version, "##contig".substring(2), contigCounter++);
                metaData.add(contig);
                continue;
            }
            if (str.startsWith("##ALT")) {
                VCFSimpleHeaderLine alt = new VCFSimpleHeaderLine(str.substring(6), version, "##ALT".substring(2), Arrays.asList("ID", "Description"));
                metaData.add(alt);
                continue;
            }
            int equals = str.indexOf("=");
            if (equals == -1) continue;
            metaData.add(new VCFHeaderLine(str.substring(2, equals), str.substring(equals + 1)));
        }
        this.header = new VCFHeader(metaData, sampleNames);
        if (this.doOnTheFlyModifications) {
            this.header = VCFStandardHeaderLines.repairStandardHeaderLines(this.header);
        }
        return this.header;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decodeLine(line, false);
    }

    @Override
    public VariantContext decode(String line) {
        return this.decodeLine(line, true);
    }

    private final VariantContext decodeLine(String line, boolean includeGenotypes) {
        if (line.startsWith("#")) {
            return null;
        }
        if (this.header == null) {
            throw new TribbleException("VCF Header cannot be null when decoding a record");
        }
        if (this.parts == null) {
            this.parts = new String[Math.min(this.header.getColumnCount(), 9)];
        }
        int nParts = ParsingUtils.split(line, this.parts, '\t', true);
        if ((this.header == null || !this.header.hasGenotypingData()) && nParts != 8 || this.header != null && this.header.hasGenotypingData() && nParts != 9) {
            throw new TribbleException("Line " + this.lineNo + ": there aren't enough columns for line " + line + " (we expected " + (this.header == null ? 8 : 9) + " tokens, and saw " + nParts + " )");
        }
        return this.parseVCFLine(this.parts, includeGenotypes);
    }

    private VariantContext parseVCFLine(String[] parts, boolean includeGenotypes) {
        VariantContextBuilder builder = new VariantContextBuilder();
        builder.source(this.getName());
        ++this.lineNo;
        String chr = this.getCachedString(parts[0]);
        builder.chr(chr);
        int pos = -1;
        try {
            pos = Integer.valueOf(parts[1]);
        }
        catch (NumberFormatException e) {
            this.generateException(parts[1] + " is not a valid start position in the VCF format");
        }
        builder.start(pos);
        if (parts[2].length() == 0) {
            this.generateException("The VCF specification requires a valid ID field");
        } else if (parts[2].equals(".")) {
            builder.noID();
        } else {
            builder.id(parts[2]);
        }
        String ref = this.getCachedString(parts[3].toUpperCase());
        String alts = this.getCachedString(parts[4].toUpperCase());
        builder.log10PError(AbstractVCFCodec.parseQual(parts[5]));
        List<String> filters = this.parseFilters(this.getCachedString(parts[6]));
        if (filters != null) {
            builder.filters(new HashSet<String>(filters));
        }
        Map<String, Object> attrs = this.parseInfo(parts[7]);
        builder.attributes(attrs);
        if (attrs.containsKey("END")) {
            try {
                builder.stop(Integer.valueOf(attrs.get("END").toString()).intValue());
            }
            catch (Exception e) {
                this.generateException("the END value in the INFO field is not valid");
            }
        } else {
            builder.stop(pos + ref.length() - 1);
        }
        List<Allele> alleles = AbstractVCFCodec.parseAlleles(ref, alts, this.lineNo);
        builder.alleles((Collection<Allele>)alleles);
        if (parts.length > 8 && includeGenotypes) {
            LazyVCFGenotypesParser lazyParser = new LazyVCFGenotypesParser(alleles, chr, pos);
            int nGenotypes = this.header.getNGenotypeSamples();
            LazyGenotypesContext lazy = new LazyGenotypesContext(lazyParser, parts[8], nGenotypes);
            if (!this.header.samplesWereAlreadySorted()) {
                lazy.decode();
            }
            builder.genotypesNoValidation(lazy);
        }
        VariantContext vc = null;
        try {
            vc = builder.make();
        }
        catch (Exception e) {
            this.generateException(e.getMessage());
        }
        return vc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected String getCachedString(String str) {
        String internedString = this.stringCache.get(str);
        if (internedString == null) {
            internedString = new String(str);
            this.stringCache.put(internedString, internedString);
        }
        return internedString;
    }

    private Map<String, Object> parseInfo(String infoField) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (infoField.length() == 0) {
            this.generateException("The VCF specification requires a valid info field");
        }
        if (!infoField.equals(".")) {
            if (infoField.indexOf("\t") != -1 || infoField.indexOf(" ") != -1) {
                this.generateException("The VCF specification does not allow for whitespace in the INFO field");
            }
            int infoFieldSplitSize = ParsingUtils.split(infoField, this.infoFieldArray, ';', false);
            for (int i = 0; i < infoFieldSplitSize; ++i) {
                Object value;
                String key;
                int eqI = this.infoFieldArray[i].indexOf("=");
                if (eqI != -1) {
                    key = this.infoFieldArray[i].substring(0, eqI);
                    String valueString = this.infoFieldArray[i].substring(eqI + 1);
                    int infoValueSplitSize = ParsingUtils.split(valueString, this.infoValueArray, ',', false);
                    if (infoValueSplitSize == 1) {
                        value = this.infoValueArray[0];
                        VCFInfoHeaderLine headerLine = this.header.getInfoHeaderLine(key);
                        if (headerLine != null && headerLine.getType() == VCFHeaderLineType.Flag && value.equals("0")) {
                            continue;
                        }
                    } else {
                        ArrayList<String> valueList = new ArrayList<String>(infoValueSplitSize);
                        for (int j = 0; j < infoValueSplitSize; ++j) {
                            valueList.add(this.infoValueArray[j]);
                        }
                        value = valueList;
                    }
                } else {
                    key = this.infoFieldArray[i];
                    VCFInfoHeaderLine headerLine = this.header.getInfoHeaderLine(key);
                    value = headerLine != null && headerLine.getType() != VCFHeaderLineType.Flag ? "." : Boolean.valueOf(true);
                }
                if ("".equals(value)) {
                    value = ".";
                }
                attributes.put(key, value);
            }
        }
        return attributes;
    }

    protected static Allele oneAllele(String index, List<Allele> alleles) {
        int i;
        if (index.equals(".")) {
            return Allele.NO_CALL;
        }
        try {
            i = Integer.valueOf(index);
        }
        catch (NumberFormatException e) {
            throw new TribbleException.InternalCodecException("The following invalid GT allele index was encountered in the file: " + index);
        }
        if (i >= alleles.size()) {
            throw new TribbleException.InternalCodecException("The allele with index " + index + " is not defined in the REF/ALT columns in the record");
        }
        return alleles.get(i);
    }

    protected static List<Allele> parseGenotypeAlleles(String GT, List<Allele> alleles, Map<String, List<Allele>> cache) {
        List<Allele> GTAlleles = cache.get(GT);
        if (GTAlleles == null) {
            StringTokenizer st = new StringTokenizer(GT, "/|\\");
            GTAlleles = new ArrayList<Allele>(st.countTokens());
            while (st.hasMoreTokens()) {
                String genotype = st.nextToken();
                GTAlleles.add(AbstractVCFCodec.oneAllele(genotype, alleles));
            }
            cache.put(GT, GTAlleles);
        }
        return GTAlleles;
    }

    protected static Double parseQual(String qualString) {
        if (qualString.equals(".")) {
            return 1.0;
        }
        Double val = Double.valueOf(qualString);
        if (val < 0.0 && Math.abs(val - VCFConstants.MISSING_QUALITY_v3_DOUBLE) < VCFConstants.VCF_ENCODING_EPSILON) {
            return 1.0;
        }
        return val / -10.0;
    }

    protected static List<Allele> parseAlleles(String ref, String alts, int lineNo) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(2);
        AbstractVCFCodec.checkAllele(ref, true, lineNo);
        Allele refAllele = Allele.create(ref, true);
        alleles.add(refAllele);
        if (alts.indexOf(",") == -1) {
            AbstractVCFCodec.parseSingleAltAllele(alleles, alts, lineNo);
        } else {
            for (String alt : alts.split(",")) {
                AbstractVCFCodec.parseSingleAltAllele(alleles, alt, lineNo);
            }
        }
        return alleles;
    }

    private static void checkAllele(String allele, boolean isRef, int lineNo) {
        if (allele == null || allele.length() == 0) {
            AbstractVCFCodec.generateException("Empty alleles are not permitted in VCF records", lineNo);
        }
        if (AbstractVCFCodec.isSymbolicAllele(allele)) {
            if (isRef) {
                AbstractVCFCodec.generateException("Symbolic alleles not allowed as reference allele: " + allele, lineNo);
            }
        } else {
            if (allele.charAt(0) == 'D' || allele.charAt(0) == 'I') {
                AbstractVCFCodec.generateException("Insertions/Deletions are not supported when reading 3.x VCF's. Please convert your file to VCF4 using VCFTools, available at http://vcftools.sourceforge.net/index.html", lineNo);
            }
            if (!Allele.acceptableAlleleBases(allele)) {
                AbstractVCFCodec.generateException("Unparsable vcf record with allele " + allele, lineNo);
            }
            if (isRef && allele.equals(".")) {
                AbstractVCFCodec.generateException("The reference allele cannot be missing", lineNo);
            }
        }
    }

    private static boolean isSymbolicAllele(String allele) {
        return allele != null && allele.length() > 2 && (allele.startsWith("<") && allele.endsWith(">") || allele.contains("[") || allele.contains("]"));
    }

    private static void parseSingleAltAllele(List<Allele> alleles, String alt, int lineNo) {
        AbstractVCFCodec.checkAllele(alt, false, lineNo);
        Allele allele = Allele.create(alt, false);
        if (!allele.isNoCall()) {
            alleles.add(allele);
        }
    }

    public static final boolean canDecodeFile(String potentialInput, String MAGIC_HEADER_LINE) {
        try {
            return AbstractVCFCodec.isVCFStream(new FileInputStream(potentialInput), MAGIC_HEADER_LINE) || AbstractVCFCodec.isVCFStream(new GZIPInputStream(new FileInputStream(potentialInput)), MAGIC_HEADER_LINE) || AbstractVCFCodec.isVCFStream(new BlockCompressedInputStream(new FileInputStream(potentialInput)), MAGIC_HEADER_LINE);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isVCFStream(InputStream stream, String MAGIC_HEADER_LINE) {
        try {
            boolean eq;
            byte[] buff = new byte[MAGIC_HEADER_LINE.length()];
            int nread = stream.read(buff, 0, MAGIC_HEADER_LINE.length());
            boolean bl = eq = Arrays.equals(buff, MAGIC_HEADER_LINE.getBytes());
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    public LazyGenotypesContext.LazyData createGenotypeMap(String str, List<Allele> alleles, String chr, int pos) {
        int nParts;
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        if ((nParts = ParsingUtils.split(str, this.genotypeParts, '\t')) != this.genotypeParts.length) {
            AbstractVCFCodec.generateException("there are " + (nParts - 1) + " genotypes while the header requires that " + (this.genotypeParts.length - 1) + " genotypes be present for all records at " + chr + ":" + pos, this.lineNo);
        }
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>(nParts);
        int nGTKeys = ParsingUtils.split(this.genotypeParts[0], this.genotypeKeyArray, ':');
        Iterator<String> sampleNameIterator = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        for (int genotypeOffset = 1; genotypeOffset < nParts; ++genotypeOffset) {
            int GTValueSplitSize = ParsingUtils.split(this.genotypeParts[genotypeOffset], this.GTValueArray, ':');
            String sampleName = sampleNameIterator.next();
            GenotypeBuilder gb = new GenotypeBuilder(sampleName);
            if (nGTKeys < GTValueSplitSize) {
                this.generateException("There are too many keys for the sample " + sampleName + ", keys = " + this.parts[8] + ", values = " + this.parts[genotypeOffset]);
            }
            int genotypeAlleleLocation = -1;
            if (nGTKeys >= 1) {
                gb.maxAttributes(nGTKeys - 1);
                for (int i = 0; i < nGTKeys; ++i) {
                    boolean missing;
                    String gtKey = this.genotypeKeyArray[i];
                    boolean bl = missing = i >= GTValueSplitSize;
                    if (gtKey.equals("GT")) {
                        genotypeAlleleLocation = i;
                        continue;
                    }
                    if (missing) continue;
                    if (gtKey.equals("FT")) {
                        List<String> filters = this.parseFilters(this.getCachedString(this.GTValueArray[i]));
                        if (filters == null) continue;
                        gb.filters(filters);
                        continue;
                    }
                    if (this.GTValueArray[i].equals(".")) continue;
                    if (gtKey.equals("GQ")) {
                        if (this.GTValueArray[i].equals("-1")) {
                            gb.noGQ();
                            continue;
                        }
                        gb.GQ((int)Math.round(Double.valueOf(this.GTValueArray[i])));
                        continue;
                    }
                    if (gtKey.equals("AD")) {
                        gb.AD(AbstractVCFCodec.decodeInts(this.GTValueArray[i]));
                        continue;
                    }
                    if (gtKey.equals("PL")) {
                        gb.PL(AbstractVCFCodec.decodeInts(this.GTValueArray[i]));
                        continue;
                    }
                    if (gtKey.equals("GL")) {
                        gb.PL(GenotypeLikelihoods.fromGLField(this.GTValueArray[i]).getAsPLs());
                        continue;
                    }
                    if (gtKey.equals("DP")) {
                        gb.DP(Integer.valueOf(this.GTValueArray[i]));
                        continue;
                    }
                    gb.attribute(gtKey, this.GTValueArray[i]);
                }
            }
            if (this.version != VCFHeaderVersion.VCF4_1 && genotypeAlleleLocation == -1) {
                this.generateException("Unable to find the GT field for the record; the GT field is required in VCF4.0");
            }
            if (genotypeAlleleLocation > 0) {
                this.generateException("Saw GT field at position " + genotypeAlleleLocation + ", but it must be at the first position for genotypes when present");
            }
            ArrayList<Allele> GTalleles = genotypeAlleleLocation == -1 ? new ArrayList<Allele>(0) : AbstractVCFCodec.parseGenotypeAlleles(this.GTValueArray[genotypeAlleleLocation], alleles, this.alleleMap);
            gb.alleles(GTalleles);
            gb.phased(genotypeAlleleLocation != -1 && this.GTValueArray[genotypeAlleleLocation].indexOf("|") != -1);
            try {
                genotypes.add(gb.make());
                continue;
            }
            catch (TribbleException e) {
                throw new TribbleException.InternalCodecException(e.getMessage() + ", at position " + chr + ":" + pos);
            }
        }
        return new LazyGenotypesContext.LazyData(genotypes, this.header.getSampleNamesInOrder(), this.header.getSampleNameToOffset());
    }

    private static final int[] decodeInts(String string) {
        int nValues = ParsingUtils.split(string, INT_DECODE_ARRAY, ',');
        int[] values = new int[nValues];
        for (int i = 0; i < nValues; ++i) {
            values[i] = Integer.valueOf(INT_DECODE_ARRAY[i]);
        }
        return values;
    }

    public final void disableOnTheFlyModifications() {
        this.doOnTheFlyModifications = false;
    }

    protected void generateException(String message) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", this.lineNo, message));
    }

    protected static void generateException(String message, int lineNo) {
        throw new TribbleException(String.format("The provided VCF file is malformed at approximately line number %d: %s", lineNo, message));
    }

    class LazyVCFGenotypesParser
    implements LazyGenotypesContext.LazyParser {
        final List<Allele> alleles;
        final String contig;
        final int start;

        LazyVCFGenotypesParser(List<Allele> alleles, String contig, int start) {
            this.alleles = alleles;
            this.contig = contig;
            this.start = start;
        }

        @Override
        public LazyGenotypesContext.LazyData parse(Object data) {
            return AbstractVCFCodec.this.createGenotypeMap((String)data, this.alleles, this.contig, this.start);
        }
    }
}

