/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.smithwaterman;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.smithwaterman.SWPairwiseAlignment;

public class SWPairwiseAlignmentMain {
    public static void main(String[] argv) {
        String ref = null;
        String read = null;
        Map<String, List<String>> args = SWPairwiseAlignmentMain.processArgs(argv);
        List<String> l = args.get("SEQ");
        args.remove("SEQ");
        if (l == null) {
            System.err.println("SEQ argument is missing. Two input sequences must be provided");
            System.exit(1);
        }
        if (l.size() != 2) {
            System.err.println("Two input sequences (SEQ arguments) must be provided. Found " + l.size() + " instead");
            System.exit(1);
        }
        ref = l.get(0);
        read = l.get(1);
        Double m = SWPairwiseAlignmentMain.extractSingleDoubleArg("MATCH", args);
        Double mm = SWPairwiseAlignmentMain.extractSingleDoubleArg("MISMATCH", args);
        Double open = SWPairwiseAlignmentMain.extractSingleDoubleArg("OPEN", args);
        Double ext = SWPairwiseAlignmentMain.extractSingleDoubleArg("EXTEND", args);
        Boolean reverse = SWPairwiseAlignmentMain.extractSingleBooleanArg("REVERSE", args);
        if (reverse != null && reverse.booleanValue()) {
            ref = Utils.reverse(ref);
            read = Utils.reverse(read);
        }
        Boolean print_mat = SWPairwiseAlignmentMain.extractSingleBooleanArg("PRINT_MATRIX", args);
        Boolean cut = SWPairwiseAlignmentMain.extractSingleBooleanArg("CUTOFF", args);
        if (cut != null) {
            SWPairwiseAlignment.cutoff = cut;
        }
        if (args.size() != 0) {
            System.err.println("Unknown argument on the command line: " + args.keySet().iterator().next());
            System.exit(1);
        }
        double w_match = m == null ? 30.0 : m;
        double w_mismatch = mm == null ? -10.0 : mm;
        double w_open = open == null ? -10.0 : open;
        double w_extend = ext == null ? -2.0 : ext;
        SWPairwiseAlignment.keepScoringMatrix = true;
        SWPairwiseAlignment a = new SWPairwiseAlignment(ref.getBytes(), read.getBytes(), w_match, w_mismatch, w_open, w_extend);
        System.out.println("start=" + a.getAlignmentStart2wrt1() + ", cigar=" + a.getCigar() + " length1=" + ref.length() + " length2=" + read.length());
        System.out.println();
        a.printAlignment(ref.getBytes(), read.getBytes());
        System.out.println();
        if (print_mat != null && print_mat.booleanValue()) {
            SWPairwiseAlignmentMain.print(a.SW, ref.getBytes(), read.getBytes());
        }
    }

    private static void print(double[] s, byte[] a, byte[] b) {
        int n = a.length + 1;
        int m = b.length + 1;
        System.out.print("         ");
        for (int j = 1; j < m; ++j) {
            System.out.printf(" %5c", Character.valueOf((char)b[j - 1]));
        }
        System.out.println();
        int i = 0;
        int row_offset = 0;
        while (i < n) {
            if (i > 0) {
                System.out.print((char)a[i - 1]);
            } else {
                System.out.print(' ');
            }
            System.out.print("  ");
            for (int j = 0; j < m; ++j) {
                System.out.printf(" %5.1f", s[row_offset + j]);
            }
            System.out.println();
            ++i;
            row_offset += m;
        }
    }

    static Pair<String, Integer> getArg(String prefix, String[] argv, int i) {
        String arg = null;
        if (argv[i].startsWith(prefix)) {
            arg = argv[i].substring(prefix.length());
            if (arg.length() == 0) {
                if (++i < argv.length) {
                    arg = argv[i];
                } else {
                    System.err.println("No value found after " + prefix + " argument tag");
                    System.exit(1);
                }
            }
            ++i;
        }
        return new Pair<Object, Integer>(arg, i);
    }

    static Map<String, List<String>> processArgs(String[] argv) {
        HashMap<String, List<String>> args = new HashMap<String, List<String>>();
        for (int i = 0; i < argv.length; ++i) {
            ArrayList<String> l;
            String val;
            String arg = argv[i];
            int pos = arg.indexOf(61);
            if (pos < 0) {
                System.err.println("Argument " + arg + " is not of the form <ARG>=<VAL>");
                System.exit(1);
            }
            if ((val = arg.substring(pos + 1)).length() == 0) {
                if (++i < argv.length) {
                    val = argv[i];
                } else {
                    System.err.println("No value found after " + arg + " argument tag");
                    System.exit(1);
                }
            }
            if ((l = (ArrayList<String>)args.get(arg = arg.substring(0, pos))) == null) {
                l = new ArrayList<String>();
                args.put(arg, l);
            }
            l.add(val);
        }
        return args;
    }

    static Double extractSingleDoubleArg(String argname, Map<String, List<String>> args) {
        List<String> l = args.get(argname);
        args.remove(argname);
        if (l == null) {
            return null;
        }
        if (l.size() > 1) {
            System.err.println("Only one " + argname + " argument is allowed");
            System.exit(1);
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(l.get(0));
        }
        catch (NumberFormatException e) {
            System.err.println("Can not parse value provided for " + argname + " argument (" + l.get(0) + ")");
            System.exit(1);
        }
        System.out.println("Argument " + argname + " set to " + d);
        return new Double(d);
    }

    static Boolean extractSingleBooleanArg(String argname, Map<String, List<String>> args) {
        List<String> l = args.get(argname);
        args.remove(argname);
        if (l == null) {
            return null;
        }
        if (l.size() > 1) {
            System.err.println("Only one " + argname + " argument is allowed");
            System.exit(1);
        }
        if (l.get(0).equals("true")) {
            return true;
        }
        if (l.get(0).equals("false")) {
            return false;
        }
        System.err.println("Can not parse value provided for " + argname + " argument (" + l.get(0) + "); true/false are allowed");
        System.exit(1);
        return false;
    }
}

