/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class NestedIntegerArray<T> {
    private static Logger logger = Logger.getLogger(NestedIntegerArray.class);
    protected final Object[] data;
    protected final int numDimensions;
    protected final int[] dimensions;
    private static final int NUM_DIMENSIONS_TO_PREALLOCATE = 2;

    public NestedIntegerArray(int ... dimensions) {
        this.numDimensions = dimensions.length;
        if (this.numDimensions == 0) {
            throw new ReviewedStingException("There must be at least one dimension to an NestedIntegerArray");
        }
        this.dimensions = (int[])dimensions.clone();
        int dimensionsToPreallocate = Math.min(dimensions.length, 2);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Creating NestedIntegerArray with dimensions %s", Arrays.toString(dimensions)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Pre-allocating first %d dimensions", dimensionsToPreallocate));
        }
        this.data = new Object[dimensions[0]];
        this.preallocateArray(this.data, 0, dimensionsToPreallocate);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Done pre-allocating first %d dimensions", dimensionsToPreallocate));
        }
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    private void preallocateArray(Object[] subarray, int dimension, int dimensionsToPreallocate) {
        if (dimension >= dimensionsToPreallocate - 1) {
            return;
        }
        for (int i = 0; i < subarray.length; ++i) {
            subarray[i] = new Object[this.dimensions[dimension + 1]];
            this.preallocateArray((Object[])subarray[i], dimension + 1, dimensionsToPreallocate);
        }
    }

    public T get(int ... keys) {
        int numNestedDimensions = this.numDimensions - 1;
        Object[] myData = this.data;
        for (int i = 0; i < numNestedDimensions; ++i) {
            if (keys[i] >= this.dimensions[i]) {
                return null;
            }
            if ((myData = (Object[])myData[keys[i]]) != null) continue;
            return null;
        }
        return (T)myData[keys[numNestedDimensions]];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean put(T value, int ... keys) {
        if (keys.length != this.numDimensions) {
            throw new ReviewedStingException("Exactly " + this.numDimensions + " keys should be passed to this NestedIntegerArray but " + keys.length + " were provided");
        }
        int numNestedDimensions = this.numDimensions - 1;
        Object[] myData = this.data;
        for (int i = 0; i < numNestedDimensions; ++i) {
            if (keys[i] >= this.dimensions[i]) {
                throw new ReviewedStingException("Key " + keys[i] + " is too large for dimension " + i + " (max is " + (this.dimensions[i] - 1) + ")");
            }
            if (i >= 1) {
                Object[] objectArray = myData;
                // MONITORENTER : myData
                if (myData[keys[i]] == null) {
                    myData[keys[i]] = new Object[this.dimensions[i + 1]];
                }
                // MONITOREXIT : objectArray
            }
            myData = (Object[])myData[keys[i]];
        }
        Object[] objectArray = myData;
        // MONITORENTER : myData
        if (myData[keys[numNestedDimensions]] == null) {
            myData[keys[numNestedDimensions]] = value;
            return true;
        }
        // MONITOREXIT : objectArray
        return false;
    }

    public List<T> getAllValues() {
        ArrayList result = new ArrayList();
        this.fillAllValues(this.data, result);
        return result;
    }

    private void fillAllValues(Object[] array, List<T> result) {
        for (Object value : array) {
            if (value == null) continue;
            if (value instanceof Object[]) {
                this.fillAllValues((Object[])value, result);
                continue;
            }
            result.add(value);
        }
    }

    public List<Leaf<T>> getAllLeaves() {
        ArrayList<Leaf<T>> result = new ArrayList<Leaf<T>>();
        this.fillAllLeaves(this.data, new int[0], result);
        return result;
    }

    private void fillAllLeaves(Object[] array, int[] path, List<Leaf<T>> result) {
        for (int key = 0; key < array.length; ++key) {
            Object value = array[key];
            if (value == null) continue;
            int[] newPath = this.appendToPath(path, key);
            if (value instanceof Object[]) {
                this.fillAllLeaves((Object[])value, newPath, result);
                continue;
            }
            result.add(new Leaf<Object>(newPath, value));
        }
    }

    private int[] appendToPath(int[] path, int newKey) {
        int[] newPath = new int[path.length + 1];
        for (int i = 0; i < path.length; ++i) {
            newPath[i] = path[i];
        }
        newPath[path.length] = newKey;
        return newPath;
    }

    public static class Leaf<T> {
        public final int[] keys;
        public final T value;

        public Leaf(int[] keys, T value) {
            this.keys = keys;
            this.value = value;
        }
    }
}

