/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.beagle;

import java.util.ArrayList;
import java.util.Map;
import org.broad.tribble.Feature;
import org.broadinstitute.variant.variantcontext.Allele;

public class BeagleFeature
implements Feature {
    private String chr;
    private int start;
    private int end;
    Map<String, ArrayList<String>> sampleGenotypes;
    private Double r2Value;
    Map<String, ArrayList<String>> probLikelihoods;
    Allele AlleleA;
    Allele AlleleB;

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public Double getR2value() {
        return this.r2Value;
    }

    public Allele getAlleleA() {
        return this.AlleleA;
    }

    public Allele getAlleleB() {
        return this.AlleleB;
    }

    public Map<String, ArrayList<String>> getProbLikelihoods() {
        return this.probLikelihoods;
    }

    public Map<String, ArrayList<String>> getGenotypes() {
        return this.sampleGenotypes;
    }

    protected void setChr(String chr) {
        this.chr = chr;
    }

    protected void setStart(int start) {
        this.start = start;
    }

    protected void setEnd(int end) {
        this.end = end;
    }

    protected void setR2value(double r2) {
        this.r2Value = r2;
    }

    protected void setAlleleA(String a, boolean isRef) {
        this.AlleleA = Allele.create(a, isRef);
    }

    protected void setAlleleB(String a, boolean isRef) {
        this.AlleleB = Allele.create(a, isRef);
    }

    protected void setProbLikelihoods(Map<String, ArrayList<String>> p) {
        this.probLikelihoods = p;
    }

    protected void setGenotypes(Map<String, ArrayList<String>> p) {
        this.sampleGenotypes = p;
    }
}

