/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.baq;

import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class BAQReadTransformer
extends ReadTransformer {
    private BAQ baqHMM;
    private IndexedFastaSequenceFile refReader;
    private BAQ.CalculationMode cmode;
    private BAQ.QualityMode qmode;

    public ReadTransformer.ApplicationTime initializeSub(GenomeAnalysisEngine engine, Walker walker) {
        BAQMode mode = (BAQMode)WalkerManager.getWalkerAnnotation((Walker)walker, BAQMode.class);
        this.refReader = engine.getReferenceDataSource().getReference();
        this.cmode = engine.getArguments().BAQMode;
        this.qmode = mode.QualityMode();
        this.baqHMM = new BAQ(engine.getArguments().BAQGOP);
        if (this.qmode == BAQ.QualityMode.DONT_MODIFY) {
            throw new ReviewedStingException("BUG: shouldn't create BAQ transformer with quality mode DONT_MODIFY");
        }
        if (mode.ApplicationTime() == ReadTransformer.ApplicationTime.FORBIDDEN && this.enabled()) {
            throw new UserException.BadArgumentValue("baq", "Walker cannot accept BAQ'd base qualities, and yet BAQ mode " + (Object)((Object)this.cmode) + " was requested.");
        }
        return mode.ApplicationTime();
    }

    public boolean enabled() {
        return this.cmode != BAQ.CalculationMode.OFF;
    }

    public GATKSAMRecord apply(GATKSAMRecord read) {
        this.baqHMM.baqRead(read, this.refReader, this.cmode, this.qmode);
        return read;
    }
}

