/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

public final class IntervalBinding<T extends Feature> {
    private RodBinding<T> featureIntervals;
    private String stringIntervals;

    @Requires(value={"type != null", "rawName != null", "source != null", "tribbleType != null", "tags != null"})
    public IntervalBinding(Class<T> type, String rawName, String source, String tribbleType, Tags tags) {
        this.featureIntervals = new RodBinding<T>(type, rawName, source, tribbleType, tags);
    }

    @Requires(value={"intervalArgument != null"})
    public IntervalBinding(String intervalArgument) {
        this.stringIntervals = intervalArgument;
    }

    public String getSource() {
        if (this.featureIntervals != null) {
            return this.featureIntervals.getSource();
        }
        return this.stringIntervals;
    }

    public List<GenomeLoc> getIntervals(GenomeAnalysisEngine toolkit) {
        return this.getIntervals(toolkit.getGenomeLocParser());
    }

    public List<GenomeLoc> getIntervals(GenomeLocParser genomeLocParser) {
        ArrayList<GenomeLoc> intervals;
        if (this.featureIntervals != null) {
            intervals = new ArrayList();
            FeatureCodec codec = new FeatureManager().getByName(this.featureIntervals.getTribbleType()).getCodec();
            if (codec instanceof ReferenceDependentFeatureCodec) {
                ((ReferenceDependentFeatureCodec)codec).setGenomeLocParser(genomeLocParser);
            }
            try {
                AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(this.featureIntervals.getSource(), codec, false);
                for (Feature feature : reader.iterator()) {
                    intervals.add(genomeLocParser.createGenomeLoc(feature));
                }
            }
            catch (Exception e) {
                throw new UserException.MalformedFile(this.featureIntervals.getSource(), "Problem reading the interval file", e);
            }
        } else {
            intervals = IntervalUtils.parseIntervalArguments(genomeLocParser, this.stringIntervals);
        }
        Collections.sort(intervals);
        return intervals;
    }

    public String toString() {
        return this.getSource();
    }
}

