/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.index.linear.LinearIndexCreator;
import org.broad.tribble.readers.LocationAware;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broad.tribble.util.ParsingUtils;

public class IndexFactory {
    public static Index loadIndex(String indexFile) {
        Index idx = null;
        InputStream is = null;
        FilterInputStream dis = null;
        try {
            is = indexFile.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(ParsingUtils.openInputStream(indexFile)), 512000) : new BufferedInputStream(ParsingUtils.openInputStream(indexFile), 512000);
            dis = new LittleEndianInputStream(is);
            int magicNumber = ((LittleEndianInputStream)dis).readInt();
            int type = ((LittleEndianInputStream)dis).readInt();
            Class indexClass = IndexType.getIndexType(type).getIndexType();
            idx = (Index)indexClass.newInstance();
            idx.read((LittleEndianInputStream)dis);
        }
        catch (IOException ex) {
            throw new TribbleException.UnableToReadIndexFile("Unable to read index file", indexFile, ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {}
        }
        return idx;
    }

    public static Index createLinearIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.LINEAR);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createLinearIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int binSize) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.LINEAR, binSize);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIntervalIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.INTERVAL_TREE);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIntervalIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int binSize) {
        return IndexFactory.createIndex(inputFile, codec, IndexType.INTERVAL_TREE, binSize);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createDynamicIndex(inputFile, codec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type) {
        return IndexFactory.createIndex(inputFile, codec, type, type.getDefaultBinSize());
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type, int binSize) {
        if (!type.canCreate()) {
            throw new TribbleException("Tribble can only read, not create indices of type " + type.name());
        }
        IndexCreator idx = type.getIndexCreator();
        idx.initialize(inputFile, binSize);
        return IndexFactory.createIndex(inputFile, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputFile, codec), idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIndex(Index idx, File idxFile) throws IOException {
        FilterOutputStream stream = null;
        try {
            stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(idxFile)));
            idx.write((LittleEndianOutputStream)stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexBalanceApproach iba) {
        DynamicIndexCreator indexCreator = new DynamicIndexCreator(iba);
        indexCreator.initialize(inputFile, indexCreator.defaultBinSize());
        return IndexFactory.createIndex(inputFile, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputFile, codec), indexCreator);
    }

    private static Index createIndex(File inputFile, FeatureIterator iterator, IndexCreator creator) {
        Feature lastFeature = null;
        HashMap<String, Feature> visitedChromos = new HashMap<String, Feature>(40);
        while (iterator.hasNext()) {
            String lastChr;
            long position = iterator.getPosition();
            Feature currentFeature = iterator.next();
            IndexFactory.checkSorted(inputFile, lastFeature, currentFeature);
            String curChr = currentFeature.getChr();
            String string = lastChr = lastFeature != null ? lastFeature.getChr() : null;
            if (!curChr.equals(lastChr)) {
                if (visitedChromos.containsKey(curChr)) {
                    String msg = "Input file must have contiguous chromosomes.";
                    msg = msg + " Saw feature " + IndexFactory.featToString((Feature)visitedChromos.get(curChr));
                    msg = msg + " followed later by " + IndexFactory.featToString(lastFeature);
                    msg = msg + " and then " + IndexFactory.featToString(currentFeature);
                    throw new TribbleException.MalformedFeatureFile(msg, inputFile.getAbsolutePath());
                }
                visitedChromos.put(curChr, currentFeature);
            }
            creator.addFeature(currentFeature, position);
            lastFeature = currentFeature;
        }
        iterator.close();
        return creator.finalizeIndex(iterator.getPosition());
    }

    private static String featToString(Feature feature) {
        return feature.getChr() + ":" + feature.getStart() + "-" + feature.getEnd();
    }

    private static void checkSorted(File inputFile, Feature lastFeature, Feature currentFeature) {
        if (lastFeature != null && currentFeature.getStart() < lastFeature.getStart() && lastFeature.getChr().equals(currentFeature.getChr())) {
            throw new TribbleException.MalformedFeatureFile("Input file is not sorted by start position. \nWe saw a record with a start of " + currentFeature.getChr() + ":" + currentFeature.getStart() + " after a record with a start of " + lastFeature.getChr() + ":" + lastFeature.getStart(), inputFile.getAbsolutePath());
        }
    }

    static class FeatureIterator<FEATURE_TYPE extends Feature, SOURCE>
    implements CloseableTribbleIterator<Feature> {
        private SOURCE source;
        private Feature nextFeature;
        private final FeatureCodec<FEATURE_TYPE, SOURCE> codec;
        private final File inputFile;
        private long cachedPosition;

        public FeatureIterator(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE> codec) {
            this.codec = codec;
            this.inputFile = inputFile;
            FeatureCodecHeader header = this.readHeader();
            this.source = codec.makeIndexableSourceFromStream(this.initStream(inputFile, header.getHeaderEnd()));
            this.readNextFeature();
        }

        private FeatureCodecHeader readHeader() {
            try {
                SOURCE source = this.codec.makeSourceFromStream(this.initStream(this.inputFile, 0L));
                FeatureCodecHeader header = this.codec.readHeader(source);
                this.codec.close(source);
                return header;
            }
            catch (IOException e) {
                throw new TribbleException.InvalidHeader("Error reading header " + e.getMessage());
            }
        }

        private PositionalBufferedStream initStream(File inputFile, long skip) {
            try {
                FileInputStream is = new FileInputStream(inputFile);
                PositionalBufferedStream pbs = new PositionalBufferedStream(is);
                if (skip > 0L) {
                    pbs.skip(skip);
                }
                return pbs;
            }
            catch (FileNotFoundException e) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Error initializing stream", inputFile.getAbsolutePath(), e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public Feature next() {
            Feature ret = this.nextFeature;
            this.readNextFeature();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("We cannot remove");
        }

        public long getPosition() {
            return this.hasNext() ? this.cachedPosition : ((LocationAware)this.source).getPosition();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.codec.close(this.source);
        }

        private void readNextFeature() {
            this.cachedPosition = ((LocationAware)this.source).getPosition();
            try {
                this.nextFeature = null;
                while (this.nextFeature == null && !this.codec.isDone(this.source)) {
                    this.nextFeature = this.codec.decodeLoc(this.source);
                }
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputFile.getAbsolutePath(), e);
            }
        }
    }

    public static enum IndexType {
        LINEAR(1, LinearIndexCreator.class, LinearIndex.class, LinearIndexCreator.DEFAULT_BIN_WIDTH),
        INTERVAL_TREE(2, IntervalIndexCreator.class, IntervalTreeIndex.class, IntervalIndexCreator.DEFAULT_FEATURE_COUNT),
        TABIX(3, null, null, -1);

        private final int indexValue;
        private final Class<IndexCreator> indexCreatorClass;
        private final int defaultBinSize;
        private final Class<Index> indexType;

        public int getDefaultBinSize() {
            return this.defaultBinSize;
        }

        public IndexCreator getIndexCreator() {
            try {
                return this.indexCreatorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), e);
            }
            catch (IllegalAccessException e) {
                throw new TribbleException("Couldn't make index creator in " + (Object)((Object)this), e);
            }
        }

        public boolean canCreate() {
            return this.indexCreatorClass != null;
        }

        private IndexType(int headerValue, Class creator, Class indexClass, int defaultBinSize) {
            this.indexValue = headerValue;
            this.indexCreatorClass = creator;
            this.indexType = indexClass;
            this.defaultBinSize = defaultBinSize;
        }

        public int getHeaderValue() {
            return this.indexValue;
        }

        public Class getIndexType() {
            return this.indexType;
        }

        public static IndexType getIndexType(int headerValue) {
            for (IndexType type : IndexType.values()) {
                if (type.indexValue != headerValue) continue;
                return type;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type value" + headerValue);
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }
}

