/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.UIUtilities;

public class ClearGenomeCacheAction
extends MenuAction {
    static Logger logger = Logger.getLogger(ClearGenomeCacheAction.class);

    public ClearGenomeCacheAction(String label) {
        super(label, null);
        this.setToolTipText("Clears locally cached versions of IGV hosted genomes");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            int option = JOptionPane.showConfirmDialog(IGV.getMainFrame(), "Clear the genome cache ?", "Clear the genome cache ?", 0);
            if (option == 0) {
                GenomeManager.getInstance().clearGenomeCache();
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        IGV.getInstance().rebuildGenomeDropdownList();
                    }
                });
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(IGV.getMainFrame(), "Error encontered while removing genomes: " + e.getMessage());
            logger.error("Error removing genomes from the user-defined genome list.", e);
        }
    }
}

