/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import com.google.common.base.Predicate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.ui.TrackArgument;
import org.broad.igv.data.CombinedDataSource;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.collections.CollUtils;

public class CombinedDataSourceDialog
extends JDialog {
    private static Logger log = Logger.getLogger(CombinedDataSourceDialog.class);
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label2;
    private JComboBox trackABox;
    private JLabel label4;
    private JComboBox operation;
    private JLabel label3;
    private JComboBox trackBBox;
    private JLabel label1;
    private JScrollPane scrollPane1;
    private JTextArea resultName;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton helpButton;
    private JButton cancelButton;

    public CombinedDataSourceDialog(Frame owner) {
        super(owner);
        this.initComponents();
        ArrayList<CombinedDataSource.Operation> dialogOperations = new ArrayList<CombinedDataSource.Operation>(Arrays.asList(CombinedDataSource.Operation.values()));
        this.operation.setModel(new DefaultComboBoxModel<Object>(dialogOperations.toArray()));
        List<DataTrack> visibleTracks = CollUtils.filter(IGV.getInstance().getDataTracks(), new Predicate<DataTrack>(){

            @Override
            public boolean apply(DataTrack input) {
                return input.isVisible();
            }
        });
        this.trackABox.setModel(new DefaultComboBoxModel<Object>(visibleTracks.toArray()));
        this.trackBBox.setModel(new DefaultComboBoxModel<Object>(visibleTracks.toArray()));
        this.operation.setRenderer(new OperationComboBoxRenderer());
        this.trackABox.setRenderer(new TrackArgument.TrackComboBoxRenderer());
        this.trackBBox.setRenderer(new TrackArgument.TrackComboBoxRenderer());
        this.setOutputTrackName();
        this.operation.addItemListener(new SetOutputTrackNameListener());
    }

    public CombinedDataSourceDialog(Frame owner, Iterator<Track> tracks) {
        this(owner);
        this.trackABox.setSelectedItem(tracks.next());
        this.trackBBox.setSelectedItem(tracks.next());
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        DataTrack track0 = (DataTrack)this.trackABox.getSelectedItem();
        DataTrack track1 = (DataTrack)this.trackBBox.getSelectedItem();
        CombinedDataSource.Operation op = (CombinedDataSource.Operation)((Object)this.operation.getSelectedItem());
        String text = this.resultName.getText();
        CombinedDataSource source = new CombinedDataSource(track0, track1, op);
        DataSourceTrack newTrack = new DataSourceTrack(null, track0.getId() + track1.getId() + text, text, source);
        TrackMenuUtils.changeRenderer(Arrays.asList(newTrack), track0.getRenderer().getClass());
        newTrack.setDataRange(track0.getDataRange());
        newTrack.setColorScale(track0.getColorScale());
        IGV.getInstance().addTracks(Arrays.asList(newTrack), PanelName.DATA_PANEL);
        this.setVisible(false);
        IGV.getInstance().repaint();
    }

    private void helpButtonActionPerformed(ActionEvent e) {
        String defInfo = "Error retrieving help. See the IGV User Guide.";
        InputStream is = this.getClass().getResourceAsStream("/resources/bedtools_help.txt");
        String info = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                info = info + line + "\n";
            }
        }
        catch (IOException exc) {
            log.error(exc);
            info = defInfo;
        }
        JTextArea textArea = new JTextArea(info);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        JOptionPane pane = new JOptionPane(scrollPane, -1);
        JDialog dialog = pane.createDialog(null, "Help");
        dialog.setAlwaysOnTop(true);
        dialog.setResizable(true);
        dialog.setSize(400, 400);
        dialog.setVisible(true);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label2 = new JLabel();
        this.trackABox = new JComboBox();
        this.label4 = new JLabel();
        this.operation = new JComboBox();
        this.label3 = new JLabel();
        this.trackBBox = new JComboBox();
        this.label1 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.resultName = new JTextArea();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.helpButton = new JButton();
        this.cancelButton = new JButton();
        this.setAlwaysOnTop(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(null);
        this.label2.setText("Track A:");
        this.label2.setLabelFor(this.trackABox);
        this.contentPanel.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(5, 20), this.label2.getPreferredSize()));
        this.contentPanel.add(this.trackABox);
        this.trackABox.setBounds(70, 15, 205, this.trackABox.getPreferredSize().height);
        this.label4.setText("Operation:");
        this.contentPanel.add(this.label4);
        this.label4.setBounds(new Rectangle(new Point(5, 65), this.label4.getPreferredSize()));
        this.contentPanel.add(this.operation);
        this.operation.setBounds(70, 60, 150, this.operation.getPreferredSize().height);
        this.label3.setText("Track B:");
        this.label3.setLabelFor(this.trackBBox);
        this.contentPanel.add(this.label3);
        this.label3.setBounds(5, 110, 52, 16);
        this.contentPanel.add(this.trackBBox);
        this.trackBBox.setBounds(70, 105, 205, this.trackBBox.getPreferredSize().height);
        this.label1.setText("Result Track Name");
        this.contentPanel.add(this.label1);
        this.label1.setBounds(50, 150, 128, this.label1.getPreferredSize().height);
        this.resultName.setLineWrap(true);
        this.scrollPane1.setViewportView(this.resultName);
        this.contentPanel.add(this.scrollPane1);
        this.scrollPane1.setBounds(10, 170, 270, 65);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.contentPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 80, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("  OK  ");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CombinedDataSourceDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.helpButton.setText("Help");
        this.helpButton.setVisible(false);
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CombinedDataSourceDialog.this.helpButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.helpButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CombinedDataSourceDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void setOutputTrackName() {
        String name = "Sum";
        CombinedDataSource.Operation op = (CombinedDataSource.Operation)((Object)this.operation.getSelectedItem());
        switch (op) {
            case ADD: {
                break;
            }
            case SUBTRACT: {
                name = "Difference";
            }
        }
        this.resultName.setText(name);
    }

    private class SetOutputTrackNameListener
    implements ItemListener {
        private SetOutputTrackNameListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CombinedDataSourceDialog.this.setOutputTrackName();
        }
    }

    private class OperationComboBoxRenderer
    extends DefaultListCellRenderer {
        private OperationComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CombinedDataSource.Operation op = (CombinedDataSource.Operation)((Object)value);
            String toShow = StringUtils.capWords(op.name());
            return super.getListCellRendererComponent((JList<?>)list, toShow, index, isSelected, cellHasFocus);
        }
    }
}

