/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;

public class SequenceServletWrapper {
    public static boolean SEQUENCE_SERVER_AVAILALBLE = true;
    public static final int CONNECTION_TIMEOUT = 20000;
    private static Logger logger = Logger.getLogger(SequenceServletWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(String urlString, String chr, int start, int end) {
        byte[] bytes = new byte[end - start];
        if (!SEQUENCE_SERVER_AVAILALBLE) {
            return bytes;
        }
        InputStream cis = null;
        try {
            int numRead;
            URL url = new URL(urlString + "?chr=" + chr + "&start=" + start + "&end=" + end);
            cis = HttpUtils.getInstance().openConnectionStream(url);
            DataInputStream is = new DataInputStream(new BufferedInputStream(cis));
            for (int offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            is.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException ex) {
            if (SEQUENCE_SERVER_AVAILALBLE) {
                SEQUENCE_SERVER_AVAILALBLE = false;
                SequenceServletWrapper.showUnavailableMessage();
                logger.error("Error retrieving sequence from : " + urlString + ex.getMessage());
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void showUnavailableMessage() throws HeadlessException {
        MessageUtils.showMessage("<html>The IGV server at the Broad Institute is currently unavailable.  Features that require a reference sequence, <br>such as displaying alignment mismatches, will be disabled.  If this problem persists please <br>send email to igv-team@broadinstitute.org");
    }
}

