/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.EnumSet;
import java.util.zip.GZIPOutputStream;
import net.sf.picard.PicardException;
import net.sf.samtools.Defaults;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;

public final class VariantContextUtils {
    public static VariantContextWriter getConditionallyCompressingWriter(File output, SAMSequenceDictionary indexSequenceDictionary, EnumSet<Options> options) {
        return output.getName().endsWith(".gz") ? VariantContextUtils.getCompressingWriter(output, indexSequenceDictionary, options) : VariantContextWriterFactory.create(output, indexSequenceDictionary, options);
    }

    public static VariantContextWriter getCompressingWriter(File output, SAMSequenceDictionary indexSequenceDictionary, EnumSet<Options> options) {
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(new FileOutputStream(output)){
                {
                    this.def.setLevel(Defaults.COMPRESSION_LEVEL);
                }
            };
            BufferedOutputStream outputStream = new BufferedOutputStream(gzipOutputStream);
            return VariantContextWriterFactory.create(output, outputStream, indexSequenceDictionary, options);
        }
        catch (Exception e) {
            throw new PicardException("Could not create a compressed output stream for the VCF writer: " + e.getMessage(), e);
        }
    }

    public static SAMSequenceDictionary getSequenceDictionary(File dictionaryFile) {
        SAMFileReader samFileReader = new SAMFileReader(dictionaryFile);
        SAMSequenceDictionary dict = samFileReader.getFileHeader().getSequenceDictionary();
        samFileReader.close();
        return dict;
    }
}

