/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

class JavacUtils {
    JavacUtils() {
    }

    @Requires(value={"processingEnv != null", "element != null", "annotation != null"})
    @Ensures(value={"result != null"})
    public static List<Long> getLineNumbers(ProcessingEnvironment processingEnvironment, Element element, AnnotationMirror annotationMirror) {
        Trees trees = Trees.instance(processingEnvironment);
        if (trees == null) {
            return Collections.emptyList();
        }
        TreePath treePath = trees.getPath(element, annotationMirror);
        if (treePath == null) {
            return Collections.emptyList();
        }
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        LineMap lineMap = compilationUnitTree.getLineMap();
        SourcePositions sourcePositions = trees.getSourcePositions();
        AnnotationTree annotationTree = (AnnotationTree)treePath.getLeaf();
        AssignmentTree assignmentTree = (AssignmentTree)annotationTree.getArguments().get(0);
        ExpressionTree expressionTree = assignmentTree.getExpression();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (expressionTree.getKind() == Tree.Kind.STRING_LITERAL) {
            long l = sourcePositions.getStartPosition(compilationUnitTree, expressionTree);
            arrayList.add(lineMap.getLineNumber(l));
        } else {
            NewArrayTree newArrayTree = (NewArrayTree)expressionTree;
            for (ExpressionTree expressionTree2 : newArrayTree.getInitializers()) {
                long l = sourcePositions.getStartPosition(compilationUnitTree, expressionTree2);
                arrayList.add(lineMap.getLineNumber(l));
            }
        }
        return arrayList;
    }

    @Requires(value={"processingEnv != null", "element != null"})
    @Ensures(value={"result != null"})
    public static Set<String> getImportNames(ProcessingEnvironment processingEnvironment, Element element) {
        Trees trees = Trees.instance(processingEnvironment);
        if (trees == null) {
            return Collections.emptySet();
        }
        TreePath treePath = trees.getPath(element);
        if (treePath == null) {
            return Collections.emptySet();
        }
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        HashSet<String> hashSet = new HashSet<String>();
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (importTree.isStatic()) {
                stringBuilder.append("static ");
            }
            stringBuilder.append(importTree.getQualifiedIdentifier().toString());
            hashSet.add(stringBuilder.toString());
        }
        return hashSet;
    }
}

