/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoDBManager;
import org.broadinstitute.sting.utils.exceptions.StingException;

public class NA12878DBArgumentCollection {
    public static final String DEFAULT_SPEC_PATH = "resources/NA12878kb.json";
    public static final String LOCALHOST_SPEC_PATH = "resources/NA12878kb_local.json";
    @Argument(fullName="useLocal", shortName="useLocal", doc="If true, the localhost MongoDB will be used; for testing only", required=false)
    protected boolean useLocal = false;
    String dbSpecPath = null;
    @Argument(fullName="dbToUse", shortName="dbToUse", doc="Which database should we connect to?", required=false)
    public DBType dbToUse = DBType.DEFAULT;
    @Argument(shortName="reset", required=false)
    public boolean resetDB = false;

    public MongoDBManager.Locator getLocator() {
        InputStream is;
        if (this.dbSpecPath == null) {
            this.dbSpecPath = NA12878DBArgumentCollection.getDBSpecPath(this.useLocal);
        }
        if ((is = this.getClass().getResourceAsStream(this.dbSpecPath)) == null) {
            try {
                is = new FileInputStream(this.dbSpecPath);
            }
            catch (FileNotFoundException e) {
                throw new StingException("db spec path not found", e);
            }
        }
        InputStreamReader reader = new InputStreamReader(is);
        MongoDBManager.Locator tmpLocator = new Gson().fromJson((Reader)reader, MongoDBManager.Locator.class);
        String dbName = tmpLocator.name + this.dbToUse.getExtension();
        try {
            ((Reader)reader).close();
            return new MongoDBManager.Locator(tmpLocator.host, tmpLocator.port, dbName, tmpLocator.sitesCollection, tmpLocator.callsetsCollection, tmpLocator.consensusCollection);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close json reader for " + this.dbSpecPath, e);
        }
    }

    public NA12878DBArgumentCollection() {
        this(false);
    }

    private static String getDBSpecPath(boolean useLocal) {
        return useLocal ? LOCALHOST_SPEC_PATH : DEFAULT_SPEC_PATH;
    }

    public NA12878DBArgumentCollection(boolean useLocal) {
        this.useLocal = useLocal;
    }

    public NA12878DBArgumentCollection(String dbSpecPath) {
        this.dbSpecPath = dbSpecPath;
        this.dbToUse = DBType.PRODUCTION;
    }

    public static enum DBType {
        PRODUCTION("_production"),
        DEV("_development"),
        TEST("_test"),
        DEFAULT("_NA");

        private String extension;
        private static final Random rand;

        private DBType(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension.equals("_test") ? String.format("%s_%d_%d", this.extension, System.currentTimeMillis(), rand.nextInt()) : this.extension;
        }

        static {
            rand = new Random();
        }
    }
}

