/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.filefilters.AlignmentFileFilter;
import org.broad.igv.ui.filefilters.CoverageFileFilter;

public class FileDialogUtils {
    public static int LOAD = 0;
    public static int SAVE = 1;
    private static Logger log = Logger.getLogger(FileDialogUtils.class);

    public static File chooseFile(String title, File initialDirectory, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, null, mode);
    }

    public static File chooseFile(String title) {
        return FileDialogUtils.chooseFile(title, DirectoryManager.getUserDirectory(), null, 0);
    }

    public static File chooseFile(String title, File initialDirectory, File initialFile, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, initialFile, null, 0, mode);
    }

    public static File chooseFileOrDirectory(String title, File initialDirectory, File initialFile, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, initialFile, null, 2, mode);
    }

    private static File chooseFile(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoriesMode, int mode) {
        if (initialDirectory == null && initialFile != null) {
            initialDirectory = initialFile.getParentFile();
        }
        if (initialFile != null) {
            initialFile = new File(initialFile.getName());
        }
        if (Globals.IS_MAC && !Globals.IS_JWS && directoriesMode != 2) {
            return FileDialogUtils.chooseNative(title, initialDirectory, initialFile, filter, directoriesMode, mode);
        }
        return FileDialogUtils.chooseSwing(title, initialDirectory, initialFile, filter, directoriesMode, mode);
    }

    public static File chooseDirectory(String title, File initialDirectory) {
        if (Globals.IS_MAC && !Globals.IS_JWS) {
            return FileDialogUtils.chooseNative(title, initialDirectory, null, null, 1, LOAD);
        }
        return FileDialogUtils.chooseSwing(title, initialDirectory, null, null, 1, LOAD);
    }

    public static File[] chooseMultiple(String title, File initialDirectory, FilenameFilter filter) {
        File[] files = null;
        if (Globals.IS_MAC && !Globals.IS_JWS) {
            try {
                FileDialog fd = FileDialogUtils.getNativeChooser(title, initialDirectory, null, filter, 0, LOAD);
                if (FileDialogUtils.isMultipleMode(fd)) {
                    fd.setVisible(true);
                    Method method = fd.getClass().getMethod("getFiles", new Class[0]);
                    files = (File[])method.invoke((Object)fd, new Object[0]);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        if (files == null) {
            files = FileDialogUtils.chooseMultipleSwing(title, initialDirectory, filter);
        }
        return files;
    }

    private static File[] chooseMultipleSwing(String title, File initialDirectory, FilenameFilter filter) {
        boolean approve;
        JFileChooser fileChooser = FileDialogUtils.getJFileChooser(title, initialDirectory, null, filter, 0);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.addChoosableFileFilter(new AlignmentFileFilter());
        fileChooser.addChoosableFileFilter(new CoverageFileFilter());
        fileChooser.setFileFilter(fileChooser.getChoosableFileFilters()[0]);
        boolean bl = approve = fileChooser.showOpenDialog(FileDialogUtils.getParentFrame()) == 0;
        if (approve) {
            return fileChooser.getSelectedFiles();
        }
        return null;
    }

    private static FileDialog getNativeChooser(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        boolean directories = 1 == directoryMode;
        System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(directories));
        Frame parentFrame = FileDialogUtils.getParentFrame();
        FileDialog fd = new FileDialog(parentFrame, title);
        if (initialDirectory != null) {
            fd.setDirectory(initialDirectory.getAbsolutePath());
        }
        if (initialFile != null) {
            fd.setFile(initialFile.getName());
        }
        if (filter != null) {
            fd.setFilenameFilter(filter);
        }
        fd.setModal(true);
        fd.setMode(mode);
        if (mode == LOAD && !directories) {
            FileDialogUtils.setMultipleMode(fd, true);
        }
        return fd;
    }

    private static File chooseNative(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        FileDialog fd = FileDialogUtils.getNativeChooser(title, initialDirectory, initialFile, filter, directoryMode, mode);
        fd.setVisible(true);
        String file = fd.getFile();
        String directory = fd.getDirectory();
        if (file != null && directory != null) {
            if (Globals.IS_MAC && initialFile != null) {
                file = FileDialogUtils.fixMacExtension(initialFile, file);
            }
            return new File(directory, file);
        }
        return null;
    }

    private static boolean setMultipleMode(FileDialog fd, boolean b) {
        try {
            Method method = FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE);
            method.invoke((Object)fd, b);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isMultipleMode(FileDialog fd) {
        try {
            Method[] methods = FileDialog.class.getMethods();
            Method method = fd.getClass().getMethod("isMultipleMode", new Class[0]);
            return (Boolean)method.invoke((Object)fd, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static File chooseSwing(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        boolean approve;
        UIManager.put("FileChooser.readOnly", Boolean.FALSE);
        JFileChooser fileChooser = FileDialogUtils.getJFileChooser(title, initialDirectory, initialFile, filter, directoryMode);
        Frame parentFrame = FileDialogUtils.getParentFrame();
        if (mode == LOAD) {
            approve = fileChooser.showOpenDialog(parentFrame) == 0;
        } else {
            boolean bl = approve = fileChooser.showSaveDialog(parentFrame) == 0;
        }
        if (approve) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private static JFileChooser getJFileChooser(String title, File initialDirectory, File initialFile, final FilenameFilter filter, int directoryMode) {
        JFileChooser fileChooser = new JFileChooser();
        if (initialDirectory != null) {
            fileChooser.setCurrentDirectory(initialDirectory);
        }
        if (initialFile != null) {
            fileChooser.setSelectedFile(initialFile);
        }
        if (filter != null) {
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return filter.accept(file.getParentFile(), file.getName());
                }

                @Override
                public String getDescription() {
                    return "";
                }
            });
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(directoryMode);
        return fileChooser;
    }

    private static String fixMacExtension(File initialFile, String fname) {
        if (fname.contains(".")) {
            return fname;
        }
        String initialName = initialFile.getName();
        int idx = initialName.lastIndexOf(".");
        if (idx > 0) {
            String ext = initialName.substring(idx);
            return fname + ext;
        }
        return fname;
    }

    private static Frame getParentFrame() {
        return IGV.hasInstance() ? IGV.getMainFrame() : null;
    }
}

