/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.AbstractAlignment;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.FlowSignalContextBuilder;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.color.ColorUtilities;

public class SamAlignment
extends AbstractAlignment
implements Alignment {
    private static Logger log = Logger.getLogger(SamAlignment.class);
    public static final char DELETE_CHAR = '-';
    public static final char SKIP_CHAR = '=';
    public static final char MATCH = 'M';
    public static final char PERFECT_MATCH = '=';
    public static final char MISMATCH = 'X';
    public static final char INSERTION = 'I';
    public static final char DELETION = 'D';
    public static final char SKIPPED_REGION = 'N';
    public static final char SOFT_CLIP = 'S';
    public static final char HARD_CLIP = 'H';
    public static final char PADDING = 'P';
    public static final char ZERO_GAP = 'O';
    private static final String FLOW_SIGNAL_TAG = "ZF";
    private int start;
    private int end;
    private int alignmentStart;
    private int alignmentEnd;
    private SAMRecord record;
    private String mateSequence = null;
    private String pairOrientation = "";
    private Color defaultColor = AlignmentRenderer.grey1;
    private String readGroup;
    private String library;
    private String sample;
    private Strand firstOfPairStrand;
    private Strand secondOfPairStrand;
    protected static final char[] NT2COMP = new char[]{'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'T', 'N', 'G', 'N', 'N', 'N', 'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'A', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N'};
    public static final String REDUCE_READS_TAG = "RR";

    public SamAlignment(SAMRecord record) {
        String keySequence = null;
        this.record = record;
        String refName = record.getReferenceName();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.chr = genome == null ? refName : genome.getChromosomeAlias(refName);
        this.start = this.alignmentStart = record.getAlignmentStart() - 1;
        this.end = this.alignmentEnd = Math.max(this.alignmentStart, record.getAlignmentEnd());
        this.setMappingQuality(record.getMappingQuality());
        this.readName = record.getReadName().trim();
        this.setInferredInsertSize(record.getInferredInsertSize());
        this.setMatePair(genome);
        this.setPairOrientation();
        this.setPairStrands();
        SAMFileHeader header = record.getHeader();
        String flowOrder = null;
        if (header != null) {
            SAMReadGroupRecord rgRec;
            this.readGroup = (String)record.getAttribute("RG");
            if (this.readGroup != null && (rgRec = header.getReadGroup(this.readGroup)) != null) {
                this.sample = rgRec.getSample();
                this.library = rgRec.getLibrary();
                flowOrder = rgRec.getFlowOrder();
                keySequence = rgRec.getKeySequence();
            }
        }
        this.createAlignmentBlocks(record.getCigarString(), record.getReadBases(), record.getBaseQualities(), SamAlignment.decodeReduceCounts(record), this.getFlowSignals(flowOrder, keySequence), flowOrder, this.getFlowSignalsStart());
        Object colorTag = record.getAttribute("YC");
        if (colorTag != null) {
            try {
                this.defaultColor = ColorUtilities.stringToColor(colorTag.toString());
            }
            catch (Exception e) {
                log.error("Error interpreting color tag: " + colorTag, e);
                this.defaultColor = AlignmentRenderer.grey1;
            }
        }
    }

    private void setMatePair(Genome genome) {
        SAMRecord record = this.getRecord();
        if (record.getReadPairedFlag()) {
            String mateReferenceName = record.getMateReferenceName();
            String mateChr = genome == null ? mateReferenceName : genome.getChromosomeAlias(mateReferenceName);
            this.setMate(new ReadMate(mateChr, record.getMateAlignmentStart(), record.getMateNegativeStrandFlag(), record.getMateUnmappedFlag()));
        }
    }

    private void setPairOrientation() {
        SAMRecord record = this.getRecord();
        if (record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag() && record.getReferenceName().equals(record.getMateReferenceName())) {
            int s1 = record.getReadNegativeStrandFlag() ? 82 : 70;
            int s2 = record.getMateNegativeStrandFlag() ? 82 : 70;
            int o1 = 32;
            int o2 = 32;
            if (record.getFirstOfPairFlag()) {
                o1 = 49;
                o2 = 50;
            } else if (record.getSecondOfPairFlag()) {
                o1 = 50;
                o2 = 49;
            }
            char[] tmp = new char[4];
            int isize = record.getInferredInsertSize();
            int estReadLen = record.getAlignmentEnd() - record.getAlignmentStart() + 1;
            if (isize == 0) {
                int estMateEnd = record.getAlignmentStart() < record.getMateAlignmentStart() ? record.getMateAlignmentStart() + estReadLen : record.getMateAlignmentStart() - estReadLen;
                isize = estMateEnd - record.getAlignmentStart();
            }
            if (isize > 0) {
                tmp[0] = s1;
                tmp[1] = o1;
                tmp[2] = s2;
                tmp[3] = o2;
            } else {
                tmp[2] = s1;
                tmp[3] = o1;
                tmp[0] = s2;
                tmp[1] = o2;
            }
            this.pairOrientation = new String(tmp);
        }
    }

    private void setPairStrands() {
        if (this.isPaired()) {
            ReadMate mate;
            this.firstOfPairStrand = this.isFirstOfPair() ? this.getReadStrand() : ((mate = this.getMate()) != null && mate.isMapped() ? mate.getStrand() : Strand.NONE);
            this.secondOfPairStrand = this.isSecondOfPair() ? (this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : ((mate = this.getMate()).isMapped() && this.isProperPair() ? (mate.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE) : Strand.NONE);
        } else {
            this.firstOfPairStrand = this.getReadStrand();
            this.secondOfPairStrand = Strand.NONE;
        }
    }

    private void createAlignmentBlocks(String cigarString, byte[] readBases, byte[] readBaseQualities) {
        this.createAlignmentBlocks(cigarString, readBases, readBaseQualities, null, null, null, -1);
    }

    private void createAlignmentBlocks(String cigarString, byte[] readBases, byte[] readBaseQualities, short[] readRepresentativeCounts, short[] flowSignals, String flowOrder, int flowOrderStart) {
        boolean showSoftClipped = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_SOFT_CLIPPED");
        int nInsertions = 0;
        int nBlocks = 0;
        ArrayList<CigarOperator> operators = new ArrayList<CigarOperator>();
        StringBuffer buffer = new StringBuffer(4);
        if (cigarString.equals("*")) {
            this.alignmentBlocks = new AlignmentBlock[1];
            this.alignmentBlocks[0] = new AlignmentBlock(this.getChr(), this.getStart(), readBases, readBaseQualities);
            return;
        }
        boolean firstOperator = true;
        int softClippedBaseCount = 0;
        int nGaps = 0;
        char prevOp = '\u0000';
        for (int i = 0; i < cigarString.length(); ++i) {
            char next = cigarString.charAt(i);
            if (Character.isDigit(next)) {
                buffer.append(next);
                continue;
            }
            char op = next;
            if (op == 'H') {
                buffer = new StringBuffer(4);
                continue;
            }
            int nBases = Integer.parseInt(buffer.toString());
            if (this.operatorIsMatch(showSoftClipped, op)) {
                if (this.operatorIsMatch(showSoftClipped, prevOp)) {
                    ++nGaps;
                }
                ++nBlocks;
            } else if (op == 'D' || op == 'N') {
                ++nGaps;
            } else if (op == 'I') {
                ++nInsertions;
                ++nGaps;
            } else if (op == 'P') {
                ++nGaps;
            }
            if (firstOperator && op == 'S') {
                softClippedBaseCount += nBases;
            }
            operators.add(new CigarOperator(nBases, op));
            buffer = new StringBuffer(4);
            prevOp = op;
            firstOperator = false;
        }
        this.alignmentBlocks = new AlignmentBlock[nBlocks];
        this.insertions = new AlignmentBlock[nInsertions];
        if (nGaps > 0) {
            this.gapTypes = new char[nGaps];
        }
        if (showSoftClipped) {
            this.start -= softClippedBaseCount;
        }
        int fromIdx = showSoftClipped ? 0 : softClippedBaseCount;
        int blockStart = this.start;
        int blockIdx = 0;
        int insertionIdx = 0;
        int gapIdx = 0;
        FlowSignalContextBuilder fBlockBuilder = null;
        if (null != flowSignals && 0 < readBases.length) {
            fBlockBuilder = new FlowSignalContextBuilder(flowSignals, flowOrder, flowOrderStart, readBases, fromIdx, this.isNegativeStrand());
        }
        prevOp = '\u0000';
        for (CigarOperator op : operators) {
            try {
                AlignmentBlock block;
                if (op.operator == 'H') continue;
                if (this.operatorIsMatch(showSoftClipped, op.operator)) {
                    block = SamAlignment.buildAlignmentBlock(fBlockBuilder, readBases, readBaseQualities, readRepresentativeCounts, this.getChr(), blockStart, fromIdx, op.nBases, true);
                    if (op.operator == 'S') {
                        block.setSoftClipped(true);
                    }
                    this.alignmentBlocks[blockIdx++] = block;
                    fromIdx += op.nBases;
                    blockStart += op.nBases;
                    if (this.operatorIsMatch(showSoftClipped, prevOp)) {
                        this.gapTypes[gapIdx++] = 79;
                    }
                } else if (op.operator == 'D' || op.operator == 'N') {
                    blockStart += op.nBases;
                    this.gapTypes[gapIdx++] = op.operator;
                } else if (op.operator == 'I') {
                    this.gapTypes[gapIdx++] = 79;
                    block = SamAlignment.buildAlignmentBlock(fBlockBuilder, readBases, readBaseQualities, readRepresentativeCounts, this.getChr(), blockStart, fromIdx, op.nBases, false);
                    this.insertions[insertionIdx++] = block;
                    fromIdx += op.nBases;
                } else if (op.operator == 'P') {
                    this.gapTypes[gapIdx++] = 79;
                }
            }
            catch (Exception e) {
                log.error("Error processing CIGAR string", e);
            }
            prevOp = op.operator;
        }
        if (showSoftClipped && operators.size() > 0) {
            CigarOperator last = (CigarOperator)operators.get(operators.size() - 1);
            if (last.operator == 'S') {
                this.end += last.nBases;
            }
        }
    }

    private static AlignmentBlock buildAlignmentBlock(FlowSignalContextBuilder fBlockBuilder, byte[] readBases, byte[] readBaseQualities, short[] readRepresentativeCounts, String chr, int blockStart, int fromIdx, int nBases, boolean checkNBasesAvailable) {
        byte[] blockBases = new byte[nBases];
        byte[] blockQualities = new byte[nBases];
        short[] blockCounts = new short[nBases];
        int nBasesAvailable = nBases;
        if (checkNBasesAvailable) {
            nBasesAvailable = readBases.length - fromIdx;
        }
        if (readBases == null || readBases.length == 0) {
            Arrays.fill(blockBases, (byte)61);
        } else if (nBasesAvailable < nBases) {
            Arrays.fill(blockBases, (byte)63);
        } else {
            System.arraycopy(readBases, fromIdx, blockBases, 0, nBases);
        }
        nBasesAvailable = nBases;
        if (checkNBasesAvailable) {
            nBasesAvailable = readBaseQualities.length - fromIdx;
        }
        if (readBaseQualities == null || readBaseQualities.length == 0 || nBasesAvailable < nBases) {
            Arrays.fill(blockQualities, (byte)126);
        } else {
            System.arraycopy(readBaseQualities, fromIdx, blockQualities, 0, nBases);
        }
        if (readRepresentativeCounts != null) {
            System.arraycopy(readRepresentativeCounts, fromIdx, blockCounts, 0, nBases);
        }
        AlignmentBlock block = fBlockBuilder != null ? AlignmentBlock.getInstance(chr, blockStart, blockBases, blockQualities, fBlockBuilder.getFlowSignalContext(readBases, fromIdx, nBases)) : AlignmentBlock.getInstance(chr, blockStart, blockBases, blockQualities);
        if (readRepresentativeCounts != null) {
            block.setCounts(blockCounts);
        }
        return block;
    }

    private boolean operatorIsMatch(boolean showSoftClipped, char operator) {
        return operator == 'M' || operator == '=' || operator == 'X' || showSoftClipped && operator == 'S';
    }

    @Override
    public boolean isNegativeStrand() {
        return this.record.getReadNegativeStrandFlag();
    }

    @Override
    public boolean isDuplicate() {
        return this.record.getDuplicateReadFlag();
    }

    @Override
    public boolean isMapped() {
        return !this.record.getReadUnmappedFlag();
    }

    @Override
    public int getReadLength() {
        return this.record.getReadLength();
    }

    @Override
    public boolean isPaired() {
        return this.record.getReadPairedFlag();
    }

    @Override
    public boolean isProperPair() {
        return this.isPaired() && this.record.getProperPairFlag();
    }

    @Override
    public boolean isFirstOfPair() {
        return this.isPaired() && this.record.getFirstOfPairFlag();
    }

    @Override
    public boolean isSecondOfPair() {
        return this.isPaired() && this.record.getSecondOfPairFlag();
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    @Override
    public String getCigarString() {
        return this.record.getCigarString();
    }

    @Override
    public String getReadSequence() {
        return this.record.getReadString();
    }

    String buildReadSequenceFromBlocks() {
        String readSeq = "";
        for (AlignmentBlock block : this.getAlignmentBlocks()) {
            readSeq = readSeq + new String(block.getBases());
        }
        return readSeq;
    }

    @Override
    public boolean isPrimary() {
        return !this.record.getNotPrimaryAlignmentFlag();
    }

    @Override
    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public String getSample() {
        return this.sample;
    }

    @Override
    public String getReadGroup() {
        return this.readGroup;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    public SAMRecord getRecord() {
        return this.record;
    }

    public String toString() {
        return this.getRecord().getSAMString();
    }

    @Override
    public char[] getGapTypes() {
        return this.gapTypes;
    }

    @Override
    public Object getAttribute(String key) {
        return key.length() == 2 ? this.getRecord().getAttribute(key) : (key.equals("TEMPLATE_ORIENTATION") ? this.pairOrientation : null);
    }

    @Override
    public String getClipboardString(double location) {
        return this.getValueStringImpl(location, false);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        return this.getValueStringImpl(position, true);
    }

    String getValueStringImpl(double position, boolean truncate) {
        List<SAMRecord.SAMTagAndValue> attributes;
        StringBuffer buf = new StringBuffer(super.getValueString(position, null));
        SAMRecord record = this.getRecord();
        if (this.isPaired()) {
            boolean sectionBreak = false;
            if (record.getFirstOfPairFlag()) {
                buf.append("<br>First in pair");
                sectionBreak = true;
            }
            if (record.getSecondOfPairFlag()) {
                buf.append("<br>Second in pair");
                sectionBreak = true;
            }
            if (record.getNotPrimaryAlignmentFlag()) {
                buf.append("<br>Alignment NOT primary");
                sectionBreak = true;
            }
            if (record.getReadFailsVendorQualityCheckFlag()) {
                buf.append("<br>FAILED Vendor Quality Check");
                sectionBreak = true;
            }
            if (sectionBreak) {
                buf.append("<br>-------------------");
            }
        }
        if ((attributes = record.getAttributes()) != null && !attributes.isEmpty()) {
            for (SAMRecord.SAMTagAndValue tag : attributes) {
                buf.append("<br>" + tag.tag + " = ");
                if (tag.value.getClass().isArray()) {
                    buf.append("[not shown]<br>");
                    continue;
                }
                String tagValue = tag.value.toString();
                int maxLength = 70;
                if (tagValue.length() > 70 && truncate) {
                    String[] tokens;
                    for (String token : tokens = tagValue.split("<br>")) {
                        if (token.length() > 70) {
                            String remainder = token;
                            while (remainder.length() > 70) {
                                String tmp = remainder.substring(0, 70);
                                int spaceIndex = tmp.lastIndexOf(32);
                                int idx = spaceIndex > 30 ? spaceIndex : 70;
                                String substring = remainder.substring(0, idx);
                                buf.append(substring);
                                buf.append("<br>");
                                remainder = remainder.substring(idx);
                            }
                            buf.append(remainder);
                            buf.append("<br>");
                            continue;
                        }
                        buf.append(token);
                        buf.append("<br>");
                    }
                    continue;
                }
                buf.append(tagValue);
            }
            buf.append("<br>-------------------");
        }
        if (this.mateSequence != null) {
            buf.append("<br>Unmapped mate sequence: " + this.mateSequence);
            buf.append("<br>-------------------");
        }
        return buf.toString();
    }

    @Override
    public String getPairOrientation() {
        return this.pairOrientation;
    }

    @Override
    public void finish() {
        super.finish();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        for (AlignmentBlock block : this.alignmentBlocks) {
            block.reduce(genome);
        }
    }

    @Override
    public boolean isVendorFailedRead() {
        return this.getRecord().getReadFailsVendorQualityCheckFlag();
    }

    @Override
    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public String getMateSequence() {
        return this.mateSequence;
    }

    @Override
    public void setMateSequence(String sequence) {
        this.mateSequence = sequence;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.firstOfPairStrand;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return this.secondOfPairStrand;
    }

    public int getFlowSignalsStart() {
        Object attribute = this.getRecord().getAttribute(FLOW_SIGNAL_TAG);
        int toRet = -1;
        if (attribute != null && attribute instanceof Integer) {
            toRet = (Integer)attribute;
        }
        return toRet;
    }

    public short[] getFlowSignals(String flowOrder, String keySequence) {
        int i;
        short[] r = null;
        if (null == flowOrder || null == keySequence) {
            return null;
        }
        int startFlow = this.getFlowSignalsStart();
        if (startFlow < 0) {
            return null;
        }
        SAMRecord record = this.getRecord();
        char firstBase = this.isNegativeStrand() ? NT2COMP[record.getReadBases()[record.getReadLength() - 1]] : (char)record.getReadBases()[0];
        short keySignalOverlap = 0;
        for (i = keySequence.length() - 1; 0 <= i && keySequence.charAt(i) == firstBase; --i) {
            keySignalOverlap += 100;
        }
        Object attribute = record.getAttribute("FZ");
        if (null == attribute) {
            return null;
        }
        if (attribute instanceof short[]) {
            short[] signals = (short[])attribute;
            r = new short[signals.length - startFlow];
            for (i = startFlow; i < signals.length; ++i) {
                r[i - startFlow] = signals[i];
            }
        } else if (attribute instanceof int[]) {
            int[] signals = (int[])attribute;
            r = new short[signals.length - startFlow];
            System.arraycopy(signals, startFlow, r, 0, r.length);
        } else if (attribute instanceof byte[]) {
            byte[] signals = (byte[])attribute;
            r = new short[signals.length - startFlow];
            for (i = startFlow; i < signals.length; ++i) {
                r[i - startFlow] = signals[i];
            }
        } else {
            return null;
        }
        if (0 < keySignalOverlap && 0 < r.length) {
            r[0] = r[0] <= keySignalOverlap ? (short)0 : (short)(r[0] - keySignalOverlap);
        }
        return r;
    }

    static short[] decodeReduceCounts(SAMRecord record) {
        short startVal;
        int ii;
        short[] encodedCounts;
        Object reducedReadsVal = record.getAttribute(REDUCE_READS_TAG);
        if (reducedReadsVal == null) {
            return null;
        }
        if (reducedReadsVal instanceof short[]) {
            encodedCounts = (short[])reducedReadsVal;
        } else if (reducedReadsVal instanceof byte[]) {
            byte[] rrArr = (byte[])reducedReadsVal;
            int len = rrArr.length;
            encodedCounts = new short[len];
            for (ii = 0; ii < len; ++ii) {
                encodedCounts[ii] = rrArr[ii];
            }
        } else {
            log.info("Found reduced reads tag, but was unexpected type " + reducedReadsVal.getClass());
            return null;
        }
        short[] decodedCounts = new short[encodedCounts.length];
        decodedCounts[0] = startVal = encodedCounts[0];
        for (ii = 1; ii < decodedCounts.length; ++ii) {
            decodedCounts[ii] = (short)Math.min(startVal + encodedCounts[ii], Short.MAX_VALUE);
        }
        return decodedCounts;
    }

    static class CigarOperator {
        int nBases;
        char operator;

        public CigarOperator(int nBases, char operator) {
            this.nBases = nBases;
            this.operator = operator;
        }
    }
}

