/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.google.common.eventbus.EventBus;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentPacker;
import org.broad.igv.sam.AlignmentTileLoader;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.IAlignmentDataManager;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.event.DataLoadedEvent;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.ArrayHeapObjectSorter;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager
implements IAlignmentDataManager {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private Map<String, AlignmentInterval> loadedIntervalMap = new HashMap<String, AlignmentInterval>();
    private HashMap<String, String> chrMappings = new HashMap();
    private volatile boolean isLoading = false;
    private AlignmentTileLoader reader;
    private CoverageTrack coverageTrack;
    private static final int MAX_ROWS = 1000000;
    private Map<String, PEStats> peStats;
    private AlignmentTrack.ExperimentType experimentType;
    private SpliceJunctionHelper.LoadOptions loadOptions;
    private EventBus eventBus = new EventBus();
    static int n = 1;

    public AlignmentDataManager(ResourceLocator locator, Genome genome) throws IOException {
        this.reader = new AlignmentTileLoader(AlignmentReaderFactory.getReader(locator));
        this.peStats = new HashMap<String, PEStats>();
        this.initLoadOptions();
        this.initChrMap(genome);
    }

    public void updateGenome(Genome genome) {
        this.chrMappings.clear();
        this.initChrMap(genome);
    }

    void initLoadOptions() {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions();
    }

    private void initChrMap(Genome genome) {
        List<String> seqNames;
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    public void setExperimentType(AlignmentTrack.ExperimentType experimentType) {
        this.experimentType = experimentType;
    }

    public AlignmentTrack.ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public AlignmentTileLoader getReader() {
        return this.reader;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public boolean isPairedEnd() {
        return this.reader.isPairedEnd();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public List<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public boolean isIonTorrent() {
        Set<String> platforms = this.reader.getPlatforms();
        if (platforms != null) {
            return platforms.contains("IONTORRENT");
        }
        return false;
    }

    @Override
    public Collection<AlignmentInterval> getAllLoadedIntervals() {
        return this.loadedIntervalMap.values();
    }

    Collection<String> getLoadedIntervalNames() {
        return this.loadedIntervalMap.keySet();
    }

    @Override
    public AlignmentInterval getLoadedInterval(String frameName) {
        return this.loadedIntervalMap.get(frameName);
    }

    public void sortRows(AlignmentTrack.SortOption option, String frameName, double location, String tag) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(frameName);
        if (loadedInterval != null) {
            loadedInterval.sortRows(option, location, tag);
        }
    }

    public void setViewAsPairs(boolean option, AlignmentTrack.RenderOptions renderOptions) {
        if (option == renderOptions.isViewPairs()) {
            return;
        }
        boolean currentPairState = renderOptions.isViewPairs();
        renderOptions.setViewPairs(option);
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            this.repackAlignments(frame.getName(), currentPairState, renderOptions);
        }
    }

    private void repackAlignments(String frameName, boolean currentPairState, AlignmentTrack.RenderOptions renderOptions) {
        if (currentPairState) {
            AlignmentInterval loadedInterval = this.loadedIntervalMap.get(frameName);
            if (loadedInterval == null) {
                return;
            }
            LinkedHashMap<String, List<AlignmentInterval.Row>> groupedAlignments = loadedInterval.getGroupedAlignments();
            ArrayList<Alignment> alignments = new ArrayList<Alignment>(Math.min(50000, groupedAlignments.size() * 10000));
            for (List alignmentRows : groupedAlignments.values()) {
                for (AlignmentInterval.Row row : alignmentRows) {
                    for (Alignment al : row.alignments) {
                        if (al instanceof PairedAlignment) {
                            PairedAlignment pair = (PairedAlignment)al;
                            alignments.add(pair.firstAlignment);
                            if (pair.secondAlignment == null) continue;
                            alignments.add(pair.secondAlignment);
                            continue;
                        }
                        alignments.add(al);
                    }
                }
            }
            ArrayHeapObjectSorter<Alignment> heapSorter = new ArrayHeapObjectSorter<Alignment>();
            heapSorter.sort(alignments, new Comparator<Alignment>(){

                @Override
                public int compare(Alignment alignment, Alignment alignment1) {
                    return alignment.getStart() - alignment1.getStart();
                }
            });
            int max = Integer.MAX_VALUE;
            LinkedHashMap<String, List<AlignmentInterval.Row>> tmp = new AlignmentPacker().packAlignments(alignments.iterator(), loadedInterval.getEnd(), renderOptions);
            loadedInterval.setAlignmentRows(tmp, renderOptions);
        } else {
            this.repackAlignments(frameName, renderOptions);
        }
    }

    public void repackAlignments(String frameName, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(frameName);
        if (loadedInterval == null) {
            return;
        }
        Iterator<Alignment> iter = loadedInterval.getAlignmentIterator();
        int max = Integer.MAX_VALUE;
        LinkedHashMap<String, List<AlignmentInterval.Row>> alignmentRows = new AlignmentPacker().packAlignments(iter, loadedInterval.getEnd(), renderOptions);
        loadedInterval.setAlignmentRows(alignmentRows, renderOptions);
    }

    public void preload(RenderContext context) {
        AlignmentTrack.RenderOptions renderOptions = this.getCoverageTrack() != null ? this.getCoverageTrack().getRenderOptions() : null;
        this.preload(context, renderOptions, true);
    }

    public synchronized void preload(RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean expandEnds) {
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation();
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(context.getReferenceFrame().getName());
        int adjustedStart = start;
        int adjustedEnd = end;
        int windowSize = PreferenceManager.getInstance().getAsInt("SAM.MAX_VISIBLE_RANGE") * 1000;
        int center = (end + start) / 2;
        int expand = Math.max(end - start, windowSize / 2);
        if (loadedInterval != null && loadedInterval.contains(chr, start, end)) {
            return;
        }
        if (expandEnds) {
            adjustedStart = Math.max(0, Math.min(start, center - expand));
            adjustedEnd = Math.max(end, center + expand);
        }
        this.loadAlignments(chr, adjustedStart, adjustedEnd, renderOptions, context);
    }

    public synchronized LinkedHashMap<String, List<AlignmentInterval.Row>> getGroups(RenderContext context, AlignmentTrack.RenderOptions renderOptions) {
        this.preload(context, renderOptions, false);
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(context.getReferenceFrame().getName());
        if (loadedInterval != null) {
            return loadedInterval.getGroupedAlignments();
        }
        return null;
    }

    public void clear() {
        this.loadedIntervalMap.clear();
    }

    public synchronized void loadAlignments(final String chr, final int start, final int end, final AlignmentTrack.RenderOptions renderOptions, final RenderContext context) {
        if (this.isLoading || chr.equals("All")) {
            return;
        }
        this.isLoading = true;
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public String getName() {
                return "loadAlignments";
            }

            @Override
            public void run() {
                log.debug("Loading alignments: " + chr + ":" + start + "-" + end + " for " + AlignmentDataManager.this);
                AlignmentInterval loadedInterval = AlignmentDataManager.this.loadInterval(chr, start, end, renderOptions);
                ReferenceFrame frame = context != null ? context.getReferenceFrame() : null;
                AlignmentDataManager.this.addLoadedInterval(frame, loadedInterval);
                AlignmentDataManager.this.getEventBus().post(new DataLoadedEvent(context));
                AlignmentDataManager.this.isLoading = false;
            }
        };
        LongRunningTask.submit(runnable);
    }

    AlignmentInterval loadInterval(String chr, int start, int end, AlignmentTrack.RenderOptions renderOptions) {
        String sequence = this.chrMappings.containsKey(chr) ? this.chrMappings.get(chr) : chr;
        DownsampleOptions downsampleOptions = new DownsampleOptions();
        AlignmentTrack.BisulfiteContext bisulfiteContext = renderOptions != null ? renderOptions.bisulfiteContext : null;
        ProgressMonitor monitor = null;
        if (IGV.hasInstance() && !Globals.isBatch() && !Globals.isHeadless()) {
            ActionListener cancelListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlignmentTileLoader.cancelReaders();
                }
            };
            IGV.getInstance().getContentPane().getStatusBar().activateCancelButton(cancelListener);
        }
        SpliceJunctionHelper spliceJunctionHelper = new SpliceJunctionHelper(this.loadOptions);
        AlignmentTileLoader.AlignmentTile t = this.reader.loadTile(sequence, start, end, spliceJunctionHelper, downsampleOptions, this.peStats, bisulfiteContext, monitor);
        List<Alignment> alignments = t.getAlignments();
        List<DownsampledInterval> downsampledIntervals = t.getDownsampledIntervals();
        Comparator<Alignment> alignmentSorter = new Comparator<Alignment>(){

            @Override
            public int compare(Alignment alignment, Alignment alignment1) {
                return alignment.getStart() - alignment1.getStart();
            }
        };
        Collections.sort(alignments, alignmentSorter);
        Iterator<Alignment> iter = alignments.iterator();
        AlignmentPacker alignmentPacker = new AlignmentPacker();
        LinkedHashMap<String, List<AlignmentInterval.Row>> alignmentRows = alignmentPacker.packAlignments(iter, end, renderOptions);
        return new AlignmentInterval(chr, start, end, alignmentRows, t.getCounts(), spliceJunctionHelper, downsampledIntervals, renderOptions);
    }

    private void addLoadedInterval(ReferenceFrame frame, AlignmentInterval interval) {
        String frameName = frame != null ? frame.getName() : "genome";
        this.loadedIntervalMap.put(frameName, interval);
    }

    public Map<String, List<AlignmentInterval.Row>> getGroupedAlignmentsContaining(double position, ReferenceFrame referenceFrame) {
        String chr = referenceFrame.getChrName();
        int start = (int)position;
        int end = start + 1;
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        if (loadedInterval == null) {
            return null;
        }
        if (loadedInterval.getGroupedAlignments() != null && loadedInterval.contains(chr, start, end)) {
            return loadedInterval.getGroupedAlignments();
        }
        return null;
    }

    public int getNLevels() {
        int nLevels = 0;
        for (AlignmentInterval loadedInterval : this.loadedIntervalMap.values()) {
            int intervalNLevels = 0;
            Collection<List<AlignmentInterval.Row>> tmp = loadedInterval.getGroupedAlignments().values();
            for (List<AlignmentInterval.Row> rows : tmp) {
                intervalNLevels += rows.size();
            }
            nLevels = Math.max(nLevels, intervalNLevels);
        }
        return nLevels;
    }

    public int getMaxGroupCount() {
        int groupCount = 0;
        for (AlignmentInterval loadedInterval : this.loadedIntervalMap.values()) {
            groupCount = Math.max(groupCount, loadedInterval.getGroupCount());
        }
        return groupCount;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.compute(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public SpliceJunctionHelper.LoadOptions getSpliceJunctionLoadOptions() {
        return this.loadOptions;
    }

    @Override
    public void setMinJunctionCoverage(int minJunctionCoverage) {
        this.loadOptions = new SpliceJunctionHelper.LoadOptions(minJunctionCoverage, this.loadOptions.minReadFlankingWidth);
        for (AlignmentInterval interval : this.getAllLoadedIntervals()) {
            interval.getSpliceJunctionHelper().setLoadOptions(this.loadOptions);
        }
    }

    public static class DownsampleOptions {
        private boolean downsample;
        private int sampleWindowSize;
        private int maxReadCount;

        public DownsampleOptions() {
            PreferenceManager prefs = PreferenceManager.getInstance();
            this.downsample = prefs.getAsBoolean("SAM.DOWNSAMPLE_READS");
            this.sampleWindowSize = prefs.getAsInt("SAM.SAMPLING_WINDOW");
            this.maxReadCount = prefs.getAsInt("SAM.MAX_LEVELS");
        }

        public boolean isDownsample() {
            return this.downsample;
        }

        public int getSampleWindowSize() {
            return this.sampleWindowSize;
        }

        public int getMaxReadCount() {
            return this.maxReadCount;
        }
    }
}

