/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongovariant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.plugin.mongovariant.MongoVCFVariant;
import org.broad.igv.plugin.mongovariant.VariantReviewRenderer;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.Track;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFVariant;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoGenotype;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.NA12878DBArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.NA12878KnowledgeBase;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.SiteIterator;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.SiteManager;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.TruthStatus;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class VariantReviewSource
implements FeatureSource<VCFVariant> {
    private int featureWindowSize = 1000000;
    private NA12878DBArgumentCollection args;
    private NA12878KnowledgeBase kb;
    private GenomeLocParser parser;
    boolean consensusOnly = true;

    public VariantReviewSource(ResourceLocator locator) {
        this.args = new NA12878DBArgumentCollection(locator.getPath());
        this.parser = this.createGenomeLocParser();
    }

    private void initKB() {
        this.kb = new NA12878KnowledgeBase(this.parser, this.args);
    }

    private void closeKB() {
        if (this.kb != null) {
            this.kb.close();
            this.kb = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeKB();
    }

    @Override
    public Iterator<VCFVariant> getFeatures(String chr, int start, int end) throws IOException {
        if (this.kb == null) {
            this.initKB();
        }
        GenomeLoc loc = this.parser.createGenomeLoc(VariantReviewSource.chromoNameToStandard(chr), start + 1, end);
        GenomeLocSortedSet glss = new GenomeLocSortedSet(this.parser, loc);
        SiteManager manager = new SiteManager(this.parser, glss, this.parser.getContigs());
        SiteIterator<MongoVariantContext> iterator = this.consensusOnly ? this.kb.getConsensusSites(manager) : this.kb.getCalls(manager);
        ArrayList<MongoVCFVariant> variants = new ArrayList<MongoVCFVariant>();
        while (iterator.hasNext()) {
            MongoVariantContext mvc = (MongoVariantContext)iterator.next();
            MongoVCFVariant vcf = new MongoVCFVariant(mvc, mvc.getChr());
            variants.add(vcf);
        }
        return variants.iterator();
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
    }

    static String chromoNameToStandard(String chromoName) {
        if (chromoName.toLowerCase().startsWith("chr")) {
            return chromoName.substring(3);
        }
        return chromoName;
    }

    private GenomeLocParser createGenomeLocParser() {
        SAMSequenceDictionary dict = new SAMSequenceDictionary();
        for (Chromosome chr : GenomeManager.getInstance().getCurrentGenome().getChromosomes()) {
            dict.addSequence(new SAMSequenceRecord(VariantReviewSource.chromoNameToStandard(chr.getName()), chr.getLength()));
        }
        return new GenomeLocParser(dict);
    }

    static MongoVariantContext createMVC(int allele0, int allele1, String callsetName, VariantContext variantContext, TruthStatus truthStatus, boolean isComplexEvent) {
        List<Allele> alleleList = variantContext.getAlleles();
        MongoGenotype mgt = new MongoGenotype(allele0, allele1);
        Genotype gt = mgt.toGenotype(alleleList);
        MongoVariantContext mvc = MongoVariantContext.create(callsetName, variantContext, truthStatus, gt);
        mvc.setReviewed(true);
        mvc.setChr(VariantReviewSource.chromoNameToStandard(mvc.getChr()));
        mvc.setIsComplexEvent(isComplexEvent);
        mvc.setConfidence(NA12878KnowledgeBase.InputCallsetConfidence.REVIEW.confidence);
        return mvc;
    }

    public static VariantTrack loadVariantReview(ResourceLocator locator, List<Track> newTracks) {
        List<String> allSamples = Collections.emptyList();
        VariantReviewSource source = new VariantReviewSource(locator);
        VariantTrack track = new VariantTrack(locator, source, allSamples, false);
        track.setRenderer(new VariantReviewRenderer(track));
        newTracks.add(track);
        track.setMargin(0);
        return track;
    }
}

