/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongovariant;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.dev.api.IGVPlugin;
import org.broad.igv.plugin.mongovariant.VariantReviewDialog;
import org.broad.igv.plugin.mongovariant.VariantReviewSource;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuItemBuilder;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFVariant;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.NA12878DBArgumentCollection;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class VariantReviewPlugin
implements IGVPlugin {
    private static Logger log = Logger.getLogger(VariantTrack.class);
    private static final String SHOW_REVIEW_KEY = "SHOW_VARIANT_REVIEW";
    private static boolean hasReviewTrack = false;
    private static boolean showReviewOption = Boolean.parseBoolean(IGV.getInstance().getSession().getPersistent("SHOW_VARIANT_REVIEW", "false"));
    private static final String DB_PATH_KEY = "VARIANT_DB_PATH";
    public static final String DB_PATH_DEFAULT = "resources/NA12878kb.json";
    private static final String PREFERENTIAL_SAMPLE_KEY = "PREFERENTIAL_SAMPLE";
    public static final String DEFAULT_PREFERENTIAL_SAMPLE = "NA12878";
    private static String preferentialSampleName;
    private static String dbSpecPath;

    @Override
    public void init() {
        if (showReviewOption) {
            if (!Globals.isVersionOrHigher("1.7")) {
                log.error("VariantReviewPlugin requires Java 7 or higher. This plugin will be disabled");
                return;
            }
            NA12878DBArgumentCollection col = new NA12878DBArgumentCollection();
            this.initMenuItems();
        }
    }

    private boolean isSingleVariantTrack(Collection<Track> tracks) {
        if (tracks.size() != 1) {
            return false;
        }
        Track track = tracks.iterator().next();
        return track instanceof VariantTrack;
    }

    private void initMenuItems() {
        TrackMenuUtils.addTrackMenuItemBuilder(new TrackMenuItemBuilder(){

            @Override
            public JMenuItem build(Collection<Track> selectedTracks, TrackClickEvent te) {
                if (!VariantReviewPlugin.this.isSingleVariantTrack(selectedTracks)) {
                    return null;
                }
                JMenuItem showReviewMenuItem = new JMenuItem("Load Review Track");
                showReviewMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ArrayList<Track> newTracks = new ArrayList<Track>(1);
                        ResourceLocator locator = new ResourceLocator(VariantReviewPlugin.getDbSpecPath());
                        locator.setName("NA12878 KB");
                        VariantReviewSource.loadVariantReview(locator, newTracks);
                        IGV.getInstance().addTracks(newTracks, PanelName.DATA_PANEL);
                        hasReviewTrack = true;
                    }
                });
                showReviewMenuItem.setEnabled(!hasReviewTrack);
                return showReviewMenuItem;
            }
        });
        TrackMenuUtils.addTrackMenuItemBuilder(new TrackMenuItemBuilder(){

            @Override
            public JMenuItem build(Collection<Track> selectedTracks, TrackClickEvent te) {
                if (!VariantReviewPlugin.this.isSingleVariantTrack(selectedTracks)) {
                    return null;
                }
                Track track = selectedTracks.iterator().next();
                VariantTrack vTrack = (VariantTrack)track;
                final Variant variant = vTrack.getSelectedVariant(te);
                JMenuItem addReviewMenuItem = new JMenuItem("Submit Review to DB");
                addReviewMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VariantContext vc = VCFVariant.getVariantContext(variant);
                        new VariantReviewDialog(IGV.getMainFrame(), vc).setVisible(true);
                    }
                });
                addReviewMenuItem.setEnabled(variant != null);
                return addReviewMenuItem;
            }
        });
    }

    public static String getPreferentialSampleName() {
        if (preferentialSampleName == null) {
            preferentialSampleName = IGV.getPersistent(PREFERENTIAL_SAMPLE_KEY, DEFAULT_PREFERENTIAL_SAMPLE);
        }
        return preferentialSampleName;
    }

    public static String getDbSpecPath() {
        if (dbSpecPath == null) {
            dbSpecPath = IGV.getPersistent(DB_PATH_KEY, DB_PATH_DEFAULT);
        }
        return dbSpecPath;
    }
}

