/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gitools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.dev.api.IGVPlugin;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListManagerUI;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.collections.DoubleArrayList;

public class Gitools
implements IGVPlugin {
    private static Logger log = Logger.getLogger(Gitools.class);
    public static final String ENABLE_PROPERTY = "enableGitools";
    private static int port = 50151;
    private static String host = "localhost";

    @Override
    public void init() {
        Gitools.addMenuItems();
    }

    private static void addMenuItems() {
        boolean showTDMButton = Boolean.parseBoolean(System.getProperty(ENABLE_PROPERTY, "true"));
        if (showTDMButton) {
            JMenu gitoolsMenu = new JMenu("Gitools Heatmaps");
            JMenuItem directLoadItem = new JMenuItem("Load Gene Matrix in Gitools");
            directLoadItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Gitools.canConnect()) {
                        GeneListManagerUI dialog = GeneListManagerUI.getInstance(IGV.getMainFrame(), "Gitools Load", new DirectLoadListener());
                        dialog.setVisible(true);
                    } else {
                        JOptionPane.showMessageDialog(IGV.getMainFrame(), "To be able to browse the gene matrix you need to install and open Gitools.\n Download it from http://www.gitools.org.");
                    }
                }
            });
            gitoolsMenu.add(directLoadItem);
            JMenuItem gitoolsItem = new JMenuItem("Export Gene Matrix (TDM)...");
            gitoolsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneListManagerUI dialog = GeneListManagerUI.getInstance(IGV.getMainFrame(), "Export TDM", new ExportFileListener());
                    dialog.setVisible(true);
                }
            });
            gitoolsMenu.add(gitoolsItem);
            IGV.getInstance().addOtherToolMenu(gitoolsMenu);
        }
    }

    public static void main(String[] args) {
        try {
            Gitools.sendCommand("version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> sendCommand(String command) throws IOException {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            socket.setSoTimeout(1000);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println(command);
            ArrayList<String> response = new ArrayList<String>();
            String line = in.readLine();
            if (line != null) {
                response.add(line);
            }
            ArrayList<String> arrayList = response;
            return arrayList;
        }
        catch (IOException e) {
            System.out.println(e);
            throw new IOException("Error communicating with gitools", e);
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static boolean canConnect() {
        boolean canConnect = false;
        try {
            List<String> version = Gitools.sendCommand("version");
            canConnect = version.get(0).toLowerCase().contains("gitools");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canConnect;
    }

    public static List<String> gitoolsLoad(String name, List<String> lociStrings) throws IOException {
        String prefix = name + "-igv";
        prefix = prefix.replace(" ", "_");
        File tmpFile = File.createTempFile(prefix, ".tdm");
        Gitools.exportTDM(lociStrings, tmpFile);
        return Gitools.sendCommand(String.format("load %s", tmpFile.getAbsolutePath()));
    }

    public static void exportTDM(List<String> lociStrings, File file) throws IOException {
        int averageFeatureSize = 0;
        ArrayList<NamedFeature> loci = new ArrayList<NamedFeature>(lociStrings.size());
        for (String l : lociStrings) {
            NamedFeature feature = FeatureDB.getFeature(l);
            if (feature == null) {
                feature = Locus.fromString(l);
            }
            if (feature == null) continue;
            loci.add(feature);
            averageFeatureSize += feature.getEnd() - feature.getStart();
        }
        if (loci.size() > 0) {
            averageFeatureSize /= loci.size();
        }
        LinkedHashSet<TrackType> loadedTypes = new LinkedHashSet<TrackType>();
        List<Track> tracks = IGV.getInstance().getAllTracks();
        for (Track t : tracks) {
            if (!(t instanceof DataTrack) && t.getTrackType() != TrackType.MUTATION || !t.isVisible()) continue;
            loadedTypes.add(t.getTrackType());
        }
        int zoom = 0;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome != null) {
            double averageChrLength = genome.getTotalLength() / (long)genome.getChromosomes().size();
            zoom = (int)(Math.log(averageChrLength / (double)averageFeatureSize) / Globals.log2) + 1;
        }
        LinkedHashMap<String, SampleData> sampleDataMap = new LinkedHashMap<String, SampleData>();
        for (Track t : tracks) {
            if (!t.isVisible()) continue;
            String sampleName = t.getSample();
            List<Track> overlays = IGV.getInstance().getOverlayTracks(t);
            for (NamedFeature locus : loci) {
                double regionScore;
                if (t instanceof DataTrack) {
                    DataTrack dataTrack = (DataTrack)t;
                    regionScore = dataTrack.getAverageScore(locus.getChr(), locus.getStart(), locus.getEnd(), zoom);
                    Gitools.addToSampleData(sampleDataMap, sampleName, locus.getName(), t.getTrackType(), regionScore);
                }
                if (overlays == null) continue;
                for (Track overlay : overlays) {
                    if (overlay.getTrackType() != TrackType.MUTATION || !((regionScore = (double)overlay.getRegionScore(locus.getChr(), locus.getStart(), locus.getEnd(), zoom, RegionScoreType.MUTATION_COUNT, locus.getName())) > 0.0)) continue;
                    Gitools.addToSampleData(sampleDataMap, sampleName, locus.getName(), overlay.getTrackType(), regionScore);
                }
            }
        }
        Gitools.writeTDM(loadedTypes, sampleDataMap, file);
    }

    private static void writeTDM(LinkedHashSet<TrackType> loadedTypes, Map<String, SampleData> sampleDataMap, File file) throws IOException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.print("Sample\tLocus");
            for (TrackType tt : loadedTypes) {
                pw.print("\t" + tt.name());
            }
            pw.println();
            for (SampleData sd : sampleDataMap.values()) {
                pw.print(sd.sample + "\t" + sd.locus);
                for (TrackType tt : loadedTypes) {
                    pw.print('\t');
                    double[] values = sd.getValues(tt);
                    if (values == null) {
                        pw.print("-");
                        continue;
                    }
                    double avg = StatUtils.max(values);
                    pw.print(avg);
                }
                pw.println();
            }
        }
        catch (IOException e) {
            throw new IOException("Error exporting TDM", e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static void addToSampleData(Map<String, SampleData> sampleDataMap, String sampleName, String locusString, TrackType tt, double regionScore) {
        if (!Double.isNaN(regionScore)) {
            String key = sampleName + "_" + locusString;
            SampleData sd = sampleDataMap.get(key);
            if (sd == null) {
                sd = new SampleData(sampleName, locusString);
                sampleDataMap.put(key, sd);
            }
            sd.addValue(tt, regionScore);
        }
    }

    public static class DirectLoadListener
    implements GeneListManagerUI.GeneListListener {
        @Override
        public void actionPerformed(JDialog dialog, GeneList geneList) {
            boolean canConnect = Gitools.canConnect();
            if (!canConnect) {
                MessageUtils.showMessage("Cannot communicate with gitools, check that it is running on port " + port);
                return;
            }
            try {
                Gitools.gitoolsLoad(geneList.getName(), geneList.getLoci());
            }
            catch (IOException exc) {
                MessageUtils.showErrorMessage(exc.getMessage(), exc);
            }
        }
    }

    public static class ExportFileListener
    implements GeneListManagerUI.GeneListListener {
        @Override
        public void actionPerformed(JDialog dialog, GeneList geneList) {
            File file = FileDialogUtils.chooseFile("Export TDM file", null, FileDialogUtils.SAVE);
            String currentExtension = FilenameUtils.getExtension(file.getName());
            if (!currentExtension.equalsIgnoreCase("TDM")) {
                file = new File(file.getAbsolutePath() + ".tdm");
            }
            if (file != null) {
                try {
                    Gitools.exportTDM(geneList.getLoci(), file);
                }
                catch (IOException exc) {
                    MessageUtils.showErrorMessage("Error exporting TDM", exc);
                }
            }
        }
    }

    static class SampleData {
        String sample;
        String locus;
        Map<TrackType, DoubleArrayList> valueMap;

        SampleData(String sample, String locus) {
            this.sample = sample;
            this.locus = locus;
            this.valueMap = new HashMap<TrackType, DoubleArrayList>();
        }

        void addValue(TrackType tt, double value) {
            DoubleArrayList vlist = this.valueMap.get((Object)tt);
            if (vlist == null) {
                vlist = new DoubleArrayList();
                this.valueMap.put(tt, vlist);
            }
            vlist.add(value);
        }

        public double[] getValues(TrackType tt) {
            DoubleArrayList dal = this.valueMap.get((Object)tt);
            return dal == null ? null : dal.toArray();
        }
    }
}

