/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.PluginFeatureSource;
import org.broad.igv.cli_plugin.PluginSource;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.tribble.Feature;

public class PluginDataSource
extends AbstractDataSource {
    private static Logger log = Logger.getLogger(PluginDataSource.class);
    private double dataMin;
    private double dataMax;
    private PluginSource<Feature, LocusScore> pluginFeatureSource;
    private Map<String, Integer> longestFeatureMap = new HashMap<String, Integer>();

    public PluginDataSource(Genome genome, List<String> commands, LinkedHashMap<Argument, Object> arguments, PluginSpecReader.Output outputAttr, String specPath) {
        super(genome);
        this.pluginFeatureSource = new PluginFeatureSource(commands, arguments, outputAttr, specPath);
    }

    @Override
    protected DataTile getRawData(String chr, int startLocation, int endLocation) {
        int queryLength = endLocation - startLocation;
        int longestFeature = this.getLongestFeature(chr);
        int adjustedStart = startLocation;
        int adjustedEnd = endLocation;
        if (queryLength < longestFeature) {
            int halfDiff = (longestFeature - queryLength) / 2;
            adjustedStart = startLocation - halfDiff - 1;
            adjustedEnd = endLocation + halfDiff;
        }
        try {
            Iterator<LocusScore> iter = this.pluginFeatureSource.getFeatures(chr, adjustedStart, adjustedEnd, -1);
            ArrayList<LocusScore> list = new ArrayList<LocusScore>(1000);
            this.dataMin = Double.MAX_VALUE;
            this.dataMax = -1.7976931348623157E308;
            while (iter.hasNext()) {
                LocusScore score = iter.next();
                this.dataMin = Math.min(this.dataMin, (double)score.getScore());
                this.dataMax = Math.max(this.dataMax, (double)score.getScore());
                list.add(score);
                longestFeature = Math.max(longestFeature, score.getEnd() - score.getStart());
            }
            this.longestFeatureMap.put(chr, longestFeature);
            int length = list.size();
            int[] startLocations = new int[length];
            int[] endLocations = new int[length];
            float[] scores = new float[length];
            String[] names = new String[length];
            int idx = 0;
            for (LocusScore locusScore : list) {
                startLocations[idx] = locusScore.getStart();
                endLocations[idx] = locusScore.getEnd();
                scores[idx] = locusScore.getScore();
                names[idx] = Locus.getFormattedLocusString(locusScore.getChr(), locusScore.getStart(), locusScore.getEnd());
                ++idx;
            }
            return new DataTile(startLocations, endLocations, scores, names);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<LocusScore> getPrecomputedSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return null;
    }

    @Override
    public int getLongestFeature(String chr) {
        return this.longestFeatureMap.containsKey(chr) ? this.longestFeatureMap.get(chr) : 1000;
    }

    @Override
    public double getDataMax() {
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        return this.dataMin;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.PLUGIN;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return Arrays.asList(WindowFunction.none);
    }
}

