/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMIndexer;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloserUtil;

public class BuildBamIndex
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BuildBamIndex.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generates a BAM index (.bai) file.";
    @Option(shortName="I", doc="A BAM file or URL to process. Must be sorted in coordinate order.")
    public String INPUT;
    URL inputUrl = null;
    File inputFile = null;
    @Option(shortName="O", doc="The BAM index file. Defaults to x.bai if INPUT is x.bam, otherwise INPUT.bai.\nIf INPUT is a URL and OUTPUT is unspecified, defaults to a file in the current directory.", optional=true)
    public File OUTPUT;

    public static void main(String[] argv) {
        System.exit(new BuildBamIndex().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        SAMFileReader bam;
        try {
            this.inputUrl = new URL(this.INPUT);
        }
        catch (MalformedURLException e) {
            this.inputFile = new File(this.INPUT);
        }
        if (this.OUTPUT == null) {
            String baseFileName;
            if (this.inputUrl != null) {
                String path = this.inputUrl.getPath();
                int lastSlash = path.lastIndexOf("/");
                baseFileName = path.substring(lastSlash + 1, path.length());
            } else {
                baseFileName = this.inputFile.getAbsolutePath();
            }
            if (baseFileName.endsWith(".bam")) {
                int index = baseFileName.lastIndexOf(".");
                this.OUTPUT = new File(baseFileName.substring(0, index) + ".bai");
            } else {
                this.OUTPUT = new File(baseFileName + ".bai");
            }
        }
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (this.inputUrl != null) {
            bam = new SAMFileReader(this.inputUrl, null, false);
        } else {
            IoUtil.assertFileIsReadable(this.inputFile);
            bam = new SAMFileReader(this.inputFile);
        }
        if (!bam.isBinary()) {
            throw new SAMException("Input file must be bam file, not sam file.");
        }
        if (!bam.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Input bam file must be sorted by coordinates");
        }
        BuildBamIndex.createIndex(bam, this.OUTPUT);
        log.info("Successfully wrote bam index file " + this.OUTPUT);
        CloserUtil.close(bam);
        return 0;
    }

    public static void createIndex(SAMFileReader reader, File output) {
        BAMIndexer indexer = new BAMIndexer(output, reader.getFileHeader());
        reader.enableFileSource(true);
        int totalRecords = 0;
        for (SAMRecord rec : reader) {
            if (++totalRecords % 1000000 == 0) {
                log.info(totalRecords + " reads processed ...");
            }
            indexer.processAlignment(rec);
        }
        indexer.finish();
    }
}

