/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.tribble.Feature;

public class FeatureSearcher
implements Runnable {
    private static Logger log = Logger.getLogger(FeatureSearcher.class);
    private FeatureTrack track = null;
    private FeatureSource<? extends Feature> source = null;
    private static final int DEFAULT_SEARCH_INCREMENT = 100000;
    private int searchIncrement;
    private int searchWindowSize = this.searchIncrement = 100000;
    private volatile Iterator<? extends Feature> result = null;
    private volatile boolean isRunning = false;
    private volatile boolean wasCancelled = false;
    private final Genome genome;
    private String chr;
    private int start;
    private int end;
    private IndefiniteProgressMonitor monitor;

    public FeatureSearcher(FeatureSource<? extends Feature> source, Genome genome, String chr, int start) {
        this(source, genome, chr, start, null);
    }

    public FeatureSearcher(FeatureSource<? extends Feature> source, Genome genome, String chr, int start, IndefiniteProgressMonitor monitor) {
        assert (source != null);
        this.source = source;
        this.genome = genome;
        this.monitor = monitor;
        this.initSearchCoords(chr, start);
    }

    private void initSearchCoords(String chr, int start) {
        this.chr = chr;
        this.start = start;
        this.end = start + this.searchWindowSize;
    }

    private void incrementSearchCoords() {
        boolean outsideBounds;
        this.start += this.searchIncrement;
        int maxCoord = Integer.MAX_VALUE - this.searchWindowSize;
        int minCoord = 0;
        if (this.genome != null) {
            maxCoord = this.genome.getChromosome(this.chr).getLength();
        }
        boolean bl = outsideBounds = this.start >= maxCoord || this.start < minCoord;
        if (outsideBounds) {
            String lastChr = this.chr;
            this.chr = null;
            if (this.genome != null) {
                if (this.start >= maxCoord) {
                    this.chr = this.genome.getNextChrName(lastChr);
                } else if (this.start < minCoord) {
                    this.chr = this.genome.getPrevChrName(lastChr);
                }
            }
            if (this.chr == null) {
                this.end = -1;
                this.start = -1;
                this.cancel();
                return;
            }
            maxCoord = this.genome.getChromosome(this.chr).getLength();
            this.start = this.searchIncrement > 0 ? minCoord : maxCoord - this.searchWindowSize;
        }
        this.end = this.start + this.searchWindowSize;
        this.end = Math.min(this.end, maxCoord);
    }

    private Iterator<? extends Feature> getFeatures(String chr, int start, int end) throws IOException {
        if (this.track != null) {
            return this.track.getFeatures(chr, start, end).iterator();
        }
        if (this.source != null) {
            return this.source.getFeatures(chr, start, end);
        }
        throw new IllegalStateException("Have no FeatureTrack or FeatureSource from which to get features");
    }

    public void cancel() {
        this.wasCancelled = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public Iterator<? extends Feature> getResult() {
        if (this.isRunning) {
            return null;
        }
        return this.result;
    }

    public void setSearchIncrement(int searchIncrement) {
        if (this.isRunning) {
            throw new IllegalStateException("Cannot set search increment while searching");
        }
        this.searchIncrement = searchIncrement;
        this.searchWindowSize = Math.abs(searchIncrement);
        this.end = this.start + this.searchWindowSize;
    }

    @Override
    public void run() {
        this.isRunning = true;
        Iterator<? extends Feature> rslt = null;
        int counter = 0;
        int updateInterval = 20 * (int)(100000.0 / (1.0 * (double)this.searchIncrement));
        updateInterval = Math.max(updateInterval, 100);
        if (this.monitor != null) {
            this.monitor.start();
        }
        while (this.isRunning && !this.wasCancelled) {
            try {
                if (this.monitor != null) {
                    if (counter == 0) {
                        String status = String.format("Searching: %s:%d-%d", this.chr, this.start, this.end);
                        this.monitor.updateStatus(status);
                    }
                    counter = (counter + 1) % updateInterval;
                }
                if ((rslt = this.getFeatures(this.chr, this.start, this.end)) != null && rslt.hasNext()) {
                    this.result = rslt;
                    break;
                }
                this.incrementSearchCoords();
            }
            catch (IOException e) {
                log.error("Error searching for feature", e);
                break;
            }
        }
        this.isRunning = false;
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    public static class GotoFeatureHandler
    implements IFeatureFound {
        @Override
        public void processResult(Iterator<? extends Feature> searchResult) {
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            Feature f = searchResult.next();
            String chr = GenomeManager.getInstance().getCurrentGenome().getChromosomeAlias(f.getChr());
            double newCenter = f.getStart();
            if (!chr.equals(frame.getChrName())) {
                double range = frame.getEnd() - frame.getOrigin();
                int newOrigin = (int)Math.max(newCenter - range / 2.0, 0.0);
                int newEnd = (int)((double)newOrigin + range);
                frame.jumpTo(chr, newOrigin, newEnd);
            } else {
                frame.centerOnLocation(newCenter);
            }
        }
    }

    public static interface IFeatureFound {
        public void processResult(Iterator<? extends Feature> var1);
    }
}

