/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Arrays;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.AlignmentBlockFS;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.FlowSignalContext;
import org.broad.igv.sam.FlowSignalSubContext;

public class AlignmentBlock {
    private String chr;
    private int start;
    private byte[] bases;
    private int length = -1;
    public byte[] qualities;
    protected short[] counts;
    private boolean softClipped = false;
    private Genome genome;

    public static AlignmentBlock getInstance(String chr, int start, byte[] bases, byte[] qualities) {
        return new AlignmentBlock(chr, start, bases, qualities);
    }

    public static AlignmentBlock getInstance(String chr, int start, byte[] bases, byte[] qualities, FlowSignalContext fContext) {
        return new AlignmentBlockFS(chr, start, bases, qualities, fContext);
    }

    protected AlignmentBlock(String chr, int start, byte[] bases, byte[] qualities) {
        this.chr = chr;
        this.start = start;
        this.bases = bases;
        this.length = bases.length;
        if (qualities == null || qualities.length < bases.length) {
            this.qualities = new byte[bases.length];
            Arrays.fill(this.qualities, (byte)126);
        } else {
            this.qualities = qualities;
        }
        this.counts = null;
    }

    public boolean contains(int position) {
        int offset = position - this.start;
        return offset >= 0 && offset < this.getLength();
    }

    public byte[] getBases() {
        if (this.bases != null) {
            return this.bases;
        }
        return this.getReferenceSequence();
    }

    private byte[] getReferenceSequence() {
        return this.genome.getSequence(this.chr, this.getStart(), this.getEnd());
    }

    public int getLength() {
        return this.length;
    }

    public byte getBase(int offset) {
        return this.getBases()[offset];
    }

    public int getStart() {
        return this.start;
    }

    public byte getQuality(int offset) {
        return this.getQualities()[offset];
    }

    public byte[] getQualities() {
        return this.qualities;
    }

    public short getCount(int i) {
        return this.counts[i];
    }

    public void setCounts(short[] counts) {
        this.counts = counts;
    }

    public int getEnd() {
        return this.start + this.getLength();
    }

    public boolean isSoftClipped() {
        return this.softClipped;
    }

    public void setSoftClipped(boolean softClipped) {
        this.softClipped = softClipped;
    }

    public boolean hasFlowSignals() {
        return false;
    }

    public boolean hasCounts() {
        return this.counts != null;
    }

    public FlowSignalSubContext getFlowSignalSubContext(int offset) {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[block ");
        sb.append(this.isSoftClipped() ? "softClipped " : " ");
        sb.append(this.getStart());
        sb.append("-");
        sb.append(this.getEnd());
        sb.append(" ");
        for (int i = 0; i < this.bases.length; ++i) {
            sb.append((char)this.bases[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public void reduce(Genome genome) {
        this.genome = genome;
        byte[] refBases = genome.getSequence(this.chr, this.getStart(), this.getEnd());
        if (refBases != null) {
            boolean match = false;
            for (int idx = 0; idx < refBases.length && (match = AlignmentUtils.compareBases(refBases[idx], this.bases[idx])); ++idx) {
            }
            if (match) {
                this.bases = null;
            }
        }
    }

    public boolean hasBases() {
        return this.bases != null;
    }
}

