/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.util.Map;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.track.WindowFunction;

public class EQTLFeature
extends AbstractFeature {
    private String snp;
    String chr;
    int position;
    private String geneId;
    private String geneName;
    Map<String, String> attributes;

    public EQTLFeature(String snp, String chr, int position, String geneId, String geneName, Map<String, String> attributes) {
        this.snp = snp;
        this.chr = chr;
        this.position = position;
        this.geneId = geneId;
        this.geneName = geneName;
        this.attributes = attributes;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.position;
    }

    @Override
    public int getEnd() {
        return this.position + 1;
    }

    public String getSnp() {
        return this.snp;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getGeneName() {
        return this.geneName;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.snp);
        sb.append("<br>" + this.geneId);
        sb.append("<br>" + this.geneName);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            sb.append("<br>" + entry.getKey() + " = " + entry.getValue());
        }
        return sb.toString();
    }

    @Override
    public String getURL() {
        return null;
    }
}

