/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.SequenceOntology;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.collections.CI;
import org.broad.igv.util.collections.MultiMap;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.readers.LineReader;

public class GFFCodec
extends AsciiFeatureCodec<Feature> {
    private static Logger log = Logger.getLogger(GFFCodec.class);
    static HashSet<String> ignoredTypes = new HashSet();
    private TrackProperties trackProperties = null;
    CI.CIHashSet featuresToHide = new CI.CIHashSet();
    FeatureFileHeader header;
    Helper helper;
    Genome genome;
    static String[] nameFields;
    static StringBuffer buf;

    public GFFCodec(Genome genome) {
        super(Feature.class);
        this.helper = new GFF2Helper();
        this.genome = genome;
    }

    public GFFCodec(Version version, Genome genome) {
        super(Feature.class);
        this.genome = genome;
        this.helper = version == Version.GFF2 ? new GFF2Helper() : new GFF3Helper();
    }

    public void readHeaderLine(String line) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
        }
        if (line.startsWith("#track") || line.startsWith("##track")) {
            this.trackProperties = new TrackProperties();
            ParsingUtils.parseTrackLine(line, this.trackProperties);
            this.header.setTrackProperties(this.trackProperties);
        } else if (line.startsWith("##gff-version") && line.endsWith("3")) {
            this.helper = new GFF3Helper();
        } else if (line.startsWith("#nodecode") || line.startsWith("##nodecode")) {
            this.helper.setUrlDecoding(false);
        } else if (line.startsWith("#hide") || line.startsWith("##hide")) {
            String[] kv = line.split("=");
            if (kv.length > 1) {
                this.featuresToHide.addAll(Arrays.asList(kv[1].split(",")));
            }
        } else if (line.startsWith("#displayName") || line.startsWith("##displayName")) {
            String[] nameTokens = line.split("=");
            if (nameTokens.length < 2) {
                this.helper.setNameFields(null);
            } else {
                String[] fields = nameTokens[1].split(",");
                this.helper.setNameFields(fields);
            }
        }
    }

    @Override
    public Object readHeader(LineReader reader) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
        }
        int nLines = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null && line.startsWith("#")) {
                ++nLines;
                this.readHeaderLine(line);
            }
            this.header.setTrackProperties(this.trackProperties);
            return this.header;
        }
        catch (IOException e) {
            throw new CodecLineParsingException("Error parsing header", e);
        }
    }

    @Override
    public boolean canDecode(String path) {
        String pathLowerCase = path.toLowerCase();
        return pathLowerCase.endsWith(".gff") || pathLowerCase.endsWith(".gff3") || pathLowerCase.endsWith(".gvf");
    }

    @Override
    public BasicFeature decodeLoc(String line) {
        return this.decode(line);
    }

    @Override
    public BasicFeature decode(String line) {
        String[] colorNames;
        String phaseString;
        int end;
        int start;
        if (line.startsWith("#")) {
            return null;
        }
        String[] tokens = Globals.tabPattern.split(line, -1);
        int nTokens = tokens.length;
        if (nTokens < 9) {
            return null;
        }
        String chrToken = tokens[0].trim();
        String featureType = StringUtils.intern(tokens[2].trim());
        if (ignoredTypes.contains(featureType)) {
            return null;
        }
        String chromosome = this.genome == null ? StringUtils.intern(chrToken) : this.genome.getChromosomeAlias(chrToken);
        int col = 3;
        try {
            start = Integer.parseInt(tokens[col]) - 1;
            if (start < 0) {
                throw new ParserException("Start index must be 1 or larger; GFF is 1-based", -1L, line);
            }
            end = Integer.parseInt(tokens[++col]);
        }
        catch (NumberFormatException ne) {
            String msg = String.format("Column %d must contain a numeric value. %s", col + 1, ne.getMessage());
            throw new ParserException(msg, -1L, line);
        }
        Strand strand = this.convertStrand(tokens[6]);
        String attributeString = tokens[8];
        MultiMap<String, String> attributes = new MultiMap<String, String>();
        this.helper.parseAttributes(attributeString, attributes);
        String id = this.helper.getID(attributes);
        String[] parentIds = this.helper.getParentIds(attributes, attributeString);
        BasicFeature f = new BasicFeature(chromosome, start, end, strand);
        if (SequenceOntology.utrTypes.contains(featureType)) {
            boolean plus;
            boolean bl = plus = SequenceOntology.fivePrimeUTRTypes.contains(featureType) && strand == Strand.POSITIVE || SequenceOntology.threePrimeUTRTypes.contains(featureType) && strand == Strand.NEGATIVE;
            if (plus) {
                f.setThickStart(end);
            } else {
                f.setThickEnd(end);
            }
        }
        if (!(phaseString = tokens[7].trim()).equals(".")) {
            int phaseNum = Integer.parseInt(phaseString);
            f.setReadingFrame(phaseNum);
        }
        f.setName(this.helper.getName(attributes));
        f.setType(featureType);
        id = id != null ? id : "igv_" + UUID.randomUUID().toString();
        f.setIdentifier(id);
        f.setParentIds(parentIds);
        f.setAttributes(attributes);
        for (String colorName : colorNames = new String[]{"color", "Color", "colour", "Colour"}) {
            if (!attributes.containsKey(colorName)) continue;
            f.setColor(ColorUtilities.stringToColor(attributes.get(colorName)));
            break;
        }
        if (this.featuresToHide.contains(featureType)) {
            if (IGV.hasInstance()) {
                FeatureDB.addFeature(f, this.genome);
            }
            return null;
        }
        return f;
    }

    public Object getHeader() {
        return this.header;
    }

    private Strand convertStrand(String strandString) {
        Strand strand = Strand.NONE;
        if (strandString.equals("-")) {
            strand = Strand.NEGATIVE;
        } else if (strandString.equals("+")) {
            strand = Strand.POSITIVE;
        }
        return strand;
    }

    static String getDescription(MultiMap<String, String> attributes, String type) {
        buf.setLength(0);
        buf.append(type);
        buf.append("<br>");
        attributes.printHtml(buf, 100);
        return buf.toString();
    }

    static {
        ignoredTypes.add("start_codon");
        ignoredTypes.add("stop_codon");
        ignoredTypes.add("Contig");
        ignoredTypes.add("RealContig");
        nameFields = new String[]{"Name", "name", "Alias", "gene", "primary_name", "locus", "alias", "systematic_id", "ID", "transcript_id"};
        buf = new StringBuffer();
    }

    public static class GFF3Helper
    implements Helper {
        static String[] DEFAULT_NAME_FIELDS = new String[]{"Name", "Alias", "ID", "gene", "locus"};
        private boolean useUrlDecoding = true;
        private String[] nameFields;

        public GFF3Helper() {
            this(DEFAULT_NAME_FIELDS);
        }

        GFF3Helper(String[] nameFields) {
            if (nameFields != null) {
                this.nameFields = nameFields;
            }
        }

        @Override
        public String[] getParentIds(MultiMap<String, String> attributes, String ignored) {
            String parentIdString = attributes.get("Parent");
            if (parentIdString != null) {
                return parentIdString.split(",");
            }
            return null;
        }

        @Override
        public void parseAttributes(String description, MultiMap<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                List<String> tmp = StringUtils.breakQuotedString(kv, '=');
                int nValues = tmp.size();
                if (nValues > 0) {
                    String value;
                    String key = tmp.get(0).trim();
                    String string = value = nValues == 1 ? "" : tmp.get(1).trim();
                    if (this.useUrlDecoding) {
                        key = StringUtils.decodeURL(key);
                        if ((value = StringUtils.decodeURL(value)).length() > 50) {
                            value = value.substring(0, 50) + " ...";
                        }
                    }
                    kvalues.put(StringUtils.intern(key), value);
                    continue;
                }
                log.info("No attributes: " + description);
            }
        }

        @Override
        public void setUrlDecoding(boolean useUrlDecoding) {
            this.useUrlDecoding = useUrlDecoding;
        }

        @Override
        public String getName(MultiMap<String, String> attributes) {
            if (attributes.size() > 0 && this.nameFields != null) {
                for (String nf : this.nameFields) {
                    if (!attributes.containsKey(nf)) continue;
                    return attributes.get(nf);
                }
            }
            return null;
        }

        @Override
        public String getID(MultiMap<String, String> attributes) {
            return attributes.get("ID");
        }

        @Override
        public void setNameFields(String[] nameFields) {
            this.nameFields = nameFields;
        }
    }

    public static class GFF2Helper
    implements Helper {
        static String[] DEFAULT_NAME_FIELDS = new String[]{"alias", "gene", "ID", "Locus", "locus", "Name", "name", "primary_name", "systematic_id", "transcript_id"};
        static List<String> idFields = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_FIELDS));
        static String[] possParentNames;
        private String[] nameFields;

        GFF2Helper() {
            this(DEFAULT_NAME_FIELDS);
        }

        GFF2Helper(String[] nameFields) {
            if (nameFields != null) {
                this.nameFields = nameFields;
            }
        }

        @Override
        public void setUrlDecoding(boolean b) {
        }

        @Override
        public void parseAttributes(String description, MultiMap<String, String> kvalues) {
            List<String> kvPairs = StringUtils.breakQuotedString(description.trim(), ';');
            for (String kv : kvPairs) {
                String[] tokens = kv.split(" ");
                if (tokens.length == 1) {
                    tokens = kv.split("=");
                }
                if (tokens.length < 2) continue;
                String key = tokens[0].trim().replaceAll("\"", "");
                String value = tokens[1].trim().replaceAll("\"", "");
                kvalues.put(StringUtils.intern(key), value);
            }
        }

        @Override
        public String[] getParentIds(MultiMap<String, String> attributes, String attributeString) {
            String[] parentIds = new String[1];
            if (attributes.size() == 0) {
                parentIds[0] = attributeString;
            } else {
                for (String possName : possParentNames) {
                    if (!attributes.containsKey(possName)) continue;
                    parentIds[0] = attributes.get(possName);
                    break;
                }
            }
            return parentIds;
        }

        @Override
        public String getID(MultiMap<String, String> attributes) {
            for (String nf : idFields) {
                if (!attributes.containsKey(nf)) continue;
                return attributes.get(nf);
            }
            return this.getName(attributes);
        }

        @Override
        public String getName(MultiMap<String, String> attributes) {
            if (attributes.size() > 0 && this.nameFields != null) {
                for (String nf : this.nameFields) {
                    if (!attributes.containsKey(nf)) continue;
                    return attributes.get(nf);
                }
            }
            return null;
        }

        @Override
        public void setNameFields(String[] nameFields) {
            this.nameFields = nameFields;
        }

        static {
            idFields.add("transcript_id");
            possParentNames = new String[]{"transcript_id", "id", "mRNA", "systematic_id", "gene", "transcriptId", "Parent", "proteinId"};
        }
    }

    protected static interface Helper {
        public String[] getParentIds(MultiMap<String, String> var1, String var2);

        public void parseAttributes(String var1, MultiMap<String, String> var2);

        public String getID(MultiMap<String, String> var1);

        public void setUrlDecoding(boolean var1);

        public String getName(MultiMap<String, String> var1);

        public void setNameFields(String[] var1);
    }

    public static enum Version {
        GFF2,
        GFF3;

    }
}

