/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.exome;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.exome.ExomeBlock;
import org.broad.igv.feature.exome.ExomeUtils;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.tribble.Feature;

public class ExomeReferenceFrame
extends ReferenceFrame {
    private static Logger log = Logger.getLogger(ExomeReferenceFrame.class);
    Map<String, ExomeData> exomeBlockData = new HashMap<String, ExomeData>();
    int firstBlockIdx;
    int exomeOrigin;
    private int blockGap;
    private static final Comparator<ExomeBlock> GENOME_POSITION_COMPARATOR = new Comparator<ExomeBlock>(){

        @Override
        public int compare(ExomeBlock o1, ExomeBlock o2) {
            int genomeStart1;
            int genomeStart2 = o2.getGenomeStart();
            if (genomeStart2 >= (genomeStart1 = o1.getGenomeStart()) && o2.getGenomeEnd() <= o1.getGenomeEnd()) {
                return 0;
            }
            return genomeStart1 - genomeStart2;
        }
    };
    private static final Comparator<ExomeBlock> EXOME_POSITION_COMPARATOR = new Comparator<ExomeBlock>(){

        @Override
        public int compare(ExomeBlock o1, ExomeBlock o2) {
            int exomeStart1;
            int exomeStart2 = o2.getExomeStart();
            if (exomeStart2 >= (exomeStart1 = o1.getExomeStart()) && o2.getExomeEnd() <= o1.getExomeEnd()) {
                return 0;
            }
            return exomeStart1 - exomeStart2;
        }
    };

    public ExomeReferenceFrame(ReferenceFrame otherFrame, FeatureTrack referenceTrack) {
        super(otherFrame);
        this.init(referenceTrack);
    }

    public ExomeReferenceFrame(ReferenceFrame otherFrame, Map<String, List<Feature>> featureMap) {
        super(otherFrame);
        this.init(featureMap);
    }

    private void init(FeatureTrack geneTrack) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        for (Chromosome chromosome : genome.getChromosomes()) {
            String chr = chromosome.getName();
            List<Feature> features = geneTrack.getFeatures(chr, 0, chromosome.getLength());
            if (features == null || features.size() <= 0) continue;
            this.createExomBlockData(chr, features);
        }
    }

    private void init(Map<String, List<Feature>> featureMap) {
        for (String chr : featureMap.keySet()) {
            List<Feature> features = featureMap.get(chr);
            if (features.size() <= 0) continue;
            this.createExomBlockData(chr, features);
        }
    }

    private void createExomBlockData(String chr, List<Feature> features) {
        List<ExomeBlock> blocks = ExomeUtils.collapseTranscripts(features);
        List<Gene> genes = ExomeUtils.collapseToGenes(features);
        ExomeData exomeData = new ExomeData(blocks, genes);
        this.exomeBlockData.put(chr, exomeData);
    }

    @Override
    public void shiftOriginPixels(int delta) {
        List<ExomeBlock> blocks;
        ExomeBlock b;
        int comp;
        if (this.exomeOrigin == 0 && delta < 0) {
            return;
        }
        double shiftBP = (double)delta * this.getScale();
        this.exomeOrigin = (int)((double)this.exomeOrigin + shiftBP);
        if (this.exomeOrigin < 0) {
            this.exomeOrigin = 0;
        }
        if ((comp = (b = (blocks = this.getBlocks(this.getChrName())).get(this.firstBlockIdx)).compareExomePosition(this.exomeOrigin)) > 0) {
            while (this.firstBlockIdx < blocks.size() - 1) {
                ++this.firstBlockIdx;
                b = blocks.get(this.firstBlockIdx);
                if (b.compareExomePosition(this.exomeOrigin) > 0) continue;
                break;
            }
        } else if (comp < 0) {
            while (this.firstBlockIdx > 0) {
                --this.firstBlockIdx;
                b = blocks.get(this.firstBlockIdx);
                if (b.compareExomePosition(this.exomeOrigin) < 0) continue;
            }
        }
        double genomePosition = b.getGenomeStart() + (this.exomeOrigin - b.getExomeStart());
        this.setOrigin(genomePosition);
    }

    private void calcExomeOrigin() {
        List<ExomeBlock> blocks = this.getBlocks(this.chrName);
        this.firstBlockIdx = ExomeReferenceFrame.getIndexForGenomePosition(blocks, this.origin);
        ExomeBlock firstBlock = blocks.get(this.firstBlockIdx);
        this.exomeOrigin = this.origin > (double)firstBlock.getGenomeEnd() ? firstBlock.getExomeEnd() : firstBlock.getExomeStart() + (int)(this.origin - (double)firstBlock.getGenomeStart());
    }

    @Override
    public void setOrigin(double genomePosition) {
        super.setOrigin(genomePosition);
        this.calcExomeOrigin();
    }

    @Override
    public void jumpTo(String chr, int start, int end) {
        this.jumpTo(new Locus(chr, start, end));
        IGV.repaintPanelsHeadlessSafe();
    }

    @Override
    public void jumpTo(Locus locus) {
        this.initialLocus = locus;
        this.chrName = locus.getChr();
        this.origin = locus.getStart();
        int genomeEnd = locus.getEnd();
        this.calcExomeOrigin();
        int exomeEnd = Math.max(this.exomeOrigin + 40, this.genomeToExomePosition(genomeEnd));
        int bp = exomeEnd - this.exomeOrigin;
        int pw = this.widthInPixels <= 0 ? 1000 : this.widthInPixels;
        this.locationScale = (double)bp / (double)pw;
        this.setZoom(this.calculateZoom(this.exomeOrigin, exomeEnd));
    }

    @Override
    public synchronized void doSetZoomCenter(int newZoom, double newCenter) {
        newZoom = Math.max(0, Math.min(newZoom, this.maxZoom));
        double zoomFactor = Math.pow(2.0, newZoom - this.zoom);
        int currentBPLength = (int)(this.locationScale * (double)this.widthInPixels);
        int delta = (int)((double)currentBPLength / (2.0 * zoomFactor));
        int exomeCenter = this.genomeToExomePosition((int)newCenter);
        this.exomeOrigin = exomeCenter - delta;
        this.origin = this.exomeToGenomePosition(this.exomeOrigin);
        this.locationScale /= zoomFactor;
        this.zoom = newZoom;
        List<ExomeBlock> blocks = this.getBlocks(this.chrName);
        this.firstBlockIdx = ExomeReferenceFrame.getIndexForGenomePosition(blocks, this.origin);
        IGV.repaintPanelsHeadlessSafe();
    }

    @Override
    public double getChromosomePosition(int screenPosition) {
        double exomePosition = (double)this.exomeOrigin + this.getScale() * (double)screenPosition;
        return this.exomeToGenomePosition((int)exomePosition);
    }

    @Override
    protected double getGenomeCenterPosition() {
        double centerExomePosition = (double)this.exomeOrigin + this.getScale() * (double)this.widthInPixels / 2.0;
        return this.exomeToGenomePosition((int)centerExomePosition);
    }

    @Override
    public double getEnd() {
        int exomeEnd = this.exomeOrigin + (int)(this.locationScale * (double)this.widthInPixels);
        int genomeEnd = this.exomeToGenomePosition(exomeEnd);
        return genomeEnd;
    }

    public int genomeToExomePosition(int genomePosition) {
        int idx;
        ExomeData ed = this.exomeBlockData.get(this.chrName);
        if (ed == null) {
            return -1;
        }
        List<ExomeBlock> blocks = ed.getBlocks();
        ExomeBlock b = blocks.get(idx = ExomeReferenceFrame.getIndexForGenomePosition(blocks, genomePosition));
        if (genomePosition < b.getGenomeStart()) {
            return b.getExomeStart();
        }
        return genomePosition < b.getGenomeEnd() ? b.getExomeStart() + (genomePosition - b.getGenomeStart()) : b.getExomeEnd();
    }

    public int exomeToGenomePosition(int exomePosition) {
        ExomeData ed = this.exomeBlockData.get(this.chrName);
        if (ed == null) {
            return -1;
        }
        List<ExomeBlock> blocks = ed.getBlocks();
        ExomeBlock b = this.getBlockAtExomePosition(blocks, exomePosition);
        if (b != null) {
            return b.getGenomeStart() + (exomePosition - b.getExomeStart());
        }
        b = blocks.get(blocks.size() - 1);
        return b.getGenomeEnd();
    }

    public List<ExomeBlock> getBlocks(String chr) {
        ExomeData exomeData = this.exomeBlockData.get(chr);
        return exomeData == null ? null : exomeData.blocks;
    }

    public List<Gene> getGenes(String chr) {
        ExomeData exomeData = this.exomeBlockData.get(chr);
        return exomeData == null ? null : exomeData.genes;
    }

    private ExomeBlock getBlockAtExomePosition(List<ExomeBlock> blocks, int exomePosition) {
        ExomeBlock key = new ExomeBlock(-1, -1, exomePosition, 1);
        int r = Collections.binarySearch(blocks, key, EXOME_POSITION_COMPARATOR);
        if (r >= 0) {
            return blocks.get(r);
        }
        return null;
    }

    public static int getIndexForGenomePosition(List<ExomeBlock> blocks, double position) {
        int idx;
        int startIdx = 0;
        int endIdx = blocks.size() - 1;
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)blocks.get(idx).getGenomeStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        if ((double)blocks.get(endIdx).getGenomeStart() >= position) {
            for (idx = endIdx; idx >= 0; --idx) {
                if (!((double)blocks.get(idx).getGenomeStart() <= position)) continue;
                return idx;
            }
            return 0;
        }
        for (idx = endIdx + 1; idx < blocks.size(); ++idx) {
            if (!((double)blocks.get(idx).getGenomeStart() >= position)) continue;
            return idx - 1;
        }
        return blocks.size() - 1;
    }

    public List<ExomeBlock> getBlocks() {
        return this.getBlocks(this.getChrName());
    }

    public int getFirstBlockIdx() {
        return this.firstBlockIdx;
    }

    @Override
    public boolean isExomeMode() {
        return true;
    }

    public int getExomeOrigin() {
        return this.exomeOrigin;
    }

    public int getBlockGap() {
        return 0;
    }

    public static class ExomeData {
        private List<ExomeBlock> blocks;
        private List<Gene> genes;

        ExomeData(List<ExomeBlock> block, List<Gene> genes) {
            this.blocks = block;
            this.genes = genes;
        }

        public List<ExomeBlock> getBlocks() {
            return this.blocks;
        }

        public List<Gene> getGenes() {
            return this.genes;
        }
    }

    public static class Gene
    implements NamedFeature {
        String name;
        String chr;
        int start;
        int end;

        Gene(NamedFeature f) {
            this.name = f.getName();
            this.chr = f.getChr();
            this.start = f.getStart();
            this.end = f.getEnd();
        }

        @Override
        public String getChr() {
            return this.chr;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void expand(Feature f) {
            this.start = Math.min(this.start, f.getStart());
            this.end = Math.max(this.end, f.getEnd());
        }
    }
}

