/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.tribble.Feature;

@XmlAccessorType(value=XmlAccessType.NONE)
public class CombinedDataSource
implements DataSource {
    private static Logger log = Logger.getLogger(CombinedDataSource.class);
    @XmlJavaTypeAdapter(value=DataTrackAdapter.class)
    @XmlAttribute(name="source0")
    DataTrack source0;
    @XmlJavaTypeAdapter(value=DataTrackAdapter.class)
    @XmlAttribute(name="source1")
    DataTrack source1;
    @XmlAttribute
    Operation operation = Operation.ADD;

    private CombinedDataSource() {
    }

    public CombinedDataSource(DataTrack source0, DataTrack source1, Operation operation) {
        this.source0 = source0;
        this.source1 = source1;
        this.operation = operation;
    }

    public void updateTrackReferences(List<Track> allTracks) {
        this.source0 = this.updateTrackReference(this.source0, allTracks);
        this.source1 = this.updateTrackReference(this.source1, allTracks);
    }

    private DataTrack updateTrackReference(DataTrack memberTrack, List<Track> allTracks) {
        if (memberTrack.getName() == null && memberTrack.getResourceLocator() == null) {
            DataTrack matchingTrack = (DataTrack)IGVSessionReader.getMatchingTrack(memberTrack.getId(), allTracks);
            if (matchingTrack == null) {
                throw new IllegalStateException("Could not find track with ID " + memberTrack.getId());
            }
            return matchingTrack;
        }
        return memberTrack;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        float newVal;
        List<LocusScore> outerScores = this.source0.getSummaryScores(chr, startLocation, endLocation, zoom);
        List<LocusScore> innerScores = this.source1.getSummaryScores(chr, startLocation, endLocation, zoom);
        int initialSize = outerScores.size() + innerScores.size();
        ArrayList<LocusScore> combinedScoresList = new ArrayList<LocusScore>(initialSize);
        if (initialSize == 0) {
            return combinedScoresList;
        }
        if (innerScores.size() == 0) {
            return outerScores;
        }
        if (outerScores.size() == 0) {
            return innerScores;
        }
        if (outerScores.get(0).getStart() > innerScores.get(0).getStart()) {
            List<LocusScore> tmp = innerScores;
            innerScores = outerScores;
            outerScores = tmp;
        }
        int firstInnerStart = innerScores.get(0).getStart();
        Feature lastScoreAdded = null;
        int highestInnerIdx = -1;
        for (LocusScore outerScore : outerScores) {
            int outerStart = outerScore.getStart();
            int outerEnd = outerScore.getEnd();
            highestInnerIdx = -1;
            if (firstInnerStart > outerStart) {
                int newEnd = Math.min(outerEnd, firstInnerStart);
                newVal = this.combineScores(outerScore, null);
                lastScoreAdded = new BasicScore(outerStart, newEnd, newVal);
                combinedScoresList.add((LocusScore)lastScoreAdded);
                if (firstInnerStart >= outerEnd) continue;
            }
            for (LocusScore innerScore : innerScores) {
                if (innerScore.getStart() >= outerEnd) break;
                ++highestInnerIdx;
                if (innerScore.getEnd() <= outerStart) continue;
                int nextStart = Math.max(outerStart, innerScore.getStart());
                int nextEnd = Math.min(outerEnd, innerScore.getEnd());
                float nextVal = this.combineScores(outerScore, innerScore);
                lastScoreAdded = new BasicScore(nextStart, nextEnd, nextVal);
                combinedScoresList.add((LocusScore)lastScoreAdded);
            }
        }
        LocusScore innerTail = innerScores.get(highestInnerIdx);
        if (lastScoreAdded != null && lastScoreAdded.getEnd() < innerTail.getEnd()) {
            int combinedStart = Math.min(lastScoreAdded.getEnd(), innerTail.getEnd());
            BasicScore newTail = new BasicScore(combinedStart, innerTail.getEnd(), innerTail.getScore());
            combinedScoresList.add(newTail);
            for (LocusScore innerScore : innerScores.subList(highestInnerIdx + 1, innerScores.size())) {
                newVal = this.combineScores(null, innerScore);
                combinedScoresList.add(new BasicScore(innerScore.getStart(), innerScore.getEnd(), newVal));
            }
        }
        return combinedScoresList;
    }

    private float combineScores(LocusScore score1, LocusScore score2) {
        if (score1 == null && score2 == null) {
            throw new IllegalArgumentException("Both inputs cannot be null");
        }
        if (score1 == null) {
            score1 = new BasicScore(score2.getStart(), score2.getEnd(), 0.0f);
        } else if (score2 == null) {
            score2 = new BasicScore(score1.getStart(), score1.getEnd(), 0.0f);
        }
        switch (this.operation) {
            case ADD: {
                return score1.getScore() + score2.getScore();
            }
            case SUBTRACT: {
                return score1.getScore() - score2.getScore();
            }
        }
        throw new IllegalStateException("Operation not recognized: " + (Object)((Object)this.operation));
    }

    @Override
    public double getDataMax() {
        return 0.0;
    }

    @Override
    public double getDataMin() {
        return 0.0;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.PLUGIN;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.none;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList<WindowFunction>();
    }

    @Override
    public void dispose() {
        if (this.source0 != null) {
            this.source0.dispose();
        }
        if (this.source1 != null) {
            this.source1.dispose();
        }
    }

    private static class DataTrackAdapter
    extends XmlAdapter<String, DataTrack> {
        private DataTrackAdapter() {
        }

        public String marshal(DataTrack dataTrack) throws Exception {
            return dataTrack.getId();
        }

        public DataTrack unmarshal(String trackId) throws Exception {
            DataTrack dataTrack = (DataTrack)IGVSessionReader.getMatchingTrack(trackId, null);
            if (dataTrack == null) {
                dataTrack = new DataSourceTrack(null, trackId, null, null);
            }
            return dataTrack;
        }
    }

    static class MergedIterator
    implements Iterator<LocusScore> {
        Iterator i1;
        Iterator i2;
        LocusScore next1;
        LocusScore next2;

        MergedIterator(Iterator<LocusScore> i1, Iterator<LocusScore> i2) {
            this.i1 = i1;
            this.i2 = i2;
            if (i1.hasNext()) {
                this.next1 = i1.next();
            }
            if (i2.hasNext()) {
                this.next2 = i2.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next1 != null || this.next2 != null;
        }

        @Override
        public LocusScore next() {
            if (this.next1 == null) {
                return this.next2;
            }
            if (this.next2 == null) {
                return this.next1;
            }
            if (this.next2.getStart() < this.next1.getStart()) {
                return this.next2;
            }
            return this.next1;
        }

        @Override
        public void remove() {
        }
    }

    public static enum Operation {
        ADD("+"),
        SUBTRACT("-");

        private String stringRep;

        private Operation(String stringrep) {
            this.stringRep = stringrep;
        }
    }
}

